/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.aspects.support;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.neo4j.helpers.collection.IteratorUtil;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.neo4j.aspects.Friendship;
import org.springframework.data.neo4j.aspects.Group;
import org.springframework.data.neo4j.aspects.Person;
import org.springframework.data.neo4j.aspects.support.EntityTestBase;
import org.springframework.data.neo4j.aspects.support.TestTeam;
import org.springframework.data.neo4j.conversion.EndResult;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.aspectj.AnnotationTransactionAspect;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:org/springframework/data/neo4j/aspects/support/Neo4jGraphPersistenceTests-context.xml"})
public class FinderTests
extends EntityTestBase {
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;

    @Test
    @Transactional
    public void testFinderFindAll() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_0);
                Person p1 = Person.persistedPerson("Michael", 35);
                Person p2 = Person.persistedPerson("David", 25);
                EndResult allPersons = this.personRepository.findAll();
                Assert.assertThat((Object)IteratorUtil.asCollection((Iterable)allPersons), (Matcher)Matchers.hasItems((Object[])new Person[]{p1, p2}));
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void testFindIterableOfPersonWithQueryAnnotation() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_1);
                this.testTeam.createSDGTeam();
                Iterable<Person> teamMembers = this.personRepository.findAllTeamMembers(this.testTeam.sdg);
                Assert.assertThat((Object)IteratorUtil.asCollection(teamMembers), (Matcher)Matchers.hasItems((Object[])new Person[]{this.testTeam.michael, this.testTeam.david, this.testTeam.emil}));
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void testFindPersonWithQueryAnnotation() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_2);
                this.testTeam.createSDGTeam();
                Person boss = this.personRepository.findBoss(this.testTeam.michael);
                Assert.assertThat((Object)boss, (Matcher)CoreMatchers.is((Object)this.testTeam.emil));
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void testFindIterableMapsWithQueryAnnotation() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_3);
                TestTeam testTeam = new TestTeam(this.neo4jTemplate);
                testTeam.createSDGTeam();
                Iterable<Map<String, Object>> teamMembers = this.personRepository.findAllTeamMemberData(testTeam.sdg);
                Assert.assertThat((Object)IteratorUtil.asCollection(teamMembers), (Matcher)Matchers.hasItems((Object[])new Map[]{testTeam.simpleRowFor(testTeam.michael, "member"), testTeam.simpleRowFor(testTeam.david, "member"), testTeam.simpleRowFor(testTeam.emil, "member")}));
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void testFindByNamedQuery() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_4);
                TestTeam testTeam = new TestTeam(this.neo4jTemplate);
                testTeam.createSDGTeam();
                Group team = this.personRepository.findTeam(testTeam.michael);
                Assert.assertThat((Object)team, (Matcher)CoreMatchers.is((Object)testTeam.sdg));
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void testSaveManyPeople() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_5);
                Person p1 = new Person("Michael", 35);
                Person p2 = new Person("David", 25);
                this.personRepository.save(Arrays.asList(p1, p2));
                Assert.assertEquals((String)"persisted person 1", (Object)true, (Object)this.hasPersistentState(p1));
                Assert.assertEquals((String)"persisted person 2", (Object)true, (Object)this.hasPersistentState(p2));
                Assert.assertThat((Object)IteratorUtil.asCollection((Iterable)this.personRepository.findAll()), (Matcher)Matchers.hasItems((Object[])new Person[]{p2, p1}));
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void testSavePerson() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_6);
                Person p1 = new Person("Michael", 35);
                this.personRepository.save(p1);
                Assert.assertEquals((String)"persisted person", (Object)true, (Object)this.hasPersistentState(p1));
                Assert.assertThat((Object)((Person)this.personRepository.findOne(p1.getId())), (Matcher)CoreMatchers.is((Object)p1));
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    public void testDeletePerson() {
        Person p1 = Person.persistedPerson("Michael", 35);
        this.personRepository.delete(p1);
        Assert.assertEquals((String)"people deleted", (Object)false, (Object)this.personRepository.findAll().iterator().hasNext());
    }

    @Test
    public void testDeletePeople() {
        Person p1 = Person.persistedPerson("Michael", 35);
        Person p2 = Person.persistedPerson("David", 26);
        this.personRepository.delete(Arrays.asList(p1, p2));
        Assert.assertEquals((String)"people deleted", (Object)false, (Object)this.personRepository.findAll().iterator().hasNext());
    }

    @Test
    @Transactional
    public void testFindRelationshipEntity() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_7);
                Person p1 = Person.persistedPerson("Michael", 35);
                Person p2 = Person.persistedPerson("David", 27);
                Friendship friendship = p1.knows(p2);
                Assert.assertEquals((String)"Wrong friendship count.", (long)1L, (long)this.friendshipRepository.count());
                Assert.assertEquals((Object)friendship, (Object)this.friendshipRepository.findOne(this.getRelationshipId(friendship)));
                Assert.assertEquals((String)"Did not find friendship.", Collections.singleton(friendship), new HashSet(IteratorUtil.asCollection((Iterable)this.friendshipRepository.findAll())));
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void testFinderFindById() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_8);
                Person p = Person.persistedPerson("Michael", 35);
                Person pById = (Person)this.personRepository.findOne(this.getNodeId(p));
                Assert.assertEquals((Object)p, (Object)pById);
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void testExists() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_9);
                Person p = Person.persistedPerson("Michael", 35);
                boolean found = this.personRepository.exists(this.getNodeId(p));
                Assert.assertTrue((String)"Found persisted entity", (boolean)found);
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void testDoesntExist() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_10);
                boolean found = this.personRepository.exists(0x7FFFFFFFFFFFFFFEL);
                Assert.assertFalse((String)"Non existend id isn't foundpo ", (boolean)found);
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void testFinderFindByIdNonexistent() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_11);
                Person.persistedPerson("Michael", 35);
                Person p2 = (Person)this.personRepository.findOne(589736218L);
                Assert.assertNull((Object)p2);
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void testFinderCount() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_12);
                Assert.assertEquals((long)0L, (long)this.personRepository.count());
                Person.persistedPerson("Michael", 35);
                Assert.assertEquals((long)1L, (long)this.personRepository.count());
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void testFindAllOnGroup() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_13);
                this.log.debug("FindAllOnGroup start");
                Group g = this.persist(new Group());
                g.setName("test");
                this.persist(new Group());
                g.setName("test");
                Collection groups = IteratorUtil.addToCollection((Iterator)this.groupRepository.findAll().iterator(), new HashSet());
                Assert.assertEquals((long)2L, (long)groups.size());
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void testFindPaged() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_14);
                this.log.debug("FindAllOnGroup start");
                Person.persistedPerson("person1", 11);
                Person.persistedPerson("person2", 12);
                Person.persistedPerson("person3", 13);
                List all = (List)IteratorUtil.addToCollection((Iterable)this.personRepository.findAll(), new ArrayList());
                Page page0 = this.personRepository.findAll((Pageable)new PageRequest(0, 2));
                Page page1 = this.personRepository.findAll((Pageable)new PageRequest(1, 2));
                Page page2 = this.personRepository.findAll((Pageable)new PageRequest(2, 2));
                this.assertPage((Page<Person>)page0, 0, 2, 3, (Person)all.get(0), (Person)all.get(1));
                this.assertPage((Page<Person>)page1, 1, 2, 3, (Person)all.get(2));
                this.assertPage((Page<Person>)page2, 2, 2, 3, new Person[0]);
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    private void assertPage(Page<Person> page0, int pageNumber, int totalPages, int totalElements, Person ... people) {
        Assert.assertEquals((String)"content count", (long)people.length, (long)page0.getNumberOfElements());
        Assert.assertEquals((String)"page number", (long)pageNumber, (long)page0.getNumber());
        Assert.assertEquals((String)"page size", (long)2L, (long)page0.getSize());
        Assert.assertEquals((String)"total elements", (long)totalElements, (long)page0.getTotalElements());
        Assert.assertEquals((String)"page count", (long)totalPages, (long)page0.getTotalPages());
        Assert.assertEquals((String)"next page", (Object)(pageNumber < totalPages - 1 ? 1 : 0), (Object)page0.hasNextPage());
        Assert.assertEquals((String)"previous page", (Object)(pageNumber > 0 ? 1 : 0), (Object)page0.hasPreviousPage());
        Assert.assertEquals((String)"page content", Arrays.asList(people), (Object)page0.getContent());
    }

    static {
        FinderTests.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("FinderTests.java", FinderTests.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testFinderFindAll", "org.springframework.data.neo4j.aspects.support.FinderTests", "", "", "", "void"), 47);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testFindIterableOfPersonWithQueryAnnotation", "org.springframework.data.neo4j.aspects.support.FinderTests", "", "", "", "void"), 56);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testDoesntExist", "org.springframework.data.neo4j.aspects.support.FinderTests", "", "", "", "void"), 149);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testFinderFindByIdNonexistent", "org.springframework.data.neo4j.aspects.support.FinderTests", "", "", "", "void"), 156);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testFinderCount", "org.springframework.data.neo4j.aspects.support.FinderTests", "", "", "", "void"), 164);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testFindAllOnGroup", "org.springframework.data.neo4j.aspects.support.FinderTests", "", "", "", "void"), 172);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testFindPaged", "org.springframework.data.neo4j.aspects.support.FinderTests", "", "", "", "void"), 183);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testFindPersonWithQueryAnnotation", "org.springframework.data.neo4j.aspects.support.FinderTests", "", "", "", "void"), 64);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testFindIterableMapsWithQueryAnnotation", "org.springframework.data.neo4j.aspects.support.FinderTests", "", "", "", "void"), 72);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testFindByNamedQuery", "org.springframework.data.neo4j.aspects.support.FinderTests", "", "", "", "void"), 81);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testSaveManyPeople", "org.springframework.data.neo4j.aspects.support.FinderTests", "", "", "", "void"), 90);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testSavePerson", "org.springframework.data.neo4j.aspects.support.FinderTests", "", "", "", "void"), 101);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testFindRelationshipEntity", "org.springframework.data.neo4j.aspects.support.FinderTests", "", "", "", "void"), 123);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testFinderFindById", "org.springframework.data.neo4j.aspects.support.FinderTests", "", "", "", "void"), 134);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testExists", "org.springframework.data.neo4j.aspects.support.FinderTests", "", "", "", "void"), 142);
    }
}

