/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.aspects.support.path;

import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.springframework.data.neo4j.aspects.Person;
import org.springframework.data.neo4j.aspects.support.EntityTestBase;
import org.springframework.data.neo4j.support.path.ConvertingEntityPath;
import org.springframework.data.neo4j.support.path.NodePath;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.aspectj.AnnotationTransactionAspect;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:org/springframework/data/neo4j/aspects/support/Neo4jGraphPersistenceTests-context.xml"})
public class EntityPathTests
extends EntityTestBase {
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @Test
    @Transactional
    public void shouldConvertNodePathToEntityPath() throws Exception {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_0);
                Person michael = this.persist(new Person("Michael", 36));
                Node node = this.getNodeState(michael);
                NodePath path = new NodePath(node);
                ConvertingEntityPath entityPath = new ConvertingEntityPath((Path)path, this.neo4jTemplate);
                Assert.assertEquals((String)"start entity", (Object)michael, (Object)entityPath.startEntity(new Class[0]));
                Assert.assertEquals((String)"start node", (Object)node, (Object)path.startNode());
                Assert.assertEquals((String)"end entity", (Object)michael, (Object)entityPath.endEntity(new Class[0]));
                Assert.assertEquals((String)"end node", (Object)node, (Object)path.endNode());
                Assert.assertNull((String)"no relationship", (Object)entityPath.lastRelationshipEntity(new Class[0]));
                Assert.assertNull((String)"no relationship", (Object)path.lastRelationship());
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    static {
        EntityPathTests.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("EntityPathTests.java", EntityPathTests.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "shouldConvertNodePathToEntityPath", "org.springframework.data.neo4j.aspects.support.path.EntityPathTests", "", "", "java.lang.Exception", "void"), 42);
    }
}

