/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.support.schema;

import java.util.Collection;
import java.util.Map;
import org.neo4j.graphdb.Node;
import org.neo4j.helpers.collection.MapUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.InvalidDataAccessResourceUsageException;
import org.springframework.data.mapping.model.MappingException;
import org.springframework.data.neo4j.conversion.Result;
import org.springframework.data.neo4j.core.GraphDatabase;
import org.springframework.data.neo4j.mapping.IndexInfo;
import org.springframework.data.neo4j.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.support.query.CypherQueryEngine;

public class SchemaIndexProvider {
    private final GraphDatabase gd;
    private final CypherQueryEngine cypher;
    private static final Logger logger = LoggerFactory.getLogger(SchemaIndexProvider.class);
    private static final int RETRIES = 5;

    public SchemaIndexProvider(GraphDatabase gd) {
        this.gd = gd;
        this.cypher = gd.queryEngine();
    }

    public void createIndex(Neo4jPersistentProperty property) {
        String label = this.getLabel(property);
        String prop = this.getName(property);
        boolean unique = property.getIndexInfo().isUnique();
        this.createIndex(label, prop, unique);
    }

    public void createIndex(String label, String prop, boolean unique) {
        String query = this.createIndexQuery(label, prop, unique);
        if (logger.isDebugEnabled()) {
            logger.debug(query);
        }
        this.cypher.query(query, null);
    }

    public void awaitIndexOnline(String label, String prop) {
        this.sleep(20);
        String query = this.checkIndexOnlineQuery(label, prop);
        String message = "";
        long start = System.currentTimeMillis();
        for (int i = 0; i < 5; ++i) {
            try {
                this.cypher.query(query, MapUtil.map((Object[])new Object[]{"value", "__f_o_o__"})).single();
                return;
            }
            catch (InvalidDataAccessResourceUsageException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Index for " + label + "(" + prop + ") not online yet.", (Throwable)e);
                }
                message = e.getMessage();
                this.sleep(50 * (i + 1));
                continue;
            }
        }
        throw new MappingException("Could not make sure within (" + (System.currentTimeMillis() - start) + " ms) that the index for " + label + "(" + prop + ") is ONLINE, Failure: " + message);
    }

    private void sleep(int millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private String getName(Neo4jPersistentProperty property) {
        return property.getNeo4jPropertyName();
    }

    private String getLabel(Neo4jPersistentProperty property) {
        return property.getIndexInfo().getIndexName();
    }

    public <T> Result<T> findAll(Neo4jPersistentEntity entity) {
        String label = entity.getTypeAlias().toString();
        String query = this.findByLabelQuery(label);
        return this.cypher.query(query, null).to(entity.getType());
    }

    public <T> Result<T> findByIndexedValue(Neo4jPersistentProperty property, Object value) {
        Result<Node> results = this.findAllNodes(property, value);
        return results.to(property.getOwner().getType());
    }

    private Result<Node> findAllNodes(Neo4jPersistentProperty property, Object value) {
        IndexInfo indexInfo = property.getIndexInfo();
        String label = indexInfo.getIndexName();
        String prop = this.getName(property);
        String query = this.findByLabelAndPropertyQuery(label, prop);
        return this.cypher.query(query, MapUtil.map((Object[])new Object[]{"value", value})).to(Node.class);
    }

    private String findByLabelQuery(String label) {
        return "MATCH (n:`" + label + "`) RETURN n";
    }

    public Node merge(String labelName, String key, Object value, Map<String, Object> nodeProperties, Collection<String> labels) {
        if (labelName == null || key == null || value == null) {
            throw new IllegalArgumentException("Label " + labelName + " key " + key + " and value must not be null");
        }
        Map props = nodeProperties.containsKey(key) ? nodeProperties : MapUtil.copyAndPut(nodeProperties, (Object)key, (Object)value);
        Map params = MapUtil.map((Object[])new Object[]{"props", props, "value", value});
        return this.cypher.query(this.mergeQuery(labelName, key, labels), params).to(Node.class).single();
    }

    private String mergeQuery(String labelName, String key, Collection<String> labels) {
        StringBuilder setLabels = new StringBuilder();
        if (labels != null) {
            for (String label : labels) {
                if (label.equals(labelName)) continue;
                setLabels.append("SET n:").append(label).append(" ");
            }
        }
        return "MERGE (n:`" + labelName + "` {`" + key + "`: {value}}) ON CREATE SET n={props} " + setLabels + " return n";
    }

    private String findByLabelAndPropertyQuery(String label, String prop) {
        return "MATCH (n:`" + label + "` {`" + prop + "`:{value}}) RETURN n";
    }

    private String checkIndexOnlineQuery(String label, String prop) {
        return "MATCH (n:" + label + ") USING INDEX n:" + label + "(" + prop + ") WHERE n." + prop + "={value} WITH n LIMIT 1 RETURN count(*)";
    }

    private String createIndexQuery(String label, String prop, boolean unique) {
        if (unique) {
            return "CREATE CONSTRAINT ON (n:`" + label + "`) ASSERT n.`" + prop + "` IS UNIQUE";
        }
        return "CREATE INDEX ON :`" + label + "`(`" + prop + "`)";
    }
}

