/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.transaction;

import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.transaction.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.neo4j.transaction.Neo4jTransactionStatus;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionStatus;

public class Neo4jTransactionManager
implements PlatformTransactionManager {
    private final Logger logger = LoggerFactory.getLogger(Neo4jTransactionManager.class);
    private final Session session;

    public Neo4jTransactionManager(Session session) {
        this.session = session;
    }

    public TransactionStatus getTransaction(TransactionDefinition transactionDefinition) throws TransactionException {
        this.logger.debug("Requesting to create or join a transaction");
        return new Neo4jTransactionStatus(this.session, transactionDefinition);
    }

    public void commit(TransactionStatus transactionStatus) throws TransactionException {
        Transaction tx = ((Neo4jTransactionStatus)transactionStatus).getTransaction();
        this.logger.debug("Commit requested: " + tx + ", status: " + tx.status().toString());
        if (transactionStatus.isNewTransaction()) {
            if (tx.status() == Transaction.Status.PENDING || tx.status() == Transaction.Status.OPEN) {
                this.logger.debug("Commit invoked");
                tx.commit();
            }
        } else {
            this.logger.debug("Commit deferred");
        }
    }

    public void rollback(TransactionStatus transactionStatus) throws TransactionException {
        Transaction tx = ((Neo4jTransactionStatus)transactionStatus).getTransaction();
        this.logger.debug("Rollback requested: " + tx + ", status: " + tx.status().toString());
        if (tx.status() == Transaction.Status.PENDING || tx.status() == Transaction.Status.OPEN) {
            this.logger.debug("Rollback invoked");
            tx.rollback();
        }
    }
}

