/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.template;

import java.util.Collection;
import java.util.Map;
import org.neo4j.ogm.cypher.Filter;
import org.neo4j.ogm.cypher.Filters;
import org.neo4j.ogm.cypher.query.Pagination;
import org.neo4j.ogm.cypher.query.SortOrder;
import org.neo4j.ogm.model.QueryStatistics;
import org.neo4j.ogm.model.Result;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.Utils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.data.neo4j.event.AfterDeleteEvent;
import org.springframework.data.neo4j.event.AfterSaveEvent;
import org.springframework.data.neo4j.event.BeforeDeleteEvent;
import org.springframework.data.neo4j.event.BeforeSaveEvent;
import org.springframework.data.neo4j.event.Neo4jDataManipulationEvent;
import org.springframework.data.neo4j.template.Neo4jOperations;
import org.springframework.data.neo4j.util.IterableUtils;
import org.springframework.util.Assert;

public class Neo4jTemplate
implements Neo4jOperations,
ApplicationEventPublisherAware {
    private final Session session;
    private ApplicationEventPublisher applicationEventPublisher;

    @Autowired
    public Neo4jTemplate(Session session) {
        Assert.notNull((Object)session, (String)"Cannot create a Neo4jTemplate without a Session!");
        this.session = session;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    @Override
    public <T> T load(Class<T> type, Long id) {
        return (T)this.session.load(type, id);
    }

    @Override
    public <T> T load(Class<T> type, Long id, int depth) {
        return (T)this.session.load(type, id, depth);
    }

    public <T> Collection<T> loadAll(Class<T> type, Collection<Long> ids) {
        return this.session.loadAll(type, ids);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Collection<Long> ids, int depth) {
        return this.session.loadAll(type, ids, depth);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type) {
        return this.session.loadAll(type);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, int depth) {
        return this.session.loadAll(type, depth);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, SortOrder sortOrder, int depth) {
        return this.session.loadAll(type, sortOrder, depth);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, SortOrder sortOrder, Pagination pagination, int depth) {
        return this.session.loadAll(type, sortOrder, pagination, depth);
    }

    public <T> Collection<T> loadAll(Collection<T> objects) {
        return this.session.loadAll(objects);
    }

    @Override
    public <T> Collection<T> loadAll(Collection<T> objects, int depth) {
        return this.session.loadAll(objects, depth);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Collection<Long> ids, SortOrder sortOrder, int depth) {
        return this.session.loadAll(type, ids, sortOrder, depth);
    }

    @Override
    public <T> T loadByProperty(Class<T> type, String propertyName, Object propertyValue) {
        return this.loadByProperty(type, propertyName, propertyValue, 1);
    }

    @Override
    public <T> T loadByProperty(Class<T> type, String propertyName, Object propertyValue, int depth) {
        return IterableUtils.getSingle(this.loadAllByProperty(type, propertyName, propertyValue, depth));
    }

    public <T> T loadByPropertyOrNull(Class<T> type, String propertyName, Object propertyValue) {
        return IterableUtils.getSingleOrNull(this.loadAllByProperty(type, propertyName, propertyValue));
    }

    @Override
    public <T> Collection<T> loadAllByProperty(Class<T> type, String name, Object value) {
        return this.session.loadAll(type, new Filter(name, value));
    }

    @Override
    public <T> T loadByProperties(Class<T> type, Filters parameters) {
        return this.loadByProperties(type, parameters, 1);
    }

    @Override
    public <T> T loadByProperties(Class<T> type, Filters parameters, int depth) {
        return IterableUtils.getSingle(this.loadAllByProperties(type, parameters, depth));
    }

    @Override
    public <T> Collection<T> loadAllByProperties(Class<T> type, Filters parameters) {
        return this.loadAllByProperties(type, parameters, 1);
    }

    @Override
    public <T> Collection<T> loadAllByProperties(Class<T> type, Filters parameters, int depth) {
        return this.session.loadAll(type, parameters, depth);
    }

    @Override
    public <T> Collection<T> loadAllByProperty(Class<T> type, String name, Object value, int depth) {
        return this.session.loadAll(type, new Filter(name, value), depth);
    }

    @Override
    public void delete(Object entity) {
        this.publishEvent(new BeforeDeleteEvent(this, entity));
        this.session.delete(entity);
        this.publishEvent(new AfterDeleteEvent(this, entity));
    }

    @Override
    public void clear() {
        this.session.clear();
    }

    @Override
    public <T> void deleteAll(Class<T> type) {
        this.session.deleteAll(type);
    }

    @Override
    public QueryStatistics execute(String jsonStatements) {
        return this.session.query(jsonStatements, Utils.map((Object[])new Object[0])).queryStatistics();
    }

    @Override
    public QueryStatistics execute(String cypher, Map<String, Object> parameters) {
        return this.session.query(cypher, parameters).queryStatistics();
    }

    public void purgeSession() {
        this.session.clear();
    }

    @Override
    public <T> T save(T entity) {
        this.publishEvent(new BeforeSaveEvent(this, entity));
        this.session.save(entity);
        this.publishEvent(new AfterSaveEvent(this, entity));
        return entity;
    }

    @Override
    public <T> T save(T entity, int depth) {
        this.publishEvent(new BeforeSaveEvent(this, entity));
        this.session.save(entity, depth);
        this.publishEvent(new AfterSaveEvent(this, entity));
        return entity;
    }

    @Override
    public Result query(String cypher, Map<String, ?> parameters) {
        return this.session.query(cypher, parameters);
    }

    @Override
    public <T> Iterable<T> queryForObjects(Class<T> objectType, String cypher, Map<String, ?> parameters) {
        return this.session.query(objectType, cypher, parameters);
    }

    @Override
    public Result query(String cypher, Map<String, ?> parameters, boolean readOnly) {
        return this.session.query(cypher, parameters, readOnly);
    }

    @Override
    public <T> T queryForObject(Class<T> objectType, String cypher, Map<String, ?> parameters) {
        return (T)this.session.queryForObject(objectType, cypher, parameters);
    }

    @Override
    public long count(Class<?> entityClass) {
        return this.session.countEntitiesOfType(entityClass);
    }

    private void publishEvent(Neo4jDataManipulationEvent event) {
        if (this.applicationEventPublisher != null) {
            this.applicationEventPublisher.publishEvent((ApplicationEvent)event);
        }
    }
}

