/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.examples.movies.domain;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.neo4j.ogm.annotation.Relationship;
import org.springframework.data.neo4j.examples.movies.domain.Genre;
import org.springframework.data.neo4j.examples.movies.domain.Person;
import org.springframework.data.neo4j.examples.movies.domain.Rating;
import org.springframework.data.neo4j.examples.movies.domain.TempMovie;

public class User
extends Person {
    private String middleName;
    private Collection<Genre> interested = new HashSet<Genre>();
    @Relationship(type="FRIEND_OF", direction="UNDIRECTED")
    private Collection<User> friends = new HashSet<User>();
    @Relationship(type="RATED")
    private Set<Rating> ratings = new HashSet<Rating>();

    public User() {
    }

    public User(String name) {
        this.setName(name);
    }

    public void interestedIn(Genre genre) {
        this.interested.add(genre);
    }

    public void notInterestedIn(Genre genre) {
        this.interested.remove(genre);
    }

    public void befriend(User user) {
        this.friends.add(user);
        user.friends.add(this);
    }

    public Rating rate(TempMovie movie, int stars, String comment) {
        Rating rating = new Rating(this, movie, stars, comment);
        movie.addRating(rating);
        this.ratings.add(rating);
        return rating;
    }

    public Collection<User> getFriends() {
        return this.friends;
    }

    public String getMiddleName() {
        return this.middleName;
    }

    public Set<Rating> getRatings() {
        return this.ratings;
    }

    public void setMiddleName(String middleName) {
        this.middleName = middleName;
    }
}

