/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.examples.movies.repo;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.data.neo4j.annotation.Query;
import org.springframework.data.neo4j.examples.movies.domain.User;
import org.springframework.data.neo4j.examples.movies.domain.queryresult.EntityWrappingQueryResult;
import org.springframework.data.neo4j.examples.movies.domain.queryresult.Gender;
import org.springframework.data.neo4j.examples.movies.domain.queryresult.RichUserQueryResult;
import org.springframework.data.neo4j.examples.movies.domain.queryresult.UserQueryResult;
import org.springframework.data.neo4j.examples.movies.domain.queryresult.UserQueryResultInterface;
import org.springframework.data.neo4j.examples.movies.repo.PersonRepository;
import org.springframework.data.neo4j.examples.movies.repo.UnmanagedUserPojo;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface UserRepository
extends PersonRepository<User> {
    public Collection<User> findByMiddleName(String var1);

    public List<User> findByRatingsStars(int var1);

    public List<User> findByRatingsStarsAndInterestedName(int var1, String var2);

    @Query(value="MATCH (user:User) RETURN COUNT(user)")
    public int findTotalUsers();

    @Query(value="MATCH (user:User) RETURN id(user)")
    public List<Integer> getUserIds();

    @Query(value="MATCH (user:User) RETURN user.name, id(user)")
    public Iterable<Map<String, Object>> getUsersAsProperties();

    @Query(value="MATCH (user:User) RETURN user")
    public Collection<User> getAllUsers();

    @Query(value="MATCH (m:Movie)<-[:ACTED_IN]-(a:User) RETURN m.name as movie, collect(a.name) as cast")
    public List<Map<String, Object>> getGraph();

    @Query(value="MATCH (user:User{name:{name}}) RETURN user")
    public User findUserByNameWithNamedParam(@Param(value="name") String var1);

    @Query(value="MATCH (user:User{name:{0}}) RETURN user")
    public User findUserByName(String var1);

    @Query(value="MATCH (user:User) RETURN id(user) AS userId, id(user) as id, user.name AS userName, user.age ORDER BY user.age")
    public Iterable<UserQueryResult> retrieveAllUsersAndTheirAges();

    @Query(value="MATCH (user:User{name:{0}}) RETURN user.name AS name")
    public UnmanagedUserPojo findIndividualUserAsDifferentObject(String var1);

    @Query(value="MATCH (user:User) WHERE user.name={0} RETURN user.name, user.age AS ageOfUser")
    public UserQueryResultInterface findIndividualUserAsProxiedObject(String var1);

    @Query(value="MATCH (user:User) WHERE user.name={0} RETURN user as user, user.age AS ageOfUser")
    public UserQueryResultInterface findWrappedUserAsProxiedObject(String var1);

    @Query(value="MATCH (user:User) WHERE user.gender={0} RETURN user.name AS UserName, user.gender AS UserGender, user.account as UserAccount, user.deposits as UserDeposits")
    public Iterable<RichUserQueryResult> findUsersByGender(Gender var1);

    @Query(value="MATCH (user:User) WHERE user.name={0} RETURN user")
    public EntityWrappingQueryResult findWrappedUserByName(String var1);

    @Query(value="MATCH (user:User)-[:FRIEND_OF]->(f) WHERE user.name={0} RETURN user, collect(f) as friends")
    public EntityWrappingQueryResult findWrappedUserAndFriendsDepth0(String var1);

    @Query(value="MATCH (user:User)-[r:FRIEND_OF]->(f) WHERE user.name={0} RETURN user, collect(r) as rels, collect(f) as friends")
    public EntityWrappingQueryResult findWrappedUserAndFriendsDepth1(String var1);

    @Query(value="MATCH (user:User)-[r:RATED]->(m) WHERE user.name={0} RETURN user, collect(r) as ratings, collect(m) as movies, avg(r.stars) as avgRating")
    public EntityWrappingQueryResult findWrappedUserAndRatingsByName(String var1);

    @Query(value="MATCH (user:User)-[r:RATED]->(m) RETURN user, collect(r) as ratings, collect(m) as movies, avg(r.stars) as avgRating order by user.name desc")
    public List<EntityWrappingQueryResult> findAllUserRatings();

    @Query(value="MATCH (user:User) RETURN ID(user)")
    public List<Long> getUserNodeIds();

    @Query(value="MATCH (user:User) WHERE ID(user)={0} return user")
    public User loadUserById(User var1);

    @Query(value="MATCH (user:User) WHERE ID(user)={userId} RETURN user")
    public User loadUserByNamedId(@Param(value="userId") User var1);

    @Query(value="MATCH (user:User) RETURN user")
    public Iterable<User> getAllUsersIterable();

    @Query(value="MATCH (user:User) set user.name={0}")
    public void setNamesNull(String var1);

    public List<User> findByNameIsNotLike(String var1);

    @Query(value="MATCH (user:User) RETURN user.unknown as allRatings")
    public EntityWrappingQueryResult findAllRatingsNull();

    @Query(value="match (u:User)-[r:RATED]->(m:Movie) return  u as user, collect({username: u.name, movietitle: m.title, stars:r.stars}) as literalMap")
    public List<EntityWrappingQueryResult> findRatingsWithLiteralMap();

    public User findBySurname(String var1);
}

