/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repositories;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.testutil.GraphTestUtils;
import org.neo4j.ogm.testutil.MultiDriverTestClass;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.neo4j.repositories.domain.User;
import org.springframework.data.neo4j.repositories.repo.PersistenceContextInTheSamePackage;
import org.springframework.data.neo4j.repositories.repo.UserRepository;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@ContextConfiguration(classes={PersistenceContextInTheSamePackage.class})
@RunWith(value=SpringJUnit4ClassRunner.class)
public class RepoScanningTest
extends MultiDriverTestClass {
    @Autowired
    private Session session;
    @Autowired
    private UserRepository userRepository;
    private GraphDatabaseService graphDatabaseService = RepoScanningTest.getGraphDatabaseService();

    @Before
    public void init() {
        this.session.purgeDatabase();
    }

    @Test
    public void enableNeo4jRepositoriesShouldScanSelfPackageByDefault() {
        User user = new User("Michal");
        this.userRepository.save(user);
        GraphTestUtils.assertSameGraph((GraphDatabaseService)this.graphDatabaseService, (String)"CREATE (u:User {name:'Michal'})");
    }
}

