/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.transactions.service;

import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.neo4j.transactions.service.BusinessService;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class WrapperService {
    @Autowired
    BusinessService businessService;

    @Transactional
    public void composeSuccessThenFail() {
        this.businessService.successMethodInTransaction();
        this.businessService.failMethodInTransaction();
    }

    @Transactional
    public void composeSuccessThenSuccess() {
        this.businessService.successMethodInTransaction();
        this.businessService.successMethodInTransaction();
    }

    @Transactional
    public void composeFailThenSuccess() {
        this.businessService.failMethodInTransaction();
        this.businessService.successMethodInTransaction();
    }

    @Transactional
    public void composeFailThenFail() {
        this.businessService.failMethodInTransaction();
        this.businessService.failMethodInTransaction();
    }

    @Transactional(rollbackFor={Exception.class})
    public void rollbackWithCheckedException() throws Exception {
        this.businessService.throwsException();
    }

    public Iterable<Map<String, Object>> fetch() {
        return this.businessService.fetch();
    }

    public void purge() {
        this.businessService.purge();
    }
}

