/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.web.controller;

import java.util.ArrayList;
import java.util.Collections;
import javax.servlet.http.HttpSession;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.neo4j.web.domain.User;
import org.springframework.data.neo4j.web.service.UserService;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class UserController {
    @Autowired
    private UserService userService;

    @RequestMapping(value={"/user/{name}/friends"})
    @ResponseBody
    public String listFriends(@PathVariable String name, HttpSession session) {
        System.out.println("Session: " + session);
        User user = this.userService.getUserByName(name);
        if (user == null) {
            return "No such user!";
        }
        StringBuilder result = new StringBuilder();
        for (User friend : this.userService.getNetwork(user)) {
            result.append(friend.getName()).append(" ");
        }
        return result.toString().trim();
    }

    @RequestMapping(value={"/user/{name}/immediateFriends"})
    @ResponseBody
    public String listImmediateFriends(@PathVariable String name, HttpSession session) {
        System.out.println("Session: " + session);
        User user = this.userService.getUserByName(name);
        if (user == null) {
            return "No such user!";
        }
        ArrayList<String> friends = new ArrayList<String>();
        for (User friend : user.getFriends()) {
            friends.add(friend.getName());
        }
        Collections.sort(friends);
        StringBuilder result = new StringBuilder();
        for (String friend : friends) {
            result.append(friend).append(" ");
        }
        return result.toString().trim();
    }
}

