/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import java.lang.reflect.Method;
import org.neo4j.ogm.session.Session;
import org.springframework.data.neo4j.repository.query.GraphQueryMethod;
import org.springframework.data.neo4j.repository.query.GraphRepositoryQuery;
import org.springframework.data.neo4j.repository.query.NamedGraphRepositoryQuery;
import org.springframework.data.neo4j.repository.query.derived.DerivedGraphRepositoryQuery;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.RepositoryQuery;

public class GraphQueryLookupStrategy
implements QueryLookupStrategy {
    private final Session session;
    private final QueryMethodEvaluationContextProvider evaluationContextProvider;

    public GraphQueryLookupStrategy(Session session, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        this.session = session;
        this.evaluationContextProvider = evaluationContextProvider;
    }

    public RepositoryQuery resolveQuery(Method method, RepositoryMetadata metadata, ProjectionFactory factory, NamedQueries namedQueries) {
        GraphQueryMethod queryMethod = new GraphQueryMethod(method, metadata, factory);
        String namedQueryName = queryMethod.getNamedQueryName();
        if (namedQueries.hasQuery(namedQueryName)) {
            String cypherQuery = namedQueries.getQuery(namedQueryName);
            return new NamedGraphRepositoryQuery(queryMethod, this.session, cypherQuery, this.evaluationContextProvider);
        }
        if (queryMethod.hasAnnotatedQuery()) {
            return new GraphRepositoryQuery(queryMethod, this.session, this.evaluationContextProvider);
        }
        return new DerivedGraphRepositoryQuery(queryMethod, this.session);
    }
}

