/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query.filter;

import java.util.Arrays;
import java.util.List;
import java.util.Stack;
import org.neo4j.ogm.cypher.BooleanOperator;
import org.neo4j.ogm.cypher.ComparisonOperator;
import org.neo4j.ogm.cypher.Filter;
import org.neo4j.ogm.cypher.function.FilterFunction;
import org.neo4j.ogm.cypher.function.PropertyComparison;
import org.springframework.data.domain.Range;
import org.springframework.data.neo4j.repository.query.filter.FilterBuilder;
import org.springframework.data.repository.query.parser.Part;

class BetweenComparisonBuilder
extends FilterBuilder {
    BetweenComparisonBuilder(Part part, BooleanOperator booleanOperator, Class<?> entityType) {
        super(part, booleanOperator, entityType);
    }

    @Override
    public List<Filter> build(Stack<Object> params) {
        Object upperBoundValue;
        Object lowerBoundValue;
        Object lowerBoundOrRange = params.pop();
        boolean inclusiveLowerBound = true;
        boolean inclusiveUpperBound = true;
        if (lowerBoundOrRange instanceof Range) {
            Range range = (Range)lowerBoundOrRange;
            Range.Bound lowerBound = range.getLowerBound();
            lowerBoundValue = lowerBound.getValue();
            inclusiveLowerBound = lowerBound.isInclusive();
            Range.Bound upperBound = range.getUpperBound();
            upperBoundValue = upperBound.getValue();
            inclusiveUpperBound = upperBound.isInclusive();
        } else {
            lowerBoundValue = lowerBoundOrRange;
            upperBoundValue = params.pop();
        }
        Filter lowerBoundFilter = this.createLowerBoundFilter(lowerBoundValue, inclusiveLowerBound);
        this.setNestedAttributes(this.part, lowerBoundFilter);
        Filter upperBoundFilter = this.createUpperBoundFilter(upperBoundValue, inclusiveUpperBound);
        this.setNestedAttributes(this.part, upperBoundFilter);
        return Arrays.asList(lowerBoundFilter, upperBoundFilter);
    }

    private Filter createLowerBoundFilter(Object value, boolean inclusive) {
        return this.createBoundFilter(Bound.LOWER, value, inclusive, this.booleanOperator);
    }

    private Filter createUpperBoundFilter(Object value, boolean inclusive) {
        return this.createBoundFilter(Bound.UPPER, value, inclusive, BooleanOperator.AND);
    }

    private Filter createBoundFilter(Bound bound, Object value, boolean inclusive, BooleanOperator operator) {
        Filter filter = new Filter(this.propertyName(), this.deriveComparisonOperator(bound, inclusive), value);
        filter.setOwnerEntityType(this.entityType);
        filter.setNegated(this.isNegated());
        filter.setFunction((FilterFunction)new PropertyComparison(value));
        filter.setBooleanOperator(operator);
        return filter;
    }

    private ComparisonOperator deriveComparisonOperator(Bound bound, boolean inclusive) {
        switch (bound) {
            case LOWER: {
                return inclusive ? ComparisonOperator.GREATER_THAN_EQUAL : ComparisonOperator.GREATER_THAN;
            }
            case UPPER: {
                return inclusive ? ComparisonOperator.LESS_THAN_EQUAL : ComparisonOperator.LESS_THAN;
            }
        }
        throw new IllegalArgumentException("unsupported bound");
    }

    private static enum Bound {
        UPPER,
        LOWER;

    }
}

