/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import java.lang.reflect.Method;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;
import org.springframework.data.neo4j.repository.query.Neo4jQueryMethod;
import org.springframework.data.neo4j.repository.support.ReactiveCypherdslStatementExecutor;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.util.Lazy;
import org.springframework.data.util.ReactiveWrappers;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.ClassUtils;

final class ReactiveNeo4jQueryMethod
extends Neo4jQueryMethod {
    private static final TypeInformation<Page> PAGE_TYPE = TypeInformation.of(Page.class);
    private static final TypeInformation<Slice> SLICE_TYPE = TypeInformation.of(Slice.class);
    private final Lazy<Boolean> isCollectionQuery;

    ReactiveNeo4jQueryMethod(Method method, RepositoryMetadata metadata, ProjectionFactory factory) {
        super(method, metadata, factory, ClassUtils.hasMethod(ReactiveCypherdslStatementExecutor.class, (Method)method));
        if (org.springframework.data.repository.util.ClassUtils.hasParameterOfType((Method)method, Pageable.class)) {
            boolean singleWrapperWithWrappedPageableResult;
            TypeInformation returnType = TypeInformation.fromReturnTypeOf((Method)method);
            boolean multiWrapper = ReactiveWrappers.isMultiValueType((Class)returnType.getType());
            boolean bl = singleWrapperWithWrappedPageableResult = ReactiveWrappers.isSingleValueType((Class)returnType.getType()) && (PAGE_TYPE.isAssignableFrom(returnType.getRequiredComponentType()) || SLICE_TYPE.isAssignableFrom(returnType.getRequiredComponentType()));
            if (singleWrapperWithWrappedPageableResult) {
                throw new InvalidDataAccessApiUsageException(String.format("'%s.%s' must not use sliced or paged execution, please use Flux.buffer(size, skip)", ClassUtils.getShortName(method.getDeclaringClass()), method.getName()));
            }
            if (!multiWrapper) {
                throw new IllegalStateException(String.format("Method has to use a multi-item reactive wrapper return type. Offending method: %s", method.toString()));
            }
        }
        this.isCollectionQuery = Lazy.of(() -> !this.isPageQuery() && !this.isSliceQuery() && ReactiveWrappers.isMultiValueType((Class)metadata.getReturnType(method).getType()) || super.isCollectionQuery());
    }

    public boolean isCollectionQuery() {
        return (Boolean)this.isCollectionQuery.get();
    }

    public boolean isStreamQuery() {
        return true;
    }

    @Override
    boolean isCollectionLikeQuery() {
        return this.isCollectionQuery();
    }
}

