/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core.mapping;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.regex.Pattern;
import javax.lang.model.SourceVersion;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.AliasedExpression;
import org.neo4j.cypherdsl.core.Condition;
import org.neo4j.cypherdsl.core.Cypher;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.FunctionInvocation;
import org.neo4j.cypherdsl.core.IdentifiableElement;
import org.neo4j.cypherdsl.core.MapProjection;
import org.neo4j.cypherdsl.core.Named;
import org.neo4j.cypherdsl.core.Node;
import org.neo4j.cypherdsl.core.Parameter;
import org.neo4j.cypherdsl.core.PatternElement;
import org.neo4j.cypherdsl.core.Property;
import org.neo4j.cypherdsl.core.Relationship;
import org.neo4j.cypherdsl.core.RelationshipPattern;
import org.neo4j.cypherdsl.core.SortItem;
import org.neo4j.cypherdsl.core.Statement;
import org.neo4j.cypherdsl.core.StatementBuilder;
import org.neo4j.cypherdsl.core.SymbolicName;
import org.neo4j.cypherdsl.core.renderer.Configuration;
import org.neo4j.cypherdsl.core.renderer.Renderer;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.neo4j.core.mapping.Constants;
import org.springframework.data.neo4j.core.mapping.DefaultNeo4jPersistentEntity;
import org.springframework.data.neo4j.core.mapping.DefaultRelationshipDescription;
import org.springframework.data.neo4j.core.mapping.GraphPropertyDescription;
import org.springframework.data.neo4j.core.mapping.IdDescription;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.core.mapping.NodeDescription;
import org.springframework.data.neo4j.core.mapping.PropertyFilter;
import org.springframework.data.neo4j.core.mapping.RelationshipDescription;
import org.springframework.data.neo4j.core.schema.Relationship;
import org.springframework.data.neo4j.core.schema.TargetNode;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

@API(status=API.Status.INTERNAL, since="6.0")
public enum CypherGenerator {
    INSTANCE;

    private Function<Named, FunctionInvocation> elementIdOrIdFunction = named -> {
        if (named instanceof Node) {
            Node node = (Node)named;
            return Cypher.elementId((Node)node);
        }
        if (named instanceof Relationship) {
            Relationship relationship = (Relationship)named;
            return Cypher.elementId((Relationship)relationship);
        }
        throw new IllegalArgumentException("Unsupported CypherDSL type: " + String.valueOf(named.getClass()));
    };
    private static final SymbolicName START_NODE_NAME;
    private static final SymbolicName END_NODE_NAME;
    private static final SymbolicName RELATIONSHIP_NAME;
    private static final Pattern LOOKS_LIKE_A_FUNCTION;

    public void setElementIdOrIdFunction(Function<Named, FunctionInvocation> elementIdOrIdFunction) {
        this.elementIdOrIdFunction = elementIdOrIdFunction;
    }

    public StatementBuilder.OrderableOngoingReadingAndWith prepareMatchOf(NodeDescription<?> nodeDescription) {
        return this.prepareMatchOf(nodeDescription, null);
    }

    public StatementBuilder.OrderableOngoingReadingAndWith prepareMatchOf(NodeDescription<?> nodeDescription, @Nullable Condition condition) {
        Neo4jPersistentEntity entity;
        Node rootNode = this.createRootNode(nodeDescription);
        ArrayList<Object> expressions = new ArrayList<Object>();
        expressions.add(rootNode.getRequiredSymbolicName());
        if (nodeDescription instanceof Neo4jPersistentEntity && (entity = (Neo4jPersistentEntity)nodeDescription).isUsingDeprecatedInternalId()) {
            expressions.add(rootNode.internalId().as("__internalNeo4jId__"));
        }
        expressions.add(this.elementIdOrIdFunction.apply((Named)rootNode).as("__elementId__"));
        return ((StatementBuilder.OngoingReadingWithWhere)Cypher.match((PatternElement[])new PatternElement[]{rootNode}).where(CypherGenerator.conditionOrNoCondition(condition))).with((IdentifiableElement[])expressions.toArray(IdentifiableElement[]::new));
    }

    public StatementBuilder.OngoingReading prepareMatchOf(NodeDescription<?> nodeDescription, @Nullable List<PatternElement> initialMatchOn, @Nullable Condition condition) {
        Node rootNode = this.createRootNode(nodeDescription);
        StatementBuilder.OngoingReadingWithoutWhere match = this.prepareMatchOfRootNode(rootNode, initialMatchOn);
        ArrayList<AliasedExpression> expressions = new ArrayList<AliasedExpression>();
        expressions.add(Cypher.collect((Expression)((Expression)this.elementIdOrIdFunction.apply((Named)rootNode))).as("__sn__"));
        return ((StatementBuilder.OngoingReadingWithWhere)match.where(CypherGenerator.conditionOrNoCondition(condition))).with((IdentifiableElement[])expressions.toArray(IdentifiableElement[]::new));
    }

    public StatementBuilder.OngoingReading prepareMatchOf(NodeDescription<?> nodeDescription, RelationshipDescription relationshipDescription, @Nullable List<PatternElement> initialMatchOn, @Nullable Condition condition) {
        Node rootNode = this.createRootNode(nodeDescription);
        StatementBuilder.OngoingReadingWithoutWhere match = this.prepareMatchOfRootNode(rootNode, initialMatchOn);
        Node targetNode = Cypher.node((String)relationshipDescription.getTarget().getPrimaryLabel(), relationshipDescription.getTarget().getAdditionalLabels()).named("__srn__");
        boolean dynamicRelationship = relationshipDescription.isDynamic();
        Class componentType = ((Neo4jPersistentProperty)((DefaultRelationshipDescription)relationshipDescription).getInverse()).getComponentType();
        ArrayList<String> relationshipTypes = new ArrayList<String>();
        if (dynamicRelationship && componentType != null && componentType.isEnum()) {
            Arrays.stream(componentType.getEnumConstants()).forEach(constantName -> relationshipTypes.add(constantName.toString()));
        } else if (!dynamicRelationship) {
            relationshipTypes.add(relationshipDescription.getType());
        }
        String[] types = relationshipTypes.toArray(new String[0]);
        Relationship relationship = switch (relationshipDescription.getDirection()) {
            default -> throw new IncompatibleClassChangeError();
            case Relationship.Direction.OUTGOING -> (Relationship)rootNode.relationshipTo(targetNode, types);
            case Relationship.Direction.INCOMING -> (Relationship)rootNode.relationshipFrom(targetNode, types);
        };
        relationship = relationship.named("__sr__");
        ArrayList<AliasedExpression> expressions = new ArrayList<AliasedExpression>();
        expressions.add(Cypher.collect((Expression)((Expression)this.elementIdOrIdFunction.apply((Named)rootNode))).as("__sn__"));
        expressions.add(Cypher.collect((Expression)((Expression)this.elementIdOrIdFunction.apply((Named)targetNode))).as("__srn__"));
        expressions.add(Cypher.collect((Expression)((Expression)this.elementIdOrIdFunction.apply((Named)relationship))).as("__sr__"));
        return ((StatementBuilder.OngoingReadingWithWhere)match.where(CypherGenerator.conditionOrNoCondition(condition))).optionalMatch(new PatternElement[]{relationship}).with((IdentifiableElement[])expressions.toArray(IdentifiableElement[]::new));
    }

    @NonNull
    public Node createRootNode(NodeDescription<?> nodeDescription) {
        String primaryLabel = nodeDescription.getPrimaryLabel();
        List<String> additionalLabels = nodeDescription.getAdditionalLabels();
        return Cypher.node((String)primaryLabel, additionalLabels).named(Constants.NAME_OF_TYPED_ROOT_NODE.apply(nodeDescription));
    }

    private StatementBuilder.OngoingReadingWithoutWhere prepareMatchOfRootNode(Node rootNode, @Nullable List<PatternElement> initialMatchOn) {
        StatementBuilder.OngoingReadingWithoutWhere match = null;
        if (initialMatchOn == null || initialMatchOn.isEmpty()) {
            match = Cypher.match((PatternElement[])new PatternElement[]{rootNode});
        } else {
            for (PatternElement patternElement : initialMatchOn) {
                if (match == null) {
                    match = Cypher.match((PatternElement[])new PatternElement[]{patternElement});
                    continue;
                }
                match = match.match(new PatternElement[]{patternElement});
            }
        }
        return match;
    }

    public Statement createStatementReturningDynamicLabels(NodeDescription<?> nodeDescription) {
        Condition versionCondition;
        IdDescription idDescription = nodeDescription.getIdDescription();
        Assert.notNull((Object)idDescription, (String)"Cannot load specific nodes by id without a corresponding attribute");
        Node rootNode = this.createRootNode(nodeDescription);
        if (((Neo4jPersistentEntity)nodeDescription).hasVersionProperty()) {
            PersistentProperty versionProperty = ((Neo4jPersistentEntity)nodeDescription).getRequiredVersionProperty();
            versionCondition = rootNode.property(versionProperty.getName()).isEqualTo((Expression)Cypher.coalesce((Expression[])new Expression[]{Cypher.parameter((String)"__version__"), Cypher.literalOf((Object)0)}));
        } else {
            versionCondition = Cypher.noCondition();
        }
        return ((StatementBuilder.OngoingReadingWithWhere)((StatementBuilder.OngoingReadingWithWhere)Cypher.match((PatternElement[])new PatternElement[]{rootNode}).where(idDescription.asIdExpression().isEqualTo((Expression)Cypher.parameter((String)"__id__")))).and(versionCondition)).unwind((Expression)rootNode.labels()).as("label").with(new IdentifiableElement[]{Cypher.name((String)"label")}).where(Cypher.name((String)"label").in((Expression)Cypher.parameter((String)"__staticLabels__")).not()).returning(new Expression[]{Cypher.collect((Expression)Cypher.name((String)"label")).as("__nodeLabels__")}).build();
    }

    public Statement prepareDeleteOf(NodeDescription<?> nodeDescription) {
        return this.prepareDeleteOf(nodeDescription, null);
    }

    public Statement prepareDeleteOf(NodeDescription<?> nodeDescription, @Nullable Condition condition) {
        return this.prepareDeleteOf(nodeDescription, condition, false);
    }

    public Statement prepareDeleteOf(NodeDescription<?> nodeDescription, @Nullable Condition condition, boolean count) {
        Node rootNode = Cypher.node((String)nodeDescription.getPrimaryLabel(), nodeDescription.getAdditionalLabels()).named(Constants.NAME_OF_TYPED_ROOT_NODE.apply(nodeDescription));
        StatementBuilder.OngoingUpdate ongoingUpdate = ((StatementBuilder.OngoingReadingWithWhere)Cypher.match((PatternElement[])new PatternElement[]{rootNode}).where(CypherGenerator.conditionOrNoCondition(condition))).detachDelete(new Named[]{rootNode});
        if (count) {
            return ongoingUpdate.returning(new Expression[]{Cypher.count((Node)rootNode)}).build();
        }
        return ongoingUpdate.build();
    }

    public Condition createCompositePropertyCondition(GraphPropertyDescription idProperty, SymbolicName containerName, Expression actualParameter) {
        if (!idProperty.isComposite()) {
            return Cypher.property((Expression)containerName, (String[])new String[]{idProperty.getPropertyName()}).isEqualTo(actualParameter);
        }
        Neo4jPersistentProperty property = (Neo4jPersistentProperty)idProperty;
        Condition result = Cypher.noCondition();
        for (String key : property.getOptionalConverter().write(null).keys()) {
            Property expression = Cypher.property((Expression)containerName, (String[])new String[]{key});
            result = result.and(expression.isEqualTo((Expression)actualParameter.property(key)));
        }
        return result;
    }

    public Statement prepareSaveOf(NodeDescription<?> nodeDescription, UnaryOperator<StatementBuilder.OngoingMatchAndUpdate> updateDecorator, boolean canUseElementId) {
        String primaryLabel = nodeDescription.getPrimaryLabel();
        List<String> additionalLabels = nodeDescription.getAdditionalLabels();
        Node rootNode = Cypher.node((String)primaryLabel, additionalLabels).named(Constants.NAME_OF_TYPED_ROOT_NODE.apply(nodeDescription));
        IdDescription idDescription = nodeDescription.getIdDescription();
        Assert.notNull((Object)idDescription, (String)"Cannot save individual nodes without an id attribute");
        Parameter idParameter = Cypher.parameter((String)"__id__");
        Function<StatementBuilder.OngoingMatchAndUpdate, Statement> vectorProcedureCall = bs -> {
            if (((Neo4jPersistentEntity)nodeDescription).hasVectorProperty()) {
                return ((StatementBuilder.OngoingInQueryCallWithArguments)((StatementBuilder.OngoingInQueryCallWithoutArguments)bs.with(new IdentifiableElement[]{rootNode}).call(new String[]{"db.create.setNodeVectorProperty"})).withArgs(new Expression[]{rootNode.getRequiredSymbolicName(), Cypher.parameter((String)"__vectorProperty__"), Cypher.parameter((String)"__vectorValue__")})).withoutResults().returning(new Named[]{rootNode}).build();
            }
            return bs.returning(new Named[]{rootNode}).build();
        };
        if (!idDescription.isInternallyGeneratedId()) {
            GraphPropertyDescription idPropertyDescription = (GraphPropertyDescription)((Neo4jPersistentEntity)nodeDescription).getRequiredIdProperty();
            if (((Neo4jPersistentEntity)nodeDescription).hasVersionProperty()) {
                Property versionProperty = rootNode.property(((Neo4jPersistentProperty)((Neo4jPersistentEntity)nodeDescription).getRequiredVersionProperty()).getName());
                String nameOfPossibleExistingNode = "hlp";
                Node possibleExistingNode = Cypher.node((String)primaryLabel, additionalLabels).named(nameOfPossibleExistingNode);
                Statement createIfNew = vectorProcedureCall.apply((StatementBuilder.OngoingMatchAndUpdate)updateDecorator.apply((StatementBuilder.OngoingMatchAndUpdate)((StatementBuilder.OngoingReadingWithWhere)Cypher.optionalMatch((PatternElement[])new PatternElement[]{possibleExistingNode}).where(this.createCompositePropertyCondition(idPropertyDescription, possibleExistingNode.getRequiredSymbolicName(), (Expression)idParameter))).with(new IdentifiableElement[]{possibleExistingNode}).where(possibleExistingNode.isNull()).create(new PatternElement[]{(PatternElement)rootNode.withProperties(new Object[]{versionProperty, Cypher.literalOf((Object)0)})}).with(new IdentifiableElement[]{rootNode}).mutate((Named)rootNode, (Expression)Cypher.parameter((String)"__properties__"))));
                Statement updateIfExists = vectorProcedureCall.apply((StatementBuilder.OngoingMatchAndUpdate)updateDecorator.apply((StatementBuilder.OngoingMatchAndUpdate)((StatementBuilder.OngoingReadingWithWhere)((StatementBuilder.OngoingReadingWithWhere)Cypher.match((PatternElement[])new PatternElement[]{rootNode}).where(this.createCompositePropertyCondition(idPropertyDescription, rootNode.getRequiredSymbolicName(), (Expression)idParameter))).and(versionProperty.isEqualTo((Expression)Cypher.parameter((String)"__version__")))).set(new Expression[]{versionProperty.to((Expression)versionProperty.add((Expression)Cypher.literalOf((Object)1)))}).with(new IdentifiableElement[]{rootNode}).where(versionProperty.isEqualTo((Expression)Cypher.coalesce((Expression[])new Expression[]{Cypher.parameter((String)"__version__"), Cypher.literalOf((Object)0)}).add((Expression)Cypher.literalOf((Object)1)))).mutate((Named)rootNode, (Expression)Cypher.parameter((String)"__properties__"))));
                return Cypher.union((Statement[])new Statement[]{createIfNew, updateIfExists});
            }
            String nameOfPossibleExistingNode = "hlp";
            Node possibleExistingNode = Cypher.node((String)primaryLabel, additionalLabels).named(nameOfPossibleExistingNode);
            Statement createIfNew = vectorProcedureCall.apply((StatementBuilder.OngoingMatchAndUpdate)updateDecorator.apply((StatementBuilder.OngoingMatchAndUpdate)((StatementBuilder.OngoingReadingWithWhere)Cypher.optionalMatch((PatternElement[])new PatternElement[]{possibleExistingNode}).where(this.createCompositePropertyCondition(idPropertyDescription, possibleExistingNode.getRequiredSymbolicName(), (Expression)idParameter))).with(new IdentifiableElement[]{possibleExistingNode}).where(possibleExistingNode.isNull()).create(new PatternElement[]{rootNode}).with(new IdentifiableElement[]{rootNode}).mutate((Named)rootNode, (Expression)Cypher.parameter((String)"__properties__"))));
            Statement updateIfExists = vectorProcedureCall.apply((StatementBuilder.OngoingMatchAndUpdate)updateDecorator.apply((StatementBuilder.OngoingMatchAndUpdate)((StatementBuilder.OngoingReadingWithWhere)Cypher.match((PatternElement[])new PatternElement[]{rootNode}).where(this.createCompositePropertyCondition(idPropertyDescription, rootNode.getRequiredSymbolicName(), (Expression)idParameter))).with(new IdentifiableElement[]{rootNode}).mutate((Named)rootNode, (Expression)Cypher.parameter((String)"__properties__"))));
            return Cypher.union((Statement[])new Statement[]{createIfNew, updateIfExists});
        }
        String nameOfPossibleExistingNode = "hlp";
        Node possibleExistingNode = Cypher.node((String)primaryLabel, additionalLabels).named(nameOfPossibleExistingNode);
        Neo4jPersistentEntity neo4jPersistentEntity = (Neo4jPersistentEntity)nodeDescription;
        Function<Node, Expression> nodeIdFunction = CypherGenerator.getNodeIdFunction(neo4jPersistentEntity, canUseElementId);
        if (neo4jPersistentEntity.hasVersionProperty()) {
            Property versionProperty = rootNode.property(((Neo4jPersistentProperty)neo4jPersistentEntity.getRequiredVersionProperty()).getName());
            Statement createIfNew = vectorProcedureCall.apply((StatementBuilder.OngoingMatchAndUpdate)updateDecorator.apply((StatementBuilder.OngoingMatchAndUpdate)((StatementBuilder.OngoingReadingWithWhere)Cypher.optionalMatch((PatternElement[])new PatternElement[]{possibleExistingNode}).where(nodeIdFunction.apply(possibleExistingNode).isEqualTo((Expression)idParameter))).with(new IdentifiableElement[]{possibleExistingNode}).where(possibleExistingNode.isNull()).create(new PatternElement[]{(PatternElement)rootNode.withProperties(new Object[]{versionProperty, Cypher.literalOf((Object)0)})}).with(new IdentifiableElement[]{rootNode}).mutate((Named)rootNode, (Expression)Cypher.parameter((String)"__properties__"))));
            Statement updateIfExists = vectorProcedureCall.apply((StatementBuilder.OngoingMatchAndUpdate)updateDecorator.apply((StatementBuilder.OngoingMatchAndUpdate)((StatementBuilder.OngoingReadingWithWhere)((StatementBuilder.OngoingReadingWithWhere)Cypher.match((PatternElement[])new PatternElement[]{rootNode}).where(nodeIdFunction.apply(rootNode).isEqualTo((Expression)idParameter))).and(versionProperty.isEqualTo((Expression)Cypher.parameter((String)"__version__")))).set(new Expression[]{versionProperty.to((Expression)versionProperty.add((Expression)Cypher.literalOf((Object)1)))}).with(new IdentifiableElement[]{rootNode}).where(versionProperty.isEqualTo((Expression)Cypher.coalesce((Expression[])new Expression[]{Cypher.parameter((String)"__version__"), Cypher.literalOf((Object)0)}).add((Expression)Cypher.literalOf((Object)1)))).mutate((Named)rootNode, (Expression)Cypher.parameter((String)"__properties__"))));
            return Cypher.union((Statement[])new Statement[]{createIfNew, updateIfExists});
        }
        Statement createStatement = vectorProcedureCall.apply((StatementBuilder.OngoingMatchAndUpdate)updateDecorator.apply((StatementBuilder.OngoingMatchAndUpdate)((StatementBuilder.OngoingReadingWithWhere)Cypher.optionalMatch((PatternElement[])new PatternElement[]{possibleExistingNode}).where(nodeIdFunction.apply(possibleExistingNode).isEqualTo((Expression)idParameter))).with(new IdentifiableElement[]{possibleExistingNode}).where(possibleExistingNode.isNull()).create(new PatternElement[]{rootNode}).set((Named)rootNode, (Expression)Cypher.parameter((String)"__properties__"))));
        Statement updateStatement = vectorProcedureCall.apply((StatementBuilder.OngoingMatchAndUpdate)updateDecorator.apply((StatementBuilder.OngoingMatchAndUpdate)((StatementBuilder.OngoingReadingWithWhere)Cypher.match((PatternElement[])new PatternElement[]{rootNode}).where(nodeIdFunction.apply(rootNode).isEqualTo((Expression)idParameter))).mutate((Named)rootNode, (Expression)Cypher.parameter((String)"__properties__"))));
        return Cypher.union((Statement[])new Statement[]{createStatement, updateStatement});
    }

    public Statement prepareSaveOfMultipleInstancesOf(NodeDescription<?> nodeDescription) {
        Neo4jPersistentEntity entity;
        Assert.isTrue((!nodeDescription.isUsingInternalIds() ? 1 : 0) != 0, (String)"Only entities that use external IDs can be saved in a batch");
        Node rootNode = Cypher.node((String)nodeDescription.getPrimaryLabel(), nodeDescription.getAdditionalLabels()).named(Constants.NAME_OF_TYPED_ROOT_NODE.apply(nodeDescription));
        IdDescription idDescription = nodeDescription.getIdDescription();
        String nameOfIdProperty = idDescription.getOptionalGraphPropertyName().orElseThrow(() -> new MappingException("External id does not correspond to a graph property"));
        ArrayList<AliasedExpression> expressions = new ArrayList<AliasedExpression>();
        if (nodeDescription instanceof Neo4jPersistentEntity && (entity = (Neo4jPersistentEntity)nodeDescription).isUsingDeprecatedInternalId()) {
            rootNode.internalId().as("__internalNeo4jId__");
        }
        expressions.add(this.elementIdOrIdFunction.apply((Named)rootNode).as("__elementId__"));
        expressions.add(rootNode.property(nameOfIdProperty).as("__id__"));
        String row = "entity";
        return Cypher.unwind((Expression)Cypher.parameter((String)"__entities__")).as(row).merge(new PatternElement[]{(PatternElement)rootNode.withProperties(new Object[]{nameOfIdProperty, Cypher.property((String)row, (String[])new String[]{"__id__"})})}).mutate((Named)rootNode, (Expression)Cypher.property((String)row, (String[])new String[]{"__properties__"})).returning(expressions).build();
    }

    @NonNull
    public Statement prepareSaveOfRelationship(Neo4jPersistentEntity<?> neo4jPersistentEntity, RelationshipDescription relationship, @Nullable String dynamicRelationshipType, boolean canUseElementId) {
        Node startNode = neo4jPersistentEntity.isUsingInternalIds() ? Cypher.anyNode((SymbolicName)START_NODE_NAME) : Cypher.node((String)neo4jPersistentEntity.getPrimaryLabel(), (List)neo4jPersistentEntity.getAdditionalLabels()).named(START_NODE_NAME);
        Node endNode = Cypher.anyNode((SymbolicName)END_NODE_NAME);
        Parameter idParameter = Cypher.parameter((String)"fromId");
        String type = relationship.isDynamic() ? dynamicRelationshipType : relationship.getType();
        Relationship relationshipFragment = (relationship.isOutgoing() ? (Relationship)startNode.relationshipTo(endNode, new String[]{type}) : (Relationship)startNode.relationshipFrom(endNode, new String[]{type})).named(RELATIONSHIP_NAME);
        Function<Node, Expression> startNodeIdFunction = CypherGenerator.getNodeIdFunction(neo4jPersistentEntity, canUseElementId);
        return ((StatementBuilder.OngoingReadingWithWhere)((StatementBuilder.OngoingReadingWithWhere)Cypher.match((PatternElement[])new PatternElement[]{startNode}).where(startNodeIdFunction.apply(startNode).isEqualTo((Expression)idParameter))).match(new PatternElement[]{endNode}).where(CypherGenerator.getEndNodeIdFunction((Neo4jPersistentEntity)relationship.getTarget(), canUseElementId).apply(endNode).isEqualTo((Expression)Cypher.parameter((String)"toId")))).merge(new PatternElement[]{relationshipFragment}).returning(this.getReturnedIdExpressionsForRelationship(relationship, relationshipFragment)).build();
    }

    private static Function<Node, Expression> getNodeIdFunction(@Nullable Neo4jPersistentEntity<?> entity, boolean canUseElementId) {
        Neo4jPersistentProperty idProperty = (Neo4jPersistentProperty)entity.getRequiredIdProperty();
        Function<Node, Expression> startNodeIdFunction = entity.isUsingInternalIds() ? (entity.isUsingDeprecatedInternalId() || !canUseElementId ? Node::internalId : Cypher::elementId) : node -> node.property(idProperty.getPropertyName());
        return startNodeIdFunction;
    }

    private static Function<Node, Expression> getEndNodeIdFunction(@Nullable Neo4jPersistentEntity<?> entity, boolean canUseElementId) {
        if (entity == null) {
            return Cypher::elementId;
        }
        Function<Node, Expression> startNodeIdFunction = !entity.isUsingDeprecatedInternalId() && canUseElementId ? Cypher::elementId : Node::internalId;
        return startNodeIdFunction;
    }

    static Expression relId(Relationship r) {
        return FunctionInvocation.create(() -> "id", (Expression[])new Expression[]{r.getRequiredSymbolicName()});
    }

    private static Function<Relationship, Expression> getRelationshipIdFunction(RelationshipDescription relationshipDescription, boolean canUseElementId) {
        Function<Relationship, Expression> result;
        Function<Relationship, Expression> function = result = canUseElementId ? Cypher::elementId : CypherGenerator::relId;
        if (relationshipDescription.hasRelationshipProperties()) {
            Neo4jPersistentEntity entity = (Neo4jPersistentEntity)relationshipDescription.getRelationshipPropertiesEntity();
            result = entity != null && entity.isUsingDeprecatedInternalId() || !canUseElementId ? CypherGenerator::relId : Cypher::elementId;
        }
        return result;
    }

    @NonNull
    public Statement prepareSaveOfRelationships(Neo4jPersistentEntity<?> neo4jPersistentEntity, RelationshipDescription relationship, @Nullable String dynamicRelationshipType, boolean canUseElementId) {
        Node startNode = neo4jPersistentEntity.isUsingInternalIds() ? Cypher.anyNode((SymbolicName)START_NODE_NAME) : Cypher.node((String)neo4jPersistentEntity.getPrimaryLabel(), (List)neo4jPersistentEntity.getAdditionalLabels()).named(START_NODE_NAME);
        Node endNode = Cypher.anyNode((SymbolicName)END_NODE_NAME);
        String type = relationship.isDynamic() ? dynamicRelationshipType : relationship.getType();
        Relationship relationshipFragment = (relationship.isOutgoing() ? (Relationship)startNode.relationshipTo(endNode, new String[]{type}) : (Relationship)startNode.relationshipFrom(endNode, new String[]{type})).named(RELATIONSHIP_NAME);
        String row = "relationship";
        Property idProperty = Cypher.property((String)row, (String[])new String[]{"fromId"});
        return ((StatementBuilder.OngoingReadingWithWhere)((StatementBuilder.OngoingReadingWithWhere)Cypher.unwind((Expression)Cypher.parameter((String)"__relationships__")).as(row).with(new String[]{row}).match(new PatternElement[]{startNode}).where(CypherGenerator.getNodeIdFunction(neo4jPersistentEntity, canUseElementId).apply(startNode).isEqualTo((Expression)idProperty))).match(new PatternElement[]{endNode}).where(CypherGenerator.getEndNodeIdFunction((Neo4jPersistentEntity)relationship.getTarget(), canUseElementId).apply(endNode).isEqualTo((Expression)Cypher.property((String)row, (String[])new String[]{"toId"})))).merge(new PatternElement[]{relationshipFragment}).returning(this.getReturnedIdExpressionsForRelationship(relationship, relationshipFragment)).build();
    }

    @NonNull
    public Statement prepareSaveOfRelationshipWithProperties(Neo4jPersistentEntity<?> neo4jPersistentEntity, RelationshipDescription relationship, boolean isNew, @Nullable String dynamicRelationshipType, boolean canUseElementId, boolean matchOnly) {
        Assert.isTrue((boolean)relationship.hasRelationshipProperties(), (String)"Properties required to create a relationship with properties");
        Node startNode = Cypher.node((String)neo4jPersistentEntity.getPrimaryLabel(), (List)neo4jPersistentEntity.getAdditionalLabels()).named(START_NODE_NAME);
        Node endNode = Cypher.anyNode((SymbolicName)END_NODE_NAME);
        Parameter idParameter = Cypher.parameter((String)"fromId");
        Parameter relationshipProperties = Cypher.parameter((String)"__properties__");
        String type = relationship.isDynamic() ? dynamicRelationshipType : relationship.getType();
        Relationship relationshipFragment = (relationship.isOutgoing() ? (Relationship)startNode.relationshipTo(endNode, new String[]{type}) : (Relationship)startNode.relationshipFrom(endNode, new String[]{type})).named(RELATIONSHIP_NAME);
        Function<Node, Expression> nodeIdFunction = CypherGenerator.getNodeIdFunction(neo4jPersistentEntity, canUseElementId);
        Function<Relationship, Expression> relationshipIdFunction = CypherGenerator.getRelationshipIdFunction(relationship, canUseElementId);
        StatementBuilder.OngoingReadingWithWhere startAndEndNodeMatch = (StatementBuilder.OngoingReadingWithWhere)((StatementBuilder.OngoingReadingWithWhere)Cypher.match((PatternElement[])new PatternElement[]{startNode}).where(nodeIdFunction.apply(startNode).isEqualTo((Expression)idParameter))).match(new PatternElement[]{endNode}).where(CypherGenerator.getEndNodeIdFunction((Neo4jPersistentEntity)relationship.getTarget(), canUseElementId).apply(endNode).isEqualTo((Expression)Cypher.parameter((String)"toId")));
        if (matchOnly) {
            return startAndEndNodeMatch.match(new PatternElement[]{relationshipFragment}).returning(this.getReturnedIdExpressionsForRelationship(relationship, relationshipFragment)).build();
        }
        StatementBuilder.OngoingUpdate createOrMatch = isNew ? startAndEndNodeMatch.create(new PatternElement[]{relationshipFragment}) : (StatementBuilder.ExposesSet)startAndEndNodeMatch.match(new PatternElement[]{relationshipFragment}).where(relationshipIdFunction.apply(relationshipFragment).isEqualTo((Expression)Cypher.parameter((String)"__knownRelationShipId__")));
        return createOrMatch.mutate((Expression)RELATIONSHIP_NAME, (Expression)relationshipProperties).returning(this.getReturnedIdExpressionsForRelationship(relationship, relationshipFragment)).build();
    }

    @NonNull
    public Statement prepareUpdateOfRelationshipsWithProperties(Neo4jPersistentEntity<?> neo4jPersistentEntity, RelationshipDescription relationship, boolean isNew, boolean canUseElementId) {
        Assert.isTrue((boolean)relationship.hasRelationshipProperties(), (String)"Properties required to create a relationship with properties");
        Node startNode = Cypher.node((String)neo4jPersistentEntity.getPrimaryLabel(), (List)neo4jPersistentEntity.getAdditionalLabels()).named(START_NODE_NAME);
        Node endNode = Cypher.anyNode((SymbolicName)END_NODE_NAME);
        String type = relationship.getType();
        Relationship relationshipFragment = (relationship.isOutgoing() ? (Relationship)startNode.relationshipTo(endNode, new String[]{type}) : (Relationship)startNode.relationshipFrom(endNode, new String[]{type})).named(RELATIONSHIP_NAME);
        String row = "row";
        Property relationshipProperties = Cypher.property((String)row, (String[])new String[]{"__properties__"});
        Property idProperty = Cypher.property((String)row, (String[])new String[]{"fromId"});
        StatementBuilder.OrderableOngoingReadingAndWithWithoutWhere cypherUnwind = Cypher.unwind((Expression)Cypher.parameter((String)"__relationships__")).as(row).with(new String[]{row});
        Function<Node, Expression> nodeIdFunction = CypherGenerator.getNodeIdFunction(neo4jPersistentEntity, canUseElementId);
        Function<Relationship, Expression> relationshipIdFunction = CypherGenerator.getRelationshipIdFunction(relationship, canUseElementId);
        if (isNew) {
            return ((StatementBuilder.OngoingReadingWithWhere)((StatementBuilder.OngoingReadingWithWhere)cypherUnwind.match(new PatternElement[]{startNode}).where(nodeIdFunction.apply(startNode).isEqualTo((Expression)idProperty))).match(new PatternElement[]{endNode}).where(CypherGenerator.getEndNodeIdFunction((Neo4jPersistentEntity)relationship.getTarget(), canUseElementId).apply(endNode).isEqualTo((Expression)Cypher.property((String)row, (String[])new String[]{"toId"})))).create(new PatternElement[]{relationshipFragment}).mutate((Expression)RELATIONSHIP_NAME, (Expression)relationshipProperties).returning(this.getReturnedIdExpressionsForRelationship(relationship, relationshipFragment)).build();
        }
        return ((StatementBuilder.OngoingReadingWithWhere)cypherUnwind.match(new PatternElement[]{relationshipFragment}).where(relationshipIdFunction.apply(relationshipFragment).isEqualTo((Expression)Cypher.property((String)row, (String[])new String[]{"__knownRelationShipId__"})))).mutate((Expression)RELATIONSHIP_NAME, (Expression)relationshipProperties).build();
    }

    private List<Expression> getReturnedIdExpressionsForRelationship(RelationshipDescription relationship, Relationship relationshipFragment) {
        Neo4jPersistentEntity entity;
        NodeDescription<?> nodeDescription;
        ArrayList<Expression> result = new ArrayList<Expression>();
        if (relationship.hasRelationshipProperties() && (nodeDescription = relationship.getRelationshipPropertiesEntity()) instanceof Neo4jPersistentEntity && (entity = (Neo4jPersistentEntity)nodeDescription).isUsingDeprecatedInternalId()) {
            result.add((Expression)CypherGenerator.relId(relationshipFragment).as("__internalNeo4jId__"));
        }
        result.add((Expression)this.elementIdOrIdFunction.apply((Named)relationshipFragment).as("__elementId__"));
        return result;
    }

    @NonNull
    public Statement prepareDeleteOf(Neo4jPersistentEntity<?> neo4jPersistentEntity, RelationshipDescription relationshipDescription, boolean canUseElementId) {
        Node startNode = neo4jPersistentEntity.isUsingInternalIds() ? Cypher.anyNode((SymbolicName)START_NODE_NAME) : Cypher.node((String)neo4jPersistentEntity.getPrimaryLabel(), (List)neo4jPersistentEntity.getAdditionalLabels()).named(START_NODE_NAME);
        NodeDescription<?> target = relationshipDescription.getTarget();
        Node endNode = Cypher.node((String)target.getPrimaryLabel(), target.getAdditionalLabels());
        boolean outgoing = relationshipDescription.isOutgoing();
        String relationshipType = relationshipDescription.isDynamic() ? null : relationshipDescription.getType();
        String relationshipToRemoveName = "rel";
        Relationship relationship = outgoing ? ((Relationship)startNode.relationshipTo(endNode, new String[]{relationshipType})).named(relationshipToRemoveName) : ((Relationship)startNode.relationshipFrom(endNode, new String[]{relationshipType})).named(relationshipToRemoveName);
        Parameter idParameter = Cypher.parameter((String)"fromId");
        return ((StatementBuilder.OngoingReadingWithWhere)((StatementBuilder.OngoingReadingWithWhere)Cypher.match((PatternElement[])new PatternElement[]{relationship}).where(CypherGenerator.getNodeIdFunction(neo4jPersistentEntity, canUseElementId).apply(startNode).isEqualTo((Expression)idParameter))).and(CypherGenerator.getRelationshipIdFunction(relationshipDescription, canUseElementId).apply(relationship).in((Expression)Cypher.parameter((String)"__knownRelationShipIds__")).not())).delete(new Expression[]{relationship.getRequiredSymbolicName()}).build();
    }

    public Collection<Expression> createReturnStatementForExists(Neo4jPersistentEntity<?> nodeDescription) {
        return Collections.singleton(Cypher.count((Expression)((Expression)Constants.NAME_OF_TYPED_ROOT_NODE.apply(nodeDescription))));
    }

    public Collection<Expression> createReturnStatementForMatch(Neo4jPersistentEntity<?> nodeDescription) {
        return this.createReturnStatementForMatch(nodeDescription, PropertyFilter.NO_FILTER, new Expression[0]);
    }

    @Nullable
    public String createOrderByFragment(@Nullable Sort sort) {
        if (sort == null || sort.isUnsorted()) {
            return null;
        }
        Statement statement = Cypher.match((PatternElement[])new PatternElement[]{Cypher.anyNode()}).returning(new String[]{"n"}).orderBy((SortItem[])sort.stream().filter(Objects::nonNull).map(order -> {
            Expression expression;
            String property = order.getProperty().trim();
            if (LOOKS_LIKE_A_FUNCTION.matcher(property).matches()) {
                expression = Cypher.raw((String)property, (Object[])new Object[0]);
            } else if (property.contains(".")) {
                int firstDot = property.indexOf(46);
                String tail = property.substring(firstDot + 1);
                if (tail.isEmpty() || property.lastIndexOf(".") != firstDot) {
                    if (tail.trim().matches("`.+`")) {
                        tail = tail.replaceFirst("`(.+)`", "$1");
                    } else {
                        throw new IllegalArgumentException(String.format("Cannot handle order property `%s`, it must be a simple property or one-hop path", property));
                    }
                }
                expression = Cypher.property((String)property.substring(0, firstDot), (String[])new String[]{tail});
            } else {
                try {
                    Assert.isTrue((boolean)SourceVersion.isIdentifier(property), (String)"Name must be a valid identifier.");
                    expression = Cypher.name((String)property);
                }
                catch (IllegalArgumentException e) {
                    if (e.getMessage().endsWith(".")) {
                        throw new IllegalArgumentException(e.getMessage().substring(0, e.getMessage().length() - 1));
                    }
                    throw e;
                }
            }
            if (order.isIgnoreCase()) {
                expression = Cypher.toLower((Expression)expression);
            }
            return order.isAscending() ? expression.ascending() : expression.descending();
        }).toArray(SortItem[]::new)).build();
        String renderedStatement = Renderer.getRenderer((Configuration)Configuration.defaultConfig()).render(statement);
        return renderedStatement.substring(renderedStatement.indexOf("ORDER BY")).trim();
    }

    public Collection<Expression> createReturnStatementForMatch(Neo4jPersistentEntity<?> nodeDescription, Predicate<PropertyFilter.RelaxedPropertyPath> includeField, Expression ... additionalExpressions) {
        ArrayList<RelationshipDescription> processedRelationships = new ArrayList<RelationshipDescription>();
        if (nodeDescription.containsPossibleCircles(includeField)) {
            return this.createGenericReturnStatement(additionalExpressions);
        }
        ArrayList<Expression> returnContent = new ArrayList<Expression>();
        returnContent.add((Expression)this.projectPropertiesAndRelationships(PropertyFilter.RelaxedPropertyPath.withRootType(nodeDescription.getUnderlyingClass()), nodeDescription, Constants.NAME_OF_TYPED_ROOT_NODE.apply(nodeDescription), includeField, null, processedRelationships, new Expression[0]));
        Collections.addAll(returnContent, additionalExpressions);
        return returnContent;
    }

    public Collection<Expression> createGenericReturnStatement(Expression ... additionalExpressions) {
        ArrayList<Expression> returnExpressions = new ArrayList<Expression>();
        returnExpressions.add((Expression)Cypher.name((String)"__sn__"));
        returnExpressions.add((Expression)Cypher.name((String)"__srn__"));
        returnExpressions.add((Expression)Cypher.name((String)"__sr__"));
        returnExpressions.addAll(Arrays.asList(additionalExpressions));
        return returnExpressions;
    }

    public StatementBuilder.OngoingReading prepareFindOf(NodeDescription<?> nodeDescription, @Nullable List<PatternElement> initialMatchOn, @Nullable Condition condition) {
        Node rootNode = this.createRootNode(nodeDescription);
        return (StatementBuilder.OngoingReading)this.prepareMatchOfRootNode(rootNode, initialMatchOn).where(CypherGenerator.conditionOrNoCondition(condition));
    }

    private MapProjection projectPropertiesAndRelationships(PropertyFilter.RelaxedPropertyPath parentPath, Neo4jPersistentEntity<?> nodeDescription, SymbolicName nodeName, Predicate<PropertyFilter.RelaxedPropertyPath> includedProperties, @Nullable RelationshipDescription relationshipDescription, List<RelationshipDescription> processedRelationships, Expression ... additionalExpressions) {
        Collection<RelationshipDescription> relationships = ((DefaultNeo4jPersistentEntity)nodeDescription).getRelationshipsInHierarchy(includedProperties, parentPath);
        relationships.removeIf(r -> !includedProperties.test(parentPath.append(r.getFieldName())));
        List<Object> propertiesProjection = this.projectNodeProperties(parentPath, nodeDescription, nodeName, relationshipDescription, includedProperties);
        ArrayList<Object> contentOfProjection = new ArrayList<Object>(propertiesProjection);
        contentOfProjection.addAll(this.generateListsFor(parentPath, nodeDescription, relationships, nodeName, includedProperties, processedRelationships));
        return Cypher.anyNode((SymbolicName)nodeName).project(contentOfProjection);
    }

    private List<Object> projectNodeProperties(PropertyFilter.RelaxedPropertyPath parentPath, NodeDescription<?> nodeDescription, SymbolicName nodeName, @Nullable RelationshipDescription relationshipDescription, Predicate<PropertyFilter.RelaxedPropertyPath> includeField) {
        Neo4jPersistentEntity entity;
        ArrayList<Object> nodePropertiesProjection = new ArrayList<Object>();
        Node node = Cypher.anyNode((SymbolicName)nodeName);
        boolean hasCompositeProperties = false;
        for (GraphPropertyDescription graphProperty : nodeDescription.getGraphPropertiesInHierarchy()) {
            PropertyFilter.RelaxedPropertyPath from;
            Neo4jPersistentProperty property = (Neo4jPersistentProperty)graphProperty;
            boolean bl = hasCompositeProperties = hasCompositeProperties || property.isComposite();
            if (property.isDynamicLabels() || property.isComposite() || !includeField.test(from = parentPath.append(property.getFieldName())) || graphProperty.isIdProperty() && nodeDescription.getIdDescription() != null && nodeDescription.getIdDescription().isInternallyGeneratedId()) continue;
            nodePropertiesProjection.add(graphProperty.getPropertyName());
        }
        if (hasCompositeProperties || nodeDescription.describesInterface()) {
            nodePropertiesProjection.add("__allProperties__");
            nodePropertiesProjection.add(node.project(new Object[]{Cypher.asterisk()}));
        }
        nodePropertiesProjection.add("__nodeLabels__");
        nodePropertiesProjection.add(Cypher.labels((Node)node));
        if (nodeDescription instanceof Neo4jPersistentEntity && (entity = (Neo4jPersistentEntity)nodeDescription).isUsingDeprecatedInternalId()) {
            nodePropertiesProjection.add("__internalNeo4jId__");
            nodePropertiesProjection.add(node.internalId());
        }
        nodePropertiesProjection.add("__elementId__");
        nodePropertiesProjection.add(this.elementIdOrIdFunction.apply((Named)node));
        return nodePropertiesProjection;
    }

    private List<Object> generateListsFor(PropertyFilter.RelaxedPropertyPath parentPath, Neo4jPersistentEntity<?> nodeDescription, Collection<RelationshipDescription> relationships, SymbolicName nodeName, Predicate<PropertyFilter.RelaxedPropertyPath> includedProperties, List<RelationshipDescription> processedRelationships) {
        ArrayList<Object> mapProjectionLists = new ArrayList<Object>();
        for (RelationshipDescription relationshipDescription : relationships) {
            String fieldName = relationshipDescription.getFieldName();
            if (relationshipDescription.hasRelationshipObverse() && processedRelationships.contains(relationshipDescription.getRelationshipObverse())) continue;
            this.generateListFor(parentPath, nodeDescription, relationshipDescription, nodeName, processedRelationships, fieldName, mapProjectionLists, includedProperties);
        }
        return mapProjectionLists;
    }

    private void generateListFor(PropertyFilter.RelaxedPropertyPath parentPath, Neo4jPersistentEntity<?> nodeDescription, RelationshipDescription relationshipDescription, SymbolicName nodeName, List<RelationshipDescription> processedRelationships, String fieldName, List<Object> mapProjectionLists, Predicate<PropertyFilter.RelaxedPropertyPath> includedProperties) {
        PropertyFilter.RelaxedPropertyPath newParentPath;
        String relationshipType = relationshipDescription.getType();
        String relationshipTargetName = relationshipDescription.generateRelatedNodesCollectionName(nodeDescription);
        String sourcePrimaryLabel = relationshipDescription.getSource().getMostAbstractParentLabel(nodeDescription);
        String targetPrimaryLabel = relationshipDescription.getTarget().getPrimaryLabel();
        List<String> targetAdditionalLabels = relationshipDescription.getTarget().getAdditionalLabels();
        String relationshipSymbolicName = sourcePrimaryLabel + "__relationship__" + targetPrimaryLabel;
        Node startNode = Cypher.anyNode((SymbolicName)nodeName);
        SymbolicName relationshipFieldName = nodeName.concat("_" + fieldName);
        Node endNode = Cypher.node((String)targetPrimaryLabel, targetAdditionalLabels).named(relationshipFieldName);
        Neo4jPersistentEntity endNodeDescription = (Neo4jPersistentEntity)relationshipDescription.getTarget();
        processedRelationships.add(relationshipDescription);
        PropertyFilter.RelaxedPropertyPath relaxedPropertyPath = newParentPath = relationshipDescription.hasRelationshipProperties() ? parentPath.append(relationshipDescription.getFieldName()).append(((Neo4jPersistentProperty)((Neo4jPersistentEntity)relationshipDescription.getRelationshipPropertiesEntity()).getPersistentProperty(TargetNode.class)).getFieldName()) : parentPath.append(relationshipDescription.getFieldName());
        if (relationshipDescription.isDynamic()) {
            Relationship relationship = relationshipDescription.isOutgoing() ? (Relationship)startNode.relationshipTo(endNode, new String[0]) : (Relationship)startNode.relationshipFrom(endNode, new String[0]);
            relationship = relationship.named(relationshipTargetName);
            MapProjection mapProjection = this.projectPropertiesAndRelationships(newParentPath, endNodeDescription, relationshipFieldName, includedProperties, relationshipDescription, new ArrayList<RelationshipDescription>(processedRelationships), new Expression[0]);
            if (relationshipDescription.hasRelationshipProperties()) {
                relationship = relationship.named(relationshipSymbolicName);
                mapProjection = mapProjection.and(new Object[]{relationship});
            }
            this.addMapProjection(relationshipTargetName, Cypher.listBasedOn((RelationshipPattern)relationship).returning(new Expression[]{mapProjection.and(new Object[]{"__relationshipType__", Cypher.type((Relationship)relationship)})}), mapProjectionLists);
        } else {
            Relationship relationship = relationshipDescription.isOutgoing() ? (Relationship)startNode.relationshipTo(endNode, new String[]{relationshipType}) : (Relationship)startNode.relationshipFrom(endNode, new String[]{relationshipType});
            MapProjection mapProjection = this.projectPropertiesAndRelationships(newParentPath, endNodeDescription, relationshipFieldName, includedProperties, relationshipDescription, new ArrayList<RelationshipDescription>(processedRelationships), new Expression[0]);
            if (relationshipDescription.hasRelationshipProperties()) {
                relationship = relationship.named(relationshipSymbolicName);
                mapProjection = mapProjection.and(new Object[]{relationship});
            }
            this.addMapProjection(relationshipTargetName, Cypher.listBasedOn((RelationshipPattern)relationship).returning(new Expression[]{mapProjection}), mapProjectionLists);
        }
    }

    private void addMapProjection(String name, Object projection, List<Object> projectionList) {
        projectionList.add(name);
        projectionList.add(projection);
    }

    private static Condition conditionOrNoCondition(@Nullable Condition condition) {
        return condition == null ? Cypher.noCondition() : condition;
    }

    static {
        START_NODE_NAME = Cypher.name((String)"startNode");
        END_NODE_NAME = Cypher.name((String)"endNode");
        RELATIONSHIP_NAME = Cypher.name((String)"relProps");
        LOOKS_LIKE_A_FUNCTION = Pattern.compile(".+\\(.*\\)");
    }
}

