/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.function;

import io.r2dbc.spi.Row;
import io.r2dbc.spi.RowMetadata;
import io.r2dbc.spi.Statement;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.dao.InvalidDataAccessResourceUsageException;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.r2dbc.dialect.ArrayColumns;
import org.springframework.data.r2dbc.dialect.BindMarker;
import org.springframework.data.r2dbc.dialect.BindMarkers;
import org.springframework.data.r2dbc.dialect.Dialect;
import org.springframework.data.r2dbc.dialect.LimitClause;
import org.springframework.data.r2dbc.function.BindIdOperation;
import org.springframework.data.r2dbc.function.BindableOperation;
import org.springframework.data.r2dbc.function.QueryOperation;
import org.springframework.data.r2dbc.function.ReactiveDataAccessStrategy;
import org.springframework.data.r2dbc.function.convert.EntityRowMapper;
import org.springframework.data.r2dbc.function.convert.R2dbcCustomConversions;
import org.springframework.data.r2dbc.function.convert.SettableValue;
import org.springframework.data.relational.core.conversion.BasicRelationalConverter;
import org.springframework.data.relational.core.conversion.RelationalConverter;
import org.springframework.data.relational.core.mapping.RelationalMappingContext;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class DefaultReactiveDataAccessStrategy
implements ReactiveDataAccessStrategy {
    private final Dialect dialect;
    private final RelationalConverter relationalConverter;
    private final MappingContext<RelationalPersistentEntity<?>, ? extends RelationalPersistentProperty> mappingContext;

    public DefaultReactiveDataAccessStrategy(Dialect dialect) {
        this(dialect, (RelationalConverter)DefaultReactiveDataAccessStrategy.createConverter(dialect));
    }

    private static BasicRelationalConverter createConverter(Dialect dialect) {
        Assert.notNull((Object)dialect, (String)"Dialect must not be null");
        R2dbcCustomConversions customConversions = new R2dbcCustomConversions(CustomConversions.StoreConversions.of((SimpleTypeHolder)dialect.getSimpleTypeHolder(), (Object[])new Object[0]), Collections.emptyList());
        RelationalMappingContext context = new RelationalMappingContext();
        context.setSimpleTypeHolder(customConversions.getSimpleTypeHolder());
        return new BasicRelationalConverter((MappingContext)context, (CustomConversions)customConversions);
    }

    public RelationalConverter getRelationalConverter() {
        return this.relationalConverter;
    }

    public MappingContext<RelationalPersistentEntity<?>, ? extends RelationalPersistentProperty> getMappingContext() {
        return this.mappingContext;
    }

    public DefaultReactiveDataAccessStrategy(Dialect dialect, RelationalConverter converter) {
        Assert.notNull((Object)dialect, (String)"Dialect must not be null");
        Assert.notNull((Object)converter, (String)"RelationalConverter must not be null");
        this.relationalConverter = converter;
        this.mappingContext = this.relationalConverter.getMappingContext();
        this.dialect = dialect;
    }

    @Override
    public List<String> getAllColumns(Class<?> typeToRead) {
        RelationalPersistentEntity<?> persistentEntity = this.getPersistentEntity(typeToRead);
        if (persistentEntity == null) {
            return Collections.singletonList("*");
        }
        ArrayList<String> columnNames = new ArrayList<String>();
        for (RelationalPersistentProperty property : persistentEntity) {
            columnNames.add(property.getColumnName());
        }
        return columnNames;
    }

    @Override
    public List<SettableValue> getValuesToInsert(Object object) {
        Class userClass = ClassUtils.getUserClass((Object)object);
        RelationalPersistentEntity<?> entity = this.getRequiredPersistentEntity(userClass);
        PersistentPropertyAccessor propertyAccessor = entity.getPropertyAccessor(object);
        ArrayList<SettableValue> values = new ArrayList<SettableValue>();
        for (RelationalPersistentProperty property : entity) {
            Object value = this.getWriteValue(propertyAccessor, property);
            if (value == null) continue;
            values.add(new SettableValue(property.getColumnName(), value, property.getType()));
        }
        return values;
    }

    @Override
    public Map<String, SettableValue> getColumnsToUpdate(Object object) {
        Assert.notNull((Object)object, (String)"Entity object must not be null!");
        Class userClass = ClassUtils.getUserClass((Object)object);
        RelationalPersistentEntity<?> entity = this.getRequiredPersistentEntity(userClass);
        LinkedHashMap<String, SettableValue> update = new LinkedHashMap<String, SettableValue>();
        PersistentPropertyAccessor propertyAccessor = entity.getPropertyAccessor(object);
        for (RelationalPersistentProperty property : entity) {
            Object writeValue = this.getWriteValue(propertyAccessor, property);
            update.put(property.getColumnName(), new SettableValue(property.getColumnName(), writeValue, property.getType()));
        }
        return update;
    }

    @Override
    public Sort getMappedSort(Class<?> typeToRead, Sort sort) {
        RelationalPersistentEntity<?> entity = this.getPersistentEntity(typeToRead);
        if (entity == null) {
            return sort;
        }
        ArrayList<Sort.Order> mappedOrder = new ArrayList<Sort.Order>();
        for (Sort.Order order : sort) {
            RelationalPersistentProperty persistentProperty = (RelationalPersistentProperty)entity.getPersistentProperty(order.getProperty());
            if (persistentProperty == null) {
                mappedOrder.add(order);
                continue;
            }
            mappedOrder.add(Sort.Order.by((String)persistentProperty.getColumnName()).with(order.getNullHandling()).with(order.getDirection()));
        }
        return Sort.by(mappedOrder);
    }

    @Override
    public <T> BiFunction<Row, RowMetadata, T> getRowMapper(Class<T> typeToRead) {
        return new EntityRowMapper(this.getRequiredPersistentEntity(typeToRead), this.relationalConverter);
    }

    @Override
    public String getTableName(Class<?> type) {
        return this.getRequiredPersistentEntity(type).getTableName();
    }

    private RelationalPersistentEntity<?> getRequiredPersistentEntity(Class<?> typeToRead) {
        return (RelationalPersistentEntity)this.mappingContext.getRequiredPersistentEntity(typeToRead);
    }

    @Nullable
    private RelationalPersistentEntity<?> getPersistentEntity(Class<?> typeToRead) {
        return (RelationalPersistentEntity)this.mappingContext.getPersistentEntity(typeToRead);
    }

    private Object getWriteValue(PersistentPropertyAccessor propertyAccessor, RelationalPersistentProperty property) {
        TypeInformation type = property.getTypeInformation();
        Object value = propertyAccessor.getProperty((PersistentProperty)property);
        if (type.isCollectionLike()) {
            RelationalPersistentEntity nestedEntity = (RelationalPersistentEntity)this.mappingContext.getPersistentEntity(type.getRequiredActualType().getType());
            if (nestedEntity != null) {
                throw new InvalidDataAccessApiUsageException("Nested entities are not supported");
            }
            ArrayColumns arrayColumns = this.dialect.getArraySupport();
            if (!arrayColumns.isSupported()) {
                throw new InvalidDataAccessResourceUsageException("Dialect " + this.dialect.getClass().getName() + " does not support array columns");
            }
            return this.getArrayValue(arrayColumns, property, value);
        }
        return value;
    }

    private Object getArrayValue(ArrayColumns arrayColumns, RelationalPersistentProperty property, Object value) {
        Class<?> targetType = arrayColumns.getArrayType(property.getActualType());
        if (!property.isArray() || !property.getActualType().equals(targetType)) {
            Object zeroLengthArray = Array.newInstance(targetType, 0);
            return this.relationalConverter.getConversionService().convert(value, zeroLengthArray.getClass());
        }
        return value;
    }

    @Override
    public BindableOperation insertAndReturnGeneratedKeys(String table, Set<String> columns) {
        return new DefaultBindableInsert(this.dialect.getBindMarkersFactory().create(), table, columns, this.dialect.generatedKeysClause());
    }

    @Override
    public QueryOperation select(String table, Set<String> columns, Sort sort, Pageable page) {
        LimitClause limitClause;
        StringBuilder selectBuilder = new StringBuilder();
        selectBuilder.append("SELECT").append(' ').append(StringUtils.collectionToDelimitedString(columns, (String)", ")).append(' ').append("FROM").append(' ').append(table);
        if (sort.isSorted()) {
            selectBuilder.append(' ').append("ORDER BY").append(' ').append((CharSequence)this.getSortClause(sort));
        }
        if (page.isPaged() && (limitClause = this.dialect.limit()).getClausePosition() == LimitClause.Position.END) {
            selectBuilder.append(' ').append(limitClause.getClause(page.getPageSize(), page.getOffset()));
        }
        return selectBuilder::toString;
    }

    private StringBuilder getSortClause(Sort sort) {
        StringBuilder sortClause = new StringBuilder();
        for (Sort.Order order : sort) {
            if (sortClause.length() != 0) {
                sortClause.append(',').append(' ');
            }
            sortClause.append(order.getProperty()).append(' ').append(order.getDirection().isAscending() ? "ASC" : "DESC");
        }
        return sortClause;
    }

    @Override
    public BindIdOperation selectById(String table, Set<String> columns, String idColumn) {
        return new DefaultBindIdOperation(this.dialect.getBindMarkersFactory().create(), marker -> {
            String columnClause = StringUtils.collectionToDelimitedString((Collection)columns, (String)", ");
            return String.format("SELECT %s FROM %s WHERE %s = %s", columnClause, table, idColumn, marker.getPlaceholder());
        });
    }

    @Override
    public BindIdOperation selectById(String table, Set<String> columns, String idColumn, int limit) {
        LimitClause limitClause = this.dialect.limit();
        return new DefaultBindIdOperation(this.dialect.getBindMarkersFactory().create(), marker -> {
            String columnClause = StringUtils.collectionToDelimitedString((Collection)columns, (String)", ");
            if (limitClause.getClausePosition() == LimitClause.Position.END) {
                return String.format("SELECT %s FROM %s WHERE %s = %s ORDER BY %s %s", columnClause, table, idColumn, marker.getPlaceholder(), idColumn, limitClause.getClause(limit));
            }
            throw new UnsupportedOperationException(String.format("Limit clause position %s not supported!", new Object[]{limitClause.getClausePosition()}));
        });
    }

    @Override
    public BindIdOperation selectByIdIn(String table, Set<String> columns, String idColumn) {
        String query = String.format("SELECT %s FROM %s", StringUtils.collectionToDelimitedString(columns, (String)", "), table);
        return new DefaultBindIdIn(this.dialect.getBindMarkersFactory().create(), query, idColumn);
    }

    @Override
    public BindIdOperation updateById(String table, Set<String> columns, String idColumn) {
        return new DefaultBindableUpdate(this.dialect.getBindMarkersFactory().create(), table, columns, idColumn);
    }

    @Override
    public BindIdOperation deleteById(String table, String idColumn) {
        return new DefaultBindIdOperation(this.dialect.getBindMarkersFactory().create(), marker -> String.format("DELETE FROM %s WHERE %s = %s", table, idColumn, marker.getPlaceholder()));
    }

    @Override
    public BindIdOperation deleteByIdIn(String table, String idColumn) {
        String query = String.format("DELETE FROM %s", table);
        return new DefaultBindIdIn(this.dialect.getBindMarkersFactory().create(), query, idColumn);
    }

    static class DefaultBindIdIn
    implements BindIdOperation {
        private final List<String> markers = new ArrayList<String>();
        private final BindMarkers bindMarkers;
        private final String baseQuery;
        private final String idColumnName;

        DefaultBindIdIn(BindMarkers bindMarkers, String baseQuery, String idColumnName) {
            this.bindMarkers = bindMarkers;
            this.baseQuery = baseQuery;
            this.idColumnName = idColumnName;
        }

        @Override
        public void bind(Statement<?> statement, String identifier, Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void bindNull(Statement<?> statement, String identifier, Class<?> valueType) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void bindId(Statement<?> statement, Object value) {
            BindMarker bindMarker = this.bindMarkers.next();
            this.markers.add(bindMarker.getPlaceholder());
            bindMarker.bind(statement, value);
        }

        @Override
        public void bindIds(Statement<?> statement, Iterable<? extends Object> values) {
            for (Object object : values) {
                this.bindId(statement, object);
            }
        }

        @Override
        public String toQuery() {
            if (this.markers.isEmpty()) {
                throw new UnsupportedOperationException();
            }
            String in = StringUtils.collectionToDelimitedString(this.markers, (String)", ");
            return String.format("%s WHERE %s IN (%s)", this.baseQuery, this.idColumnName, in);
        }
    }

    static class DefaultBindIdOperation
    implements BindIdOperation {
        private final BindMarker idMarker;
        private final String query;

        DefaultBindIdOperation(BindMarkers bindMarkers, Function<BindMarker, String> queryFunction) {
            this.idMarker = bindMarkers.next();
            this.query = queryFunction.apply(this.idMarker);
        }

        @Override
        public void bind(Statement<?> statement, String identifier, Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void bindNull(Statement<?> statement, String identifier, Class<?> valueType) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void bindId(Statement<?> statement, Object value) {
            this.idMarker.bind(statement, value);
        }

        @Override
        public void bindIds(Statement<?> statement, Iterable<? extends Object> values) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String toQuery() {
            return this.query;
        }
    }

    static class DefaultBindableUpdate
    implements BindIdOperation {
        private final Map<String, BindMarker> markers = new LinkedHashMap<String, BindMarker>();
        private final BindMarker idMarker;
        private final String query;

        DefaultBindableUpdate(BindMarkers bindMarkers, String tableName, Set<String> columns, String idColumnName) {
            this.idMarker = bindMarkers.next();
            StringBuilder setClause = new StringBuilder();
            for (String column : columns) {
                BindMarker marker = this.markers.computeIfAbsent(column, bindMarkers::next);
                if (setClause.length() != 0) {
                    setClause.append(", ");
                }
                setClause.append(column).append(" = ").append(marker.getPlaceholder());
            }
            this.query = String.format("UPDATE %s SET %s WHERE %s = %s", tableName, setClause, idColumnName, this.idMarker.getPlaceholder());
        }

        @Override
        public void bind(Statement<?> statement, String identifier, Object value) {
            this.markers.get(identifier).bind(statement, value);
        }

        @Override
        public void bindNull(Statement<?> statement, String identifier, Class<?> valueType) {
            this.markers.get(identifier).bindNull(statement, valueType);
        }

        @Override
        public void bindId(Statement<?> statement, Object value) {
            this.idMarker.bind(statement, value);
        }

        @Override
        public void bindIds(Statement<?> statement, Iterable<? extends Object> values) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String toQuery() {
            return this.query;
        }
    }

    static class DefaultBindableInsert
    implements BindableOperation {
        private final Map<String, BindMarker> markers = new LinkedHashMap<String, BindMarker>();
        private final String query;

        DefaultBindableInsert(BindMarkers bindMarkers, String table, Collection<String> columns, String returningStatement) {
            StringBuilder builder = new StringBuilder();
            ArrayList<String> placeholders = new ArrayList<String>(columns.size());
            for (String column : columns) {
                BindMarker marker = this.markers.computeIfAbsent(column, bindMarkers::next);
                placeholders.add(marker.getPlaceholder());
            }
            String columnsString = StringUtils.collectionToDelimitedString(columns, (String)", ");
            String placeholdersString = StringUtils.collectionToDelimitedString(placeholders, (String)", ");
            builder.append("INSERT INTO ").append(table).append(" (").append(columnsString).append(")").append(" VALUES(").append(placeholdersString).append(")");
            if (StringUtils.hasText((String)returningStatement)) {
                builder.append(' ').append(returningStatement);
            }
            this.query = builder.toString();
        }

        @Override
        public void bind(Statement<?> statement, String identifier, Object value) {
            this.markers.get(identifier).bind(statement, value);
        }

        @Override
        public void bindNull(Statement<?> statement, String identifier, Class<?> valueType) {
            this.markers.get(identifier).bindNull(statement, valueType);
        }

        @Override
        public String toQuery() {
            return this.query;
        }
    }
}

