/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.function;

import io.r2dbc.spi.Connection;
import io.r2dbc.spi.Result;
import io.r2dbc.spi.Row;
import io.r2dbc.spi.RowMetadata;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.springframework.data.r2dbc.function.ConnectionAccessor;
import org.springframework.data.r2dbc.function.DefaultFetchSpec;
import org.springframework.data.r2dbc.function.FetchSpec;
import org.springframework.data.r2dbc.function.SqlResult;
import org.springframework.jdbc.core.SqlProvider;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class DefaultSqlResult<T>
implements SqlResult<T> {
    private static final SqlResult<?> EMPTY = new SqlResult<Object>(){

        @Override
        public <R> SqlResult<R> map(BiFunction<Row, RowMetadata, R> mappingFunction) {
            return DefaultSqlResult.empty();
        }

        @Override
        public Mono<Object> one() {
            return Mono.empty();
        }

        @Override
        public Mono<Object> first() {
            return Mono.empty();
        }

        @Override
        public Flux<Object> all() {
            return Flux.empty();
        }

        @Override
        public Mono<Integer> rowsUpdated() {
            return Mono.empty();
        }
    };
    private final ConnectionAccessor connectionAccessor;
    private final String sql;
    private final Function<Connection, Flux<Result>> resultFunction;
    private final Function<Connection, Mono<Integer>> updatedRowsFunction;
    private final FetchSpec<T> fetchSpec;

    DefaultSqlResult(ConnectionAccessor connectionAccessor, final String sql, final Function<Connection, Flux<Result>> resultFunction, final Function<Connection, Mono<Integer>> updatedRowsFunction, final BiFunction<Row, RowMetadata, T> mappingFunction) {
        this.sql = sql;
        this.connectionAccessor = connectionAccessor;
        this.resultFunction = resultFunction;
        this.updatedRowsFunction = updatedRowsFunction;
        this.fetchSpec = new DefaultFetchSpec(connectionAccessor, sql, new SqlFunction<Connection, Flux<T>>(){

            @Override
            public Flux<T> apply(Connection connection) {
                return ((Flux)resultFunction.apply(connection)).flatMap(result -> result.map(mappingFunction));
            }

            public String getSql() {
                return sql;
            }
        }, (Function<Connection, Mono<Integer>>)new SqlFunction<Connection, Mono<Integer>>(){

            @Override
            public Mono<Integer> apply(Connection connection) {
                return (Mono)updatedRowsFunction.apply(connection);
            }

            public String getSql() {
                return sql;
            }
        });
    }

    public static <R> SqlResult<R> empty() {
        return EMPTY;
    }

    @Override
    public <R> SqlResult<R> map(BiFunction<Row, RowMetadata, R> mappingFunction) {
        return new DefaultSqlResult<R>(this.connectionAccessor, this.sql, this.resultFunction, this.updatedRowsFunction, mappingFunction);
    }

    @Override
    public Mono<T> one() {
        return this.fetchSpec.one();
    }

    @Override
    public Mono<T> first() {
        return this.fetchSpec.first();
    }

    @Override
    public Flux<T> all() {
        return this.fetchSpec.all();
    }

    @Override
    public Mono<Integer> rowsUpdated() {
        return this.fetchSpec.rowsUpdated();
    }

    static interface SqlFunction<T, R>
    extends Function<T, R>,
    SqlProvider {
    }
}

