/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.function.connectionfactory;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.data.r2dbc.function.connectionfactory.TransactionResources;
import org.springframework.util.Assert;

class DefaultTransactionResources
implements TransactionResources {
    private Map<Class<?>, Object> items = new ConcurrentHashMap();

    DefaultTransactionResources() {
    }

    @Override
    public <T> void registerResource(Class<T> key, T value) {
        Assert.state((!this.items.containsKey(key) ? 1 : 0) != 0, () -> String.format("Resource for %s is already bound", key));
        this.items.put(key, value);
    }

    @Override
    public <T> T getResource(Class<T> key) {
        return (T)this.items.get(key);
    }
}

