/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.function.convert;

import io.r2dbc.spi.Row;
import io.r2dbc.spi.RowMetadata;
import java.util.function.BiFunction;
import lombok.NonNull;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.PreferredConstructor;
import org.springframework.data.mapping.model.ConvertingPropertyAccessor;
import org.springframework.data.mapping.model.ParameterValueProvider;
import org.springframework.data.relational.core.conversion.RelationalConverter;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.lang.Nullable;

public class EntityRowMapper<T>
implements BiFunction<Row, RowMetadata, T> {
    private final RelationalPersistentEntity<T> entity;
    private final RelationalConverter converter;

    public EntityRowMapper(RelationalPersistentEntity<T> entity, RelationalConverter converter) {
        this.entity = entity;
        this.converter = converter;
    }

    @Override
    public T apply(Row row, RowMetadata metadata) {
        T result = this.createInstance(row, "", this.entity);
        ConvertingPropertyAccessor propertyAccessor = new ConvertingPropertyAccessor(this.entity.getPropertyAccessor(result), this.converter.getConversionService());
        for (RelationalPersistentProperty property : this.entity) {
            if (this.entity.isConstructorArgument((PersistentProperty)property)) continue;
            if (property.isMap()) {
                throw new UnsupportedOperationException();
            }
            propertyAccessor.setProperty((PersistentProperty)property, this.readFrom(row, property, ""));
        }
        return result;
    }

    private Object readFrom(Row row, RelationalPersistentProperty property, String prefix) {
        try {
            if (property.isEntity()) {
                return this.readEntityFrom(row, (PersistentProperty<?>)property);
            }
            Object value = row.get((Object)(prefix + property.getColumnName()));
            return this.converter.readValue(value, property.getTypeInformation());
        }
        catch (Exception o_O) {
            throw new MappingException(String.format("Could not read property %s from result set!", property), (Throwable)o_O);
        }
    }

    private <S> S readEntityFrom(Row row, PersistentProperty<?> property) {
        String prefix = property.getName() + "_";
        RelationalPersistentEntity entity = (RelationalPersistentEntity)this.converter.getMappingContext().getRequiredPersistentEntity(property.getActualType());
        if (this.readFrom(row, (RelationalPersistentProperty)entity.getRequiredIdProperty(), prefix) == null) {
            return null;
        }
        S instance = this.createInstance(row, prefix, entity);
        PersistentPropertyAccessor accessor = entity.getPropertyAccessor(instance);
        ConvertingPropertyAccessor propertyAccessor = new ConvertingPropertyAccessor(accessor, this.converter.getConversionService());
        for (RelationalPersistentProperty p : entity) {
            if (entity.isConstructorArgument(property)) continue;
            propertyAccessor.setProperty((PersistentProperty)p, this.readFrom(row, p, prefix));
        }
        return instance;
    }

    private <S> S createInstance(Row row, String prefix, RelationalPersistentEntity<S> entity) {
        RowParameterValueProvider rowParameterValueProvider = new RowParameterValueProvider(row, entity, this.converter, prefix);
        return (S)this.converter.createInstance(entity, rowParameterValueProvider::getParameterValue);
    }

    private static class RowParameterValueProvider
    implements ParameterValueProvider<RelationalPersistentProperty> {
        @NonNull
        private final Row resultSet;
        @NonNull
        private final RelationalPersistentEntity<?> entity;
        @NonNull
        private final RelationalConverter converter;
        @NonNull
        private final String prefix;

        @Nullable
        public <T> T getParameterValue(PreferredConstructor.Parameter<T, RelationalPersistentProperty> parameter) {
            RelationalPersistentProperty property = (RelationalPersistentProperty)this.entity.getRequiredPersistentProperty(parameter.getName());
            String column = this.prefix + property.getColumnName();
            try {
                return (T)this.converter.getConversionService().convert(this.resultSet.get((Object)column), parameter.getType().getType());
            }
            catch (Exception o_O) {
                throw new MappingException(String.format("Couldn't read column %s from Row.", column), (Throwable)o_O);
            }
        }

        public RowParameterValueProvider(@NonNull Row resultSet, @NonNull RelationalPersistentEntity<?> entity, @NonNull RelationalConverter converter, @NonNull String prefix) {
            if (resultSet == null) {
                throw new IllegalArgumentException("resultSet is marked @NonNull but is null");
            }
            if (entity == null) {
                throw new IllegalArgumentException("entity is marked @NonNull but is null");
            }
            if (converter == null) {
                throw new IllegalArgumentException("converter is marked @NonNull but is null");
            }
            if (prefix == null) {
                throw new IllegalArgumentException("prefix is marked @NonNull but is null");
            }
            this.resultSet = resultSet;
            this.entity = entity;
            this.converter = converter;
            this.prefix = prefix;
        }
    }
}

