/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.function.convert;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.util.Assert;

class IterableUtils {
    IterableUtils() {
    }

    static <T> Collection<T> toCollection(Iterable<T> iterable) {
        Assert.notNull(iterable, (String)"Iterable must not be null!");
        if (iterable instanceof Collection) {
            return (Collection)iterable;
        }
        ArrayList<T> result = new ArrayList<T>();
        for (T element : iterable) {
            result.add(element);
        }
        return result;
    }

    static <T> List<T> toList(Iterable<T> iterable) {
        Assert.notNull(iterable, (String)"Iterable must not be null!");
        if (iterable instanceof List) {
            return (List)iterable;
        }
        ArrayList<T> result = new ArrayList<T>();
        for (T element : iterable) {
            result.add(element);
        }
        return result;
    }
}

