/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.repository.query;

import lombok.NonNull;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.convert.EntityInstantiators;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.r2dbc.function.FetchSpec;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.repository.query.DtoInstantiatingConverter;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.util.ClassUtils;

interface R2dbcQueryExecution {
    public Object execute(FetchSpec<?> var1, Class<?> var2, String var3);

    public static final class ResultProcessingConverter
    implements Converter<Object, Object> {
        @NonNull
        private final ResultProcessor processor;
        @NonNull
        private final MappingContext<? extends RelationalPersistentEntity<?>, ? extends RelationalPersistentProperty> mappingContext;
        @NonNull
        private final EntityInstantiators instantiators;

        public Object convert(Object source) {
            ReturnedType returnedType = this.processor.getReturnedType();
            if (ClassUtils.isPrimitiveOrWrapper((Class)returnedType.getReturnedType())) {
                return source;
            }
            DtoInstantiatingConverter converter = new DtoInstantiatingConverter(returnedType.getReturnedType(), this.mappingContext, this.instantiators);
            return this.processor.processResult(source, (Converter)converter);
        }

        public ResultProcessingConverter(@NonNull ResultProcessor processor, @NonNull MappingContext<? extends RelationalPersistentEntity<?>, ? extends RelationalPersistentProperty> mappingContext, @NonNull EntityInstantiators instantiators) {
            if (processor == null) {
                throw new IllegalArgumentException("processor is marked @NonNull but is null");
            }
            if (mappingContext == null) {
                throw new IllegalArgumentException("mappingContext is marked @NonNull but is null");
            }
            if (instantiators == null) {
                throw new IllegalArgumentException("instantiators is marked @NonNull but is null");
            }
            this.processor = processor;
            this.mappingContext = mappingContext;
            this.instantiators = instantiators;
        }
    }

    public static final class ResultProcessingExecution
    implements R2dbcQueryExecution {
        @NonNull
        private final R2dbcQueryExecution delegate;
        @NonNull
        private final Converter<Object, Object> converter;

        @Override
        public Object execute(FetchSpec<?> query, Class<?> type, String tableName) {
            return this.converter.convert(this.delegate.execute(query, type, tableName));
        }

        public ResultProcessingExecution(@NonNull R2dbcQueryExecution delegate, @NonNull Converter<Object, Object> converter) {
            if (delegate == null) {
                throw new IllegalArgumentException("delegate is marked @NonNull but is null");
            }
            if (converter == null) {
                throw new IllegalArgumentException("converter is marked @NonNull but is null");
            }
            this.delegate = delegate;
            this.converter = converter;
        }
    }
}

