/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.core;

import org.jspecify.annotations.Nullable;
import org.springframework.data.r2dbc.core.R2dbcEntityTemplate;
import org.springframework.data.r2dbc.core.ReactiveSelectOperation;
import org.springframework.data.relational.core.query.Query;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.r2dbc.core.RowsFetchSpec;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

record ReactiveSelectOperationSupport(R2dbcEntityTemplate template) implements ReactiveSelectOperation
{
    @Override
    public <T> ReactiveSelectOperation.ReactiveSelect<T> select(Class<T> domainType) {
        Assert.notNull(domainType, (String)"DomainType must not be null");
        return new ReactiveSelectSupport<T>(this.template, domainType, domainType, Query.empty(), null, null);
    }

    static class ReactiveSelectSupport<T>
    implements ReactiveSelectOperation.ReactiveSelect<T> {
        private final R2dbcEntityTemplate template;
        private final Class<?> domainType;
        private final Class<T> returnType;
        private final Query query;
        private final @Nullable SqlIdentifier tableName;
        private final @Nullable Integer fetchSize;

        ReactiveSelectSupport(R2dbcEntityTemplate template, Class<?> domainType, Class<T> returnType, Query query, @Nullable SqlIdentifier tableName, @Nullable Integer fetchSize) {
            this.template = template;
            this.domainType = domainType;
            this.returnType = returnType;
            this.query = query;
            this.tableName = tableName;
            this.fetchSize = fetchSize;
        }

        @Override
        public ReactiveSelectOperation.SelectWithProjection<T> from(SqlIdentifier tableName) {
            Assert.notNull((Object)tableName, (String)"Table name must not be null");
            return new ReactiveSelectSupport<T>(this.template, this.domainType, this.returnType, this.query, tableName, this.fetchSize);
        }

        @Override
        public <R> ReactiveSelectOperation.SelectWithQuery<R> as(Class<R> returnType) {
            Assert.notNull(returnType, (String)"ReturnType must not be null");
            return new ReactiveSelectSupport<R>(this.template, this.domainType, returnType, this.query, this.tableName, this.fetchSize);
        }

        @Override
        public ReactiveSelectOperation.SelectWithQuery<T> withFetchSize(int fetchSize) {
            return new ReactiveSelectSupport<T>(this.template, this.domainType, this.returnType, this.query, this.tableName, fetchSize);
        }

        @Override
        public ReactiveSelectOperation.TerminatingSelect<T> matching(Query query) {
            Assert.notNull((Object)query, (String)"Query must not be null");
            return new ReactiveSelectSupport<T>(this.template, this.domainType, this.returnType, query, this.tableName, this.fetchSize);
        }

        @Override
        public Mono<Long> count() {
            return this.template.doCount(this.query, this.domainType, this.getTableName());
        }

        @Override
        public Mono<Boolean> exists() {
            return this.template.doExists(this.query, this.domainType, this.getTableName());
        }

        @Override
        public Mono<T> first() {
            return this.template.doSelect(this.query.limit(1), this.domainType, this.getTableName(), this.returnType, RowsFetchSpec::first, this.fetchSize);
        }

        @Override
        public Mono<T> one() {
            return this.template.doSelect(this.query.limit(2), this.domainType, this.getTableName(), this.returnType, RowsFetchSpec::one, this.fetchSize);
        }

        @Override
        public Flux<T> all() {
            return this.template.doSelect(this.query, this.domainType, this.getTableName(), this.returnType, RowsFetchSpec::all, this.fetchSize);
        }

        private SqlIdentifier getTableName() {
            return this.tableName != null ? this.tableName : this.template.getTableName(this.domainType);
        }
    }
}

