/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.aot;

import java.util.Arrays;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.aot.hint.TypeReference;
import org.springframework.data.r2dbc.dialect.PostgresDialect;
import org.springframework.data.r2dbc.mapping.event.AfterConvertCallback;
import org.springframework.data.r2dbc.mapping.event.AfterSaveCallback;
import org.springframework.data.r2dbc.mapping.event.BeforeConvertCallback;
import org.springframework.data.r2dbc.mapping.event.BeforeSaveCallback;
import org.springframework.data.r2dbc.repository.support.SimpleR2dbcRepository;

class R2dbcRuntimeHints
implements RuntimeHintsRegistrar {
    R2dbcRuntimeHints() {
    }

    public void registerHints(RuntimeHints hints, ClassLoader classLoader) {
        hints.reflection().registerTypes(Arrays.asList(TypeReference.of(SimpleR2dbcRepository.class), TypeReference.of(AfterConvertCallback.class), TypeReference.of(BeforeConvertCallback.class), TypeReference.of(BeforeSaveCallback.class), TypeReference.of(AfterSaveCallback.class)), hint -> hint.withMembers(new MemberCategory[]{MemberCategory.INVOKE_DECLARED_CONSTRUCTORS, MemberCategory.INVOKE_PUBLIC_METHODS}));
        for (Class simpleType : PostgresDialect.INSTANCE.simpleTypes()) {
            hints.reflection().registerType(TypeReference.of((Class)simpleType), new MemberCategory[]{MemberCategory.PUBLIC_CLASSES});
        }
    }
}

