/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.SortParameters;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.data.redis.core.BoundListOperations;
import org.springframework.data.redis.core.BoundSetOperations;
import org.springframework.data.redis.core.BoundValueOperations;
import org.springframework.data.redis.core.BoundZSetOperations;
import org.springframework.data.redis.core.BulkMapper;
import org.springframework.data.redis.core.CloseSuppressingInvocationHandler;
import org.springframework.data.redis.core.DefaultBoundHashOperations;
import org.springframework.data.redis.core.DefaultBoundListOperations;
import org.springframework.data.redis.core.DefaultBoundSetOperations;
import org.springframework.data.redis.core.DefaultBoundValueOperations;
import org.springframework.data.redis.core.DefaultBoundZSetOperations;
import org.springframework.data.redis.core.DefaultHashOperations;
import org.springframework.data.redis.core.DefaultListOperations;
import org.springframework.data.redis.core.DefaultSetOperations;
import org.springframework.data.redis.core.DefaultValueOperations;
import org.springframework.data.redis.core.DefaultZSetOperations;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.ListOperations;
import org.springframework.data.redis.core.RedisAccessor;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.RedisConnectionUtils;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.SessionCallback;
import org.springframework.data.redis.core.SetOperations;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.data.redis.core.query.QueryUtils;
import org.springframework.data.redis.core.query.SortQuery;
import org.springframework.data.redis.serializer.JdkSerializationRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.SerializationUtils;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RedisTemplate<K, V>
extends RedisAccessor
implements RedisOperations<K, V> {
    private boolean exposeConnection = false;
    private RedisSerializer<?> defaultSerializer = new JdkSerializationRedisSerializer();
    private RedisSerializer keySerializer = null;
    private RedisSerializer valueSerializer = null;
    private RedisSerializer hashKeySerializer = null;
    private RedisSerializer hashValueSerializer = null;
    private RedisSerializer<String> stringSerializer = new StringRedisSerializer();
    private ValueOperations<K, V> valueOps;
    private ListOperations<K, V> listOps;
    private SetOperations<K, V> setOps;
    private ZSetOperations<K, V> zSetOps;

    @Override
    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        boolean defaultUsed = false;
        if (this.keySerializer == null) {
            this.keySerializer = this.defaultSerializer;
            defaultUsed = true;
        }
        if (this.valueSerializer == null) {
            this.valueSerializer = this.defaultSerializer;
            defaultUsed = true;
        }
        if (this.hashKeySerializer == null) {
            this.hashKeySerializer = this.defaultSerializer;
            defaultUsed = true;
        }
        if (this.hashValueSerializer == null) {
            this.hashValueSerializer = this.defaultSerializer;
            defaultUsed = true;
        }
        if (defaultUsed) {
            Assert.notNull(this.defaultSerializer, (String)"default serializer null and not all serializers initialized");
        }
    }

    @Override
    public <T> T execute(RedisCallback<T> action) {
        return this.execute(action, this.isExposeConnection());
    }

    public <T> T execute(RedisCallback<T> action, boolean exposeConnection) {
        return this.execute(action, exposeConnection, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T execute(RedisCallback<T> action, boolean exposeConnection, boolean pipeline) {
        Assert.notNull(action, (String)"Callback object must not be null");
        RedisConnectionFactory factory = this.getConnectionFactory();
        RedisConnection conn = RedisConnectionUtils.getConnection(factory);
        boolean existingConnection = TransactionSynchronizationManager.hasResource((Object)factory);
        this.preProcessConnection(conn, existingConnection);
        boolean pipelineStatus = conn.isPipelined();
        if (pipeline && !pipelineStatus) {
            conn.openPipeline();
        }
        try {
            RedisConnection connToExpose = exposeConnection ? conn : this.createRedisConnectionProxy(conn);
            T result = action.doInRedis(connToExpose);
            T t = this.postProcessResult(result, conn, existingConnection);
            return t;
        }
        finally {
            try {
                if (pipeline && !pipelineStatus) {
                    conn.closePipeline();
                }
            }
            finally {
                RedisConnectionUtils.releaseConnection(conn, factory);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T execute(SessionCallback<T> session) {
        RedisConnectionFactory factory = this.getConnectionFactory();
        RedisConnectionUtils.bindConnection(factory);
        try {
            T t = session.execute(this);
            return t;
        }
        finally {
            RedisConnectionUtils.unbindConnection(factory);
        }
    }

    protected RedisConnection createRedisConnectionProxy(RedisConnection pm) {
        Class[] ifcs = ClassUtils.getAllInterfacesForClass(pm.getClass(), (ClassLoader)this.getClass().getClassLoader());
        return (RedisConnection)Proxy.newProxyInstance(pm.getClass().getClassLoader(), ifcs, (InvocationHandler)new CloseSuppressingInvocationHandler(pm));
    }

    protected RedisConnection preProcessConnection(RedisConnection connection, boolean existingConnection) {
        return connection;
    }

    protected <T> T postProcessResult(T result, RedisConnection conn, boolean existingConnection) {
        return result;
    }

    public boolean isExposeConnection() {
        return this.exposeConnection;
    }

    public void setExposeConnection(boolean exposeConnection) {
        this.exposeConnection = exposeConnection;
    }

    public RedisSerializer<?> getDefaultSerializer() {
        return this.defaultSerializer;
    }

    public void setDefaultSerializer(RedisSerializer<?> serializer) {
        this.defaultSerializer = serializer;
    }

    public void setKeySerializer(RedisSerializer<?> serializer) {
        this.keySerializer = serializer;
    }

    @Override
    public RedisSerializer<?> getKeySerializer() {
        return this.keySerializer;
    }

    public void setValueSerializer(RedisSerializer<?> serializer) {
        this.valueSerializer = serializer;
    }

    @Override
    public RedisSerializer<?> getValueSerializer() {
        return this.valueSerializer;
    }

    public RedisSerializer<?> getHashKeySerializer() {
        return this.hashKeySerializer;
    }

    public void setHashKeySerializer(RedisSerializer<?> hashKeySerializer) {
        this.hashKeySerializer = hashKeySerializer;
    }

    public RedisSerializer<?> getHashValueSerializer() {
        return this.hashValueSerializer;
    }

    public void setHashValueSerializer(RedisSerializer<?> hashValueSerializer) {
        this.hashValueSerializer = hashValueSerializer;
    }

    public RedisSerializer<String> getStringSerializer() {
        return this.stringSerializer;
    }

    public void setStringSerializer(RedisSerializer<String> stringSerializer) {
        this.stringSerializer = stringSerializer;
    }

    private byte[] rawKey(Object key) {
        Assert.notNull((Object)key, (String)"non null key required");
        return this.keySerializer.serialize(key);
    }

    private byte[] rawString(String key) {
        return this.stringSerializer.serialize(key);
    }

    private byte[] rawValue(Object value) {
        return this.valueSerializer.serialize(value);
    }

    private byte[][] rawKeys(Collection<K> keys) {
        byte[][] rawKeys = new byte[keys.size()][];
        int i = 0;
        for (K key : keys) {
            rawKeys[i++] = this.rawKey(key);
        }
        return rawKeys;
    }

    private K deserializeKey(byte[] value) {
        return (K)this.keySerializer.deserialize(value);
    }

    @Override
    public List<Object> exec() {
        return this.execute(new RedisCallback<List<Object>>(){

            @Override
            public List<Object> doInRedis(RedisConnection connection) throws DataAccessException {
                return connection.exec();
            }
        });
    }

    @Override
    public void delete(K key) {
        final byte[] rawKey = this.rawKey(key);
        this.execute(new RedisCallback<Object>(){

            @Override
            public Object doInRedis(RedisConnection connection) {
                connection.del(new byte[][]{rawKey});
                return null;
            }
        }, true);
    }

    @Override
    public void delete(Collection<K> keys) {
        final byte[][] rawKeys = this.rawKeys(keys);
        this.execute(new RedisCallback<Object>(){

            @Override
            public Object doInRedis(RedisConnection connection) {
                connection.del(rawKeys);
                return null;
            }
        }, true);
    }

    @Override
    public Boolean hasKey(K key) {
        final byte[] rawKey = this.rawKey(key);
        return this.execute(new RedisCallback<Boolean>(){

            @Override
            public Boolean doInRedis(RedisConnection connection) {
                return connection.exists(rawKey);
            }
        }, true);
    }

    @Override
    public Boolean expire(K key, long timeout, TimeUnit unit) {
        final byte[] rawKey = this.rawKey(key);
        final int rawTimeout = (int)unit.toSeconds(timeout);
        return this.execute(new RedisCallback<Boolean>(){

            @Override
            public Boolean doInRedis(RedisConnection connection) {
                return connection.expire(rawKey, rawTimeout);
            }
        }, true);
    }

    @Override
    public Boolean expireAt(K key, Date date) {
        final byte[] rawKey = this.rawKey(key);
        final long rawTimeout = date.getTime();
        return this.execute(new RedisCallback<Boolean>(){

            @Override
            public Boolean doInRedis(RedisConnection connection) {
                return connection.expireAt(rawKey, rawTimeout);
            }
        }, true);
    }

    @Override
    public void convertAndSend(String channel, Object message) {
        Assert.hasText((String)channel, (String)"a non-empty channel is required");
        final byte[] rawChannel = this.rawString(channel);
        final byte[] rawMessage = this.rawValue(message);
        this.execute(new RedisCallback<Object>(){

            @Override
            public Object doInRedis(RedisConnection connection) {
                connection.publish(rawChannel, rawMessage);
                return null;
            }
        }, true);
    }

    @Override
    public Long getExpire(K key) {
        final byte[] rawKey = this.rawKey(key);
        return this.execute(new RedisCallback<Long>(){

            @Override
            public Long doInRedis(RedisConnection connection) {
                return (long)connection.ttl(rawKey);
            }
        }, true);
    }

    @Override
    public Set<K> keys(K pattern) {
        final byte[] rawKey = this.rawKey(pattern);
        Set<byte[]> rawKeys = this.execute(new RedisCallback<Set<byte[]>>(){

            @Override
            public Set<byte[]> doInRedis(RedisConnection connection) {
                return connection.keys(rawKey);
            }
        }, true);
        return SerializationUtils.deserialize(rawKeys, this.keySerializer);
    }

    @Override
    public Boolean persist(K key) {
        final byte[] rawKey = this.rawKey(key);
        return this.execute(new RedisCallback<Boolean>(){

            @Override
            public Boolean doInRedis(RedisConnection connection) {
                return connection.persist(rawKey);
            }
        }, true);
    }

    @Override
    public Boolean move(K key, final int dbIndex) {
        final byte[] rawKey = this.rawKey(key);
        return this.execute(new RedisCallback<Boolean>(){

            @Override
            public Boolean doInRedis(RedisConnection connection) {
                return connection.move(rawKey, dbIndex);
            }
        }, true);
    }

    @Override
    public K randomKey() {
        byte[] rawKey = this.execute(new RedisCallback<byte[]>(){

            @Override
            public byte[] doInRedis(RedisConnection connection) {
                return connection.randomKey();
            }
        }, true);
        return this.deserializeKey(rawKey);
    }

    @Override
    public void rename(K oldKey, K newKey) {
        final byte[] rawOldKey = this.rawKey(oldKey);
        final byte[] rawNewKey = this.rawKey(newKey);
        this.execute(new RedisCallback<Object>(){

            @Override
            public Object doInRedis(RedisConnection connection) {
                connection.rename(rawOldKey, rawNewKey);
                return null;
            }
        }, true);
    }

    @Override
    public Boolean renameIfAbsent(K oldKey, K newKey) {
        final byte[] rawOldKey = this.rawKey(oldKey);
        final byte[] rawNewKey = this.rawKey(newKey);
        return this.execute(new RedisCallback<Boolean>(){

            @Override
            public Boolean doInRedis(RedisConnection connection) {
                return connection.renameNX(rawOldKey, rawNewKey);
            }
        }, true);
    }

    @Override
    public DataType type(K key) {
        final byte[] rawKey = this.rawKey(key);
        return this.execute(new RedisCallback<DataType>(){

            @Override
            public DataType doInRedis(RedisConnection connection) {
                return connection.type(rawKey);
            }
        }, true);
    }

    @Override
    public void multi() {
        this.execute(new RedisCallback<Object>(){

            @Override
            public Object doInRedis(RedisConnection connection) throws DataAccessException {
                connection.multi();
                return null;
            }
        }, true);
    }

    @Override
    public void discard() {
        this.execute(new RedisCallback<Object>(){

            @Override
            public Object doInRedis(RedisConnection connection) throws DataAccessException {
                connection.discard();
                return null;
            }
        }, true);
    }

    @Override
    public void watch(K key) {
        final byte[] rawKey = this.rawKey(key);
        this.execute(new RedisCallback<Object>(){

            @Override
            public Object doInRedis(RedisConnection connection) {
                connection.watch(new byte[][]{rawKey});
                return null;
            }
        }, true);
    }

    @Override
    public void watch(Collection<K> keys) {
        final byte[][] rawKeys = this.rawKeys(keys);
        this.execute(new RedisCallback<Object>(){

            @Override
            public Object doInRedis(RedisConnection connection) {
                connection.watch(rawKeys);
                return null;
            }
        }, true);
    }

    @Override
    public void unwatch() {
        this.execute(new RedisCallback<Object>(){

            @Override
            public Object doInRedis(RedisConnection connection) throws DataAccessException {
                connection.unwatch();
                return null;
            }
        }, true);
    }

    @Override
    public List<V> sort(SortQuery<K> query) {
        return this.sort(query, this.valueSerializer);
    }

    @Override
    public <T> List<T> sort(SortQuery<K> query, RedisSerializer<T> resultSerializer) {
        final byte[] rawKey = this.rawKey(query.getKey());
        final SortParameters params = QueryUtils.convertQuery(query, this.stringSerializer);
        List<byte[]> vals = this.execute(new RedisCallback<List<byte[]>>(){

            @Override
            public List<byte[]> doInRedis(RedisConnection connection) throws DataAccessException {
                return connection.sort(rawKey, params);
            }
        }, true);
        return SerializationUtils.deserialize(vals, resultSerializer);
    }

    @Override
    public <T> List<T> sort(SortQuery<K> query, BulkMapper<T, V> bulkMapper) {
        return this.sort(query, bulkMapper, this.valueSerializer);
    }

    @Override
    public <T, S> List<T> sort(SortQuery<K> query, BulkMapper<T, S> bulkMapper, RedisSerializer<S> resultSerializer) {
        List<S> values = this.sort(query, resultSerializer);
        if (values == null || values.isEmpty()) {
            return Collections.emptyList();
        }
        int bulkSize = query.getGetPattern().size();
        ArrayList<T> result = new ArrayList<T>(values.size() / bulkSize + 1);
        ArrayList<S> bulk = new ArrayList<S>(bulkSize);
        for (S s : values) {
            bulk.add(s);
            if (bulk.size() != bulkSize) continue;
            result.add(bulkMapper.mapBulk(Collections.unmodifiableList(bulk)));
            bulk = new ArrayList(bulkSize);
        }
        return result;
    }

    @Override
    public Long sort(SortQuery<K> query, K storeKey) {
        final byte[] rawStoreKey = this.rawKey(storeKey);
        final byte[] rawKey = this.rawKey(query.getKey());
        final SortParameters params = QueryUtils.convertQuery(query, this.stringSerializer);
        return this.execute(new RedisCallback<Long>(){

            @Override
            public Long doInRedis(RedisConnection connection) throws DataAccessException {
                return connection.sort(rawKey, params, rawStoreKey);
            }
        }, true);
    }

    @Override
    public BoundValueOperations<K, V> boundValueOps(K key) {
        return new DefaultBoundValueOperations(key, this);
    }

    @Override
    public ValueOperations<K, V> opsForValue() {
        if (this.valueOps == null) {
            this.valueOps = new DefaultValueOperations(this);
        }
        return this.valueOps;
    }

    @Override
    public ListOperations<K, V> opsForList() {
        if (this.listOps == null) {
            this.listOps = new DefaultListOperations(this);
        }
        return this.listOps;
    }

    @Override
    public BoundListOperations<K, V> boundListOps(K key) {
        return new DefaultBoundListOperations(key, this);
    }

    @Override
    public BoundSetOperations<K, V> boundSetOps(K key) {
        return new DefaultBoundSetOperations(key, this);
    }

    @Override
    public SetOperations<K, V> opsForSet() {
        if (this.setOps == null) {
            this.setOps = new DefaultSetOperations(this);
        }
        return this.setOps;
    }

    @Override
    public BoundZSetOperations<K, V> boundZSetOps(K key) {
        return new DefaultBoundZSetOperations(key, this);
    }

    @Override
    public ZSetOperations<K, V> opsForZSet() {
        if (this.zSetOps == null) {
            this.zSetOps = new DefaultZSetOperations(this);
        }
        return this.zSetOps;
    }

    @Override
    public <HK, HV> BoundHashOperations<K, HK, HV> boundHashOps(K key) {
        return new DefaultBoundHashOperations(key, this);
    }

    @Override
    public <HK, HV> HashOperations<K, HK, HV> opsForHash() {
        return new DefaultHashOperations(this);
    }
}

