/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.srp;

import com.google.common.base.Charsets;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Future;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.RedisConnectionFailureException;
import org.springframework.data.redis.RedisSystemException;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisListCommands;
import org.springframework.data.redis.connection.RedisPipelineException;
import org.springframework.data.redis.connection.RedisSubscribedConnectionException;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.connection.SortParameters;
import org.springframework.data.redis.connection.Subscription;
import org.springframework.data.redis.connection.srp.SrpSubscription;
import org.springframework.data.redis.connection.srp.SrpUtils;
import org.springframework.util.Assert;
import redis.Command;
import redis.client.RedisClient;
import redis.client.RedisException;
import redis.reply.Reply;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SrpConnection
implements RedisConnection {
    private static final Object[] EMPTY_PARAMS_ARRAY = new Object[0];
    private final RedisClient client;
    private final BlockingQueue<SrpConnection> queue;
    private boolean isClosed = false;
    private boolean isMulti = false;
    private boolean pipelineRequested = false;
    private RedisClient.Pipeline pipeline;
    private PipelineTracker callback;
    private volatile SrpSubscription subscription;

    public SrpConnection(String host, int port, BlockingQueue<SrpConnection> queue) {
        try {
            this.client = new RedisClient(host, port);
            this.queue = queue;
        }
        catch (IOException e) {
            throw new RedisConnectionFailureException("Could not connect", e);
        }
    }

    protected DataAccessException convertSrpAccessException(Exception ex) {
        if (ex instanceof RedisException) {
            return SrpUtils.convertSRedisAccessException((RuntimeException)((RedisException)ex));
        }
        if (ex instanceof IOException) {
            return new RedisConnectionFailureException("Redis connection failed", (IOException)ex);
        }
        return new RedisSystemException("Unknown SRP exception", ex);
    }

    @Override
    public Object execute(String command, byte[] ... args) {
        Assert.hasText((String)command, (String)"a valid command needs to be specified");
        try {
            String name = command.trim().toUpperCase();
            Command cmd = new Command((Object)name.getBytes(Charsets.UTF_8), (Object[])args);
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.client.pipeline(name, cmd));
                return null;
            }
            return this.client.execute(name, cmd);
        }
        catch (RedisException ex) {
            throw this.convertSrpAccessException((Exception)((Object)ex));
        }
    }

    @Override
    public void close() throws DataAccessException {
        this.isClosed = true;
        this.queue.remove(this);
        if (this.subscription != null) {
            if (this.subscription.isAlive()) {
                this.subscription.doClose();
            }
            this.subscription = null;
        }
        try {
            this.client.close();
        }
        catch (IOException ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    public RedisClient getNativeConnection() {
        return this.client;
    }

    @Override
    public boolean isQueueing() {
        return this.isMulti;
    }

    @Override
    public boolean isPipelined() {
        return this.pipeline != null;
    }

    @Override
    public void openPipeline() {
        this.pipelineRequested = true;
        this.initPipeline();
    }

    @Override
    public List<Object> closePipeline() {
        return this.closePipeline(true);
    }

    @Override
    public List<byte[]> sort(byte[] key, SortParameters params) {
        Object[] sort = SrpUtils.sortParams(params);
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.sort((Object)key, sort));
                return null;
            }
            return SrpUtils.toBytesList((Reply[])this.client.sort((Object)key, sort).data());
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Long sort(byte[] key, SortParameters params, byte[] sortKey) {
        Object[] sort = SrpUtils.sortParams(params, sortKey);
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.sort((Object)key, sort));
                return null;
            }
            return (Long)this.client.sort((Object)key, sort).data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Long dbSize() {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.dbsize());
                return null;
            }
            return this.client.dbsize().data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public void flushDb() {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.flushdb());
                return;
            }
            this.client.flushdb();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public void flushAll() {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.flushall());
                return;
            }
            this.client.flushall();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public void bgSave() {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.bgsave());
                return;
            }
            this.client.bgsave();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public void bgWriteAof() {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.bgrewriteaof());
                return;
            }
            this.client.bgrewriteaof();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public void save() {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.save());
                return;
            }
            this.client.save();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public List<String> getConfig(String param) {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.config_get((Object)param));
                return null;
            }
            return Collections.singletonList(this.client.config_get((Object)param).toString());
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Properties info() {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.info(null));
                return null;
            }
            return SrpUtils.info(this.client.info(null));
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Long lastSave() {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.lastsave());
                return null;
            }
            return this.client.lastsave().data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public void setConfig(String param, String value) {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.config_set((Object)param, (Object)value));
                return;
            }
            this.client.config_set((Object)param, (Object)value);
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public void resetConfigStats() {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.config_resetstat());
                return;
            }
            this.client.config_resetstat();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public void shutdown() {
        byte[] save = "SAVE".getBytes(Charsets.UTF_8);
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.shutdown((Object)save, null));
                return;
            }
            this.client.shutdown((Object)save, null);
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public byte[] echo(byte[] message) {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.echo((Object)message));
                return null;
            }
            return this.client.echo((Object)message).data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public String ping() {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.ping());
                return null;
            }
            return this.client.ping().data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Long del(byte[] ... keys) {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.del((Object[])keys));
                return null;
            }
            return this.client.del((Object[])keys).data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public void discard() {
        this.isMulti = false;
        try {
            this.client.discard();
            if (!this.pipelineRequested) {
                this.closePipeline(false);
            }
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public List<Object> exec() {
        this.isMulti = false;
        try {
            Future exec = this.client.exec();
            exec.get();
            if (this.pipelineRequested) {
                return null;
            }
            return this.closePipeline();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Boolean exists(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.exists((Object)key));
                return null;
            }
            return this.client.exists((Object)key).data() == 1L;
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Boolean expire(byte[] key, long seconds) {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.expire((Object)key, (Object)seconds));
                return null;
            }
            return this.client.expire((Object)key, (Object)seconds).data() == 1L;
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Boolean expireAt(byte[] key, long unixTime) {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.expireat((Object)key, (Object)unixTime));
                return null;
            }
            return this.client.expireat((Object)key, (Object)unixTime).data() == 1L;
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> keys(byte[] pattern) {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.keys((Object)pattern));
                return null;
            }
            return SrpUtils.toSet(this.client.keys((Object)pattern).data());
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public void multi() {
        if (this.isQueueing()) {
            return;
        }
        this.isMulti = true;
        this.initPipeline();
        try {
            this.client.multi();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Boolean persist(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.persist((Object)key));
                return null;
            }
            return this.client.persist((Object)key).data() == 1L;
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Boolean move(byte[] key, int dbIndex) {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.move((Object)key, (Object)dbIndex));
                return null;
            }
            return this.client.move((Object)key, (Object)dbIndex).data() == 1L;
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public byte[] randomKey() {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.randomkey());
                return null;
            }
            return this.client.randomkey().data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public void rename(byte[] oldName, byte[] newName) {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.rename((Object)oldName, (Object)newName));
                return;
            }
            this.client.rename((Object)oldName, (Object)newName);
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Boolean renameNX(byte[] oldName, byte[] newName) {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.renamenx((Object)oldName, (Object)newName));
                return null;
            }
            return this.client.renamenx((Object)oldName, (Object)newName).data() == 1L;
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public void select(int dbIndex) {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.select((Object)dbIndex));
            }
            this.client.select((Object)dbIndex);
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Long ttl(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.ttl((Object)key));
                return null;
            }
            return this.client.ttl((Object)key).data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public DataType type(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.type((Object)key));
                return null;
            }
            return DataType.fromCode(this.client.type((Object)key).data());
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public void unwatch() {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.unwatch());
                return;
            }
            this.client.unwatch();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public void watch(byte[] ... keys) {
        if (this.isQueueing()) {
            throw new UnsupportedOperationException();
        }
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.watch((Object[])keys));
                return;
            }
            this.client.watch((Object[])keys);
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public byte[] get(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.get((Object)key));
                return null;
            }
            return this.client.get((Object)key).data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public void set(byte[] key, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.set((Object)key, (Object)value));
                return;
            }
            this.client.set((Object)key, (Object)value);
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public byte[] getSet(byte[] key, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.getset((Object)key, (Object)value));
                return null;
            }
            return this.client.getset((Object)key, (Object)value).data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Long append(byte[] key, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.append((Object)key, (Object)value));
                return null;
            }
            return this.client.append((Object)key, (Object)value).data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public List<byte[]> mGet(byte[] ... keys) {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.mget((Object[])keys));
                return null;
            }
            return SrpUtils.toBytesList(this.client.mget((Object[])keys).data());
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public void mSet(Map<byte[], byte[]> tuples) {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.mset((Object[])SrpUtils.convert(tuples)));
                return;
            }
            this.client.mset((Object[])SrpUtils.convert(tuples));
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public void mSetNX(Map<byte[], byte[]> tuples) {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.msetnx((Object[])SrpUtils.convert(tuples)));
                return;
            }
            this.client.msetnx((Object[])SrpUtils.convert(tuples));
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public void setEx(byte[] key, long time, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.setex((Object)key, (Object)time, (Object)value));
                return;
            }
            this.client.setex((Object)key, (Object)time, (Object)value);
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Boolean setNX(byte[] key, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.setnx((Object)key, (Object)value));
                return null;
            }
            return this.client.setnx((Object)key, (Object)value).data() == 1L;
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public byte[] getRange(byte[] key, long start, long end) {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.getrange((Object)key, (Object)start, (Object)end));
                return null;
            }
            return this.client.getrange((Object)key, (Object)start, (Object)end).data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Long decr(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.decr((Object)key));
                return null;
            }
            return this.client.decr((Object)key).data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Long decrBy(byte[] key, long value) {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.decrby((Object)key, (Object)value));
                return null;
            }
            return this.client.decrby((Object)key, (Object)value).data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Long incr(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.incr((Object)key));
                return null;
            }
            return this.client.incr((Object)key).data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Long incrBy(byte[] key, long value) {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.incrby((Object)key, (Object)value));
                return null;
            }
            return this.client.incrby((Object)key, (Object)value).data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Boolean getBit(byte[] key, long offset) {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.getbit((Object)key, (Object)offset));
                return null;
            }
            return this.client.getbit((Object)key, (Object)offset).data() == 1L;
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public void setBit(byte[] key, long offset, boolean value) {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.setbit((Object)key, (Object)offset, (Object)SrpUtils.asBit(value)));
                return;
            }
            this.client.setbit((Object)key, (Object)offset, (Object)SrpUtils.asBit(value));
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public void setRange(byte[] key, byte[] value, long start) {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.setrange((Object)key, (Object)start, (Object)value));
                return;
            }
            this.client.setrange((Object)key, (Object)start, (Object)value);
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Long strLen(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.strlen((Object)key));
                return null;
            }
            return this.client.strlen((Object)key).data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Long lPush(byte[] key, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.lpush((Object)key, new Object[]{value}));
                return null;
            }
            return this.client.lpush((Object)key, new Object[]{value}).data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Long rPush(byte[] key, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.rpush((Object)key, new Object[]{value}));
                return null;
            }
            return this.client.rpush((Object)key, new Object[]{value}).data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public List<byte[]> bLPop(int timeout, byte[] ... keys) {
        Object[] args = SrpUtils.convert(timeout, keys);
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.blpop(args));
                return null;
            }
            return SrpUtils.toBytesList(this.client.blpop(args).data());
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public List<byte[]> bRPop(int timeout, byte[] ... keys) {
        Object[] args = SrpUtils.convert(timeout, keys);
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.brpop(args));
                return null;
            }
            return SrpUtils.toBytesList(this.client.brpop(args).data());
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public byte[] lIndex(byte[] key, long index) {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.lindex((Object)key, (Object)index));
                return null;
            }
            return this.client.lindex((Object)key, (Object)index).data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Long lInsert(byte[] key, RedisListCommands.Position where, byte[] pivot, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.linsert((Object)key, (Object)SrpUtils.convertPosition(where), (Object)pivot, (Object)value));
                return null;
            }
            return this.client.linsert((Object)key, (Object)SrpUtils.convertPosition(where), (Object)pivot, (Object)value).data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Long lLen(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.llen((Object)key));
                return null;
            }
            return this.client.llen((Object)key).data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public byte[] lPop(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.lpop((Object)key));
                return null;
            }
            return this.client.lpop((Object)key).data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public List<byte[]> lRange(byte[] key, long start, long end) {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.lrange((Object)key, (Object)start, (Object)end));
                return null;
            }
            return SrpUtils.toBytesList(this.client.lrange((Object)key, (Object)start, (Object)end).data());
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Long lRem(byte[] key, long count, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.lrem((Object)key, (Object)count, (Object)value));
                return null;
            }
            return this.client.lrem((Object)key, (Object)count, (Object)value).data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public void lSet(byte[] key, long index, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.lset((Object)key, (Object)index, (Object)value));
                return;
            }
            this.client.lset((Object)key, (Object)index, (Object)value);
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public void lTrim(byte[] key, long start, long end) {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.ltrim((Object)key, (Object)start, (Object)end));
                return;
            }
            this.client.ltrim((Object)key, (Object)start, (Object)end);
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public byte[] rPop(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.rpop((Object)key));
                return null;
            }
            return this.client.rpop((Object)key).data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public byte[] rPopLPush(byte[] srcKey, byte[] dstKey) {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.rpoplpush((Object)srcKey, (Object)dstKey));
                return null;
            }
            return this.client.rpoplpush((Object)srcKey, (Object)dstKey).data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public byte[] bRPopLPush(int timeout, byte[] srcKey, byte[] dstKey) {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.brpoplpush((Object)srcKey, (Object)dstKey, (Object)timeout));
                return null;
            }
            return this.client.brpoplpush((Object)srcKey, (Object)dstKey, (Object)timeout).data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Long lPushX(byte[] key, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.lpushx((Object)key, (Object)value));
                return null;
            }
            return this.client.lpushx((Object)key, (Object)value).data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Long rPushX(byte[] key, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.rpushx((Object)key, (Object)value));
                return null;
            }
            return this.client.rpushx((Object)key, (Object)value).data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Boolean sAdd(byte[] key, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.sadd((Object)key, new Object[]{value}));
                return null;
            }
            return this.client.sadd((Object)key, new Object[]{value}).data() == 1L;
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Long sCard(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.scard((Object)key));
                return null;
            }
            return this.client.scard((Object)key).data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> sDiff(byte[] ... keys) {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.sdiff((Object[])keys));
                return null;
            }
            return SrpUtils.toSet(this.client.sdiff((Object[])keys).data());
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Long sDiffStore(byte[] destKey, byte[] ... keys) {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.sdiffstore((Object)destKey, (Object[])keys));
                return null;
            }
            return this.client.sdiffstore((Object)destKey, (Object[])keys).data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> sInter(byte[] ... keys) {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.sinter((Object[])keys));
                return null;
            }
            return SrpUtils.toSet(this.client.sinter((Object[])keys).data());
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Long sInterStore(byte[] destKey, byte[] ... keys) {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.sinterstore((Object)destKey, (Object[])keys));
                return null;
            }
            return this.client.sinterstore((Object)destKey, (Object[])keys).data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Boolean sIsMember(byte[] key, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.sismember((Object)key, (Object)value));
                return null;
            }
            return this.client.sismember((Object)key, (Object)value).data() == 1L;
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> sMembers(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.smembers((Object)key));
                return null;
            }
            return SrpUtils.toSet(this.client.smembers((Object)key).data());
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Boolean sMove(byte[] srcKey, byte[] destKey, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.smove((Object)srcKey, (Object)destKey, (Object)value));
                return null;
            }
            return this.client.smove((Object)srcKey, (Object)destKey, (Object)value).data() == 1L;
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public byte[] sPop(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.spop((Object)key));
                return null;
            }
            return this.client.spop((Object)key).data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public byte[] sRandMember(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.srandmember((Object)key, null));
                return null;
            }
            return (byte[])this.client.srandmember((Object)key, null).data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Boolean sRem(byte[] key, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.srem((Object)key, new Object[]{value}));
                return null;
            }
            return this.client.srem((Object)key, new Object[]{value}).data() == 1L;
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> sUnion(byte[] ... keys) {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.sunion((Object[])keys));
                return null;
            }
            return SrpUtils.toSet(this.client.sunion((Object[])keys).data());
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Long sUnionStore(byte[] destKey, byte[] ... keys) {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.sunionstore((Object)destKey, (Object[])keys));
                return null;
            }
            return this.client.sunionstore((Object)destKey, (Object[])keys).data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Boolean zAdd(byte[] key, double score, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.zadd(new Object[]{key, score, value}));
                return null;
            }
            return this.client.zadd(new Object[]{key, score, value}).data() == 1L;
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Long zCard(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.zcard((Object)key));
                return null;
            }
            return this.client.zcard((Object)key).data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Long zCount(byte[] key, double min, double max) {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.zcount((Object)key, (Object)min, (Object)max));
                return null;
            }
            return this.client.zcount((Object)key, (Object)min, (Object)max).data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Double zIncrBy(byte[] key, double increment, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.zincrby((Object)key, (Object)increment, (Object)value));
                return null;
            }
            return SrpUtils.toDouble(this.client.zincrby((Object)key, (Object)increment, (Object)value).data());
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Long zInterStore(byte[] destKey, RedisZSetCommands.Aggregate aggregate, int[] weights, byte[] ... sets) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Long zInterStore(byte[] destKey, byte[] ... sets) {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.zinterstore((Object)destKey, (Object)sets.length, (Object[])sets));
                return null;
            }
            return this.client.zinterstore((Object)destKey, (Object)sets.length, (Object[])sets).data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRange(byte[] key, long start, long end) {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.zrange((Object)key, (Object)start, (Object)end, null));
                return null;
            }
            return SrpUtils.toSet(this.client.zrange((Object)key, (Object)start, (Object)end, null).data());
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRangeWithScores(byte[] key, long start, long end) {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.zrange((Object)key, (Object)start, (Object)end, (Object)SrpUtils.WITHSCORES));
                return null;
            }
            return SrpUtils.convertTuple(this.client.zrange((Object)key, (Object)start, (Object)end, (Object)SrpUtils.WITHSCORES));
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRangeByScore(byte[] key, double min, double max) {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.zrangebyscore((Object)key, (Object)min, (Object)max, null, EMPTY_PARAMS_ARRAY));
                return null;
            }
            return SrpUtils.toSet(this.client.zrangebyscore((Object)key, (Object)min, (Object)max, null, EMPTY_PARAMS_ARRAY).data());
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRangeByScoreWithScores(byte[] key, double min, double max) {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.zrangebyscore((Object)key, (Object)min, (Object)max, (Object)SrpUtils.WITHSCORES, EMPTY_PARAMS_ARRAY));
                return null;
            }
            return SrpUtils.convertTuple(this.client.zrangebyscore((Object)key, (Object)min, (Object)max, (Object)SrpUtils.WITHSCORES, EMPTY_PARAMS_ARRAY));
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRevRangeWithScores(byte[] key, long start, long end) {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.zrevrange((Object)key, (Object)start, (Object)end, (Object)SrpUtils.WITHSCORES));
                return null;
            }
            return SrpUtils.convertTuple(this.client.zrevrange((Object)key, (Object)start, (Object)end, (Object)SrpUtils.WITHSCORES));
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRangeByScore(byte[] key, double min, double max, long offset, long count) {
        try {
            Object[] limit = SrpUtils.limitParams(offset, count);
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.zrangebyscore((Object)key, (Object)min, (Object)max, null, limit));
                return null;
            }
            return SrpUtils.toSet(this.client.zrangebyscore((Object)key, (Object)min, (Object)max, null, limit).data());
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRangeByScoreWithScores(byte[] key, double min, double max, long offset, long count) {
        try {
            Object[] limit = SrpUtils.limitParams(offset, count);
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.zrangebyscore((Object)key, (Object)min, (Object)max, (Object)SrpUtils.WITHSCORES, limit));
                return null;
            }
            return SrpUtils.convertTuple(this.client.zrangebyscore((Object)key, (Object)min, (Object)max, (Object)SrpUtils.WITHSCORES, limit));
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRevRangeByScore(byte[] key, double min, double max, long offset, long count) {
        try {
            Object[] limit = SrpUtils.limitParams(offset, count);
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.zrevrangebyscore((Object)key, (Object)max, (Object)min, null, limit));
                return null;
            }
            return SrpUtils.toSet(this.client.zrevrangebyscore((Object)key, (Object)max, (Object)min, null, limit).data());
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRevRangeByScore(byte[] key, double min, double max) {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.zrevrangebyscore((Object)key, (Object)max, (Object)min, null, EMPTY_PARAMS_ARRAY));
                return null;
            }
            return SrpUtils.toSet(this.client.zrevrangebyscore((Object)key, (Object)max, (Object)min, null, EMPTY_PARAMS_ARRAY).data());
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRevRangeByScoreWithScores(byte[] key, double min, double max, long offset, long count) {
        try {
            Object[] limit = SrpUtils.limitParams(offset, count);
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.zrevrangebyscore((Object)key, (Object)max, (Object)min, (Object)SrpUtils.WITHSCORES, limit));
                return null;
            }
            return SrpUtils.convertTuple(this.client.zrevrangebyscore((Object)key, (Object)max, (Object)min, (Object)SrpUtils.WITHSCORES, limit));
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRevRangeByScoreWithScores(byte[] key, double min, double max) {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.zrevrangebyscore((Object)key, (Object)max, (Object)min, (Object)SrpUtils.WITHSCORES, EMPTY_PARAMS_ARRAY));
                return null;
            }
            return SrpUtils.convertTuple(this.client.zrevrangebyscore((Object)key, (Object)max, (Object)min, (Object)SrpUtils.WITHSCORES, EMPTY_PARAMS_ARRAY));
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Long zRank(byte[] key, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.zrank((Object)key, (Object)value));
                return null;
            }
            return (Long)this.client.zrank((Object)key, (Object)value).data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Boolean zRem(byte[] key, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.zrem((Object)key, new Object[]{value}));
                return null;
            }
            return this.client.zrem((Object)key, new Object[]{value}).data() == 1L;
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Long zRemRange(byte[] key, long start, long end) {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.zremrangebyrank((Object)key, (Object)start, (Object)end));
                return null;
            }
            return this.client.zremrangebyrank((Object)key, (Object)start, (Object)end).data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Long zRemRangeByScore(byte[] key, double min, double max) {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.zremrangebyscore((Object)key, (Object)min, (Object)max));
                return null;
            }
            return this.client.zremrangebyscore((Object)key, (Object)min, (Object)max).data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRevRange(byte[] key, long start, long end) {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.zrevrange((Object)key, (Object)start, (Object)end, null));
                return null;
            }
            return SrpUtils.toSet(this.client.zrevrange((Object)key, (Object)start, (Object)end, null).data());
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Long zRevRank(byte[] key, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.zrevrank((Object)key, (Object)value));
                return null;
            }
            return (Long)this.client.zrevrank((Object)key, (Object)value).data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Double zScore(byte[] key, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.zscore((Object)key, (Object)value));
                return null;
            }
            return SrpUtils.toDouble(this.client.zscore((Object)key, (Object)value).data());
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Long zUnionStore(byte[] destKey, RedisZSetCommands.Aggregate aggregate, int[] weights, byte[] ... sets) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Long zUnionStore(byte[] destKey, byte[] ... sets) {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.zunionstore((Object)destKey, (Object)sets.length, (Object[])sets));
                return null;
            }
            return this.client.zunionstore((Object)destKey, (Object)sets.length, (Object[])sets).data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Boolean hSet(byte[] key, byte[] field, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.hset((Object)key, (Object)field, (Object)value));
                return null;
            }
            return this.client.hset((Object)key, (Object)field, (Object)value).data() == 1L;
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Boolean hSetNX(byte[] key, byte[] field, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.hsetnx((Object)key, (Object)field, (Object)value));
                return null;
            }
            return this.client.hsetnx((Object)key, (Object)field, (Object)value).data() == 1L;
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Boolean hDel(byte[] key, byte[] field) {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.hdel((Object)key, new Object[]{field}));
                return null;
            }
            return this.client.hdel((Object)key, new Object[]{field}).data() == 1L;
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Boolean hExists(byte[] key, byte[] field) {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.hexists((Object)key, (Object)field));
                return null;
            }
            return this.client.hexists((Object)key, (Object)field).data() == 1L;
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public byte[] hGet(byte[] key, byte[] field) {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.hget((Object)key, (Object)field));
                return null;
            }
            return this.client.hget((Object)key, (Object)field).data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Map<byte[], byte[]> hGetAll(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.hgetall((Object)key));
                return null;
            }
            return SrpUtils.toMap(this.client.hgetall((Object)key).data());
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Long hIncrBy(byte[] key, byte[] field, long delta) {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.hincrby((Object)key, (Object)field, (Object)delta));
                return null;
            }
            return this.client.hincrby((Object)key, (Object)field, (Object)delta).data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> hKeys(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.hkeys((Object)key));
                return null;
            }
            return SrpUtils.toSet(this.client.hkeys((Object)key).data());
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Long hLen(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.hlen((Object)key));
                return null;
            }
            return this.client.hlen((Object)key).data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public List<byte[]> hMGet(byte[] key, byte[] ... fields) {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.hmget((Object)key, (Object[])fields));
                return null;
            }
            return SrpUtils.toBytesList(this.client.hmget((Object)key, (Object[])fields).data());
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public void hMSet(byte[] key, Map<byte[], byte[]> tuple) {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.hmset((Object)key, (Object[])SrpUtils.convert(tuple)));
                return;
            }
            this.client.hmset((Object)key, (Object[])SrpUtils.convert(tuple));
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public List<byte[]> hVals(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.hvals((Object)key));
                return null;
            }
            return SrpUtils.toBytesList(this.client.hvals((Object)key).data());
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Long publish(byte[] channel, byte[] message) {
        try {
            if (this.isQueueing()) {
                throw new UnsupportedOperationException();
            }
            if (this.isPipelined()) {
                this.pipeline((ListenableFuture<? extends Reply>)this.pipeline.publish((Object)channel, (Object)message));
                return null;
            }
            return this.client.publish((Object)channel, (Object)message).data();
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public Subscription getSubscription() {
        return this.subscription;
    }

    @Override
    public boolean isSubscribed() {
        return this.subscription != null && this.subscription.isAlive();
    }

    @Override
    public void pSubscribe(MessageListener listener, byte[] ... patterns) {
        this.checkSubscription();
        try {
            if (this.isQueueing()) {
                throw new UnsupportedOperationException();
            }
            if (this.isPipelined()) {
                throw new UnsupportedOperationException();
            }
            this.subscription = new SrpSubscription(listener, this.client);
            this.subscription.pSubscribe(patterns);
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    @Override
    public void subscribe(MessageListener listener, byte[] ... channels) {
        this.checkSubscription();
        try {
            if (this.isPipelined()) {
                throw new UnsupportedOperationException();
            }
            this.subscription = new SrpSubscription(listener, this.client);
            this.subscription.subscribe(channels);
        }
        catch (Exception ex) {
            throw this.convertSrpAccessException(ex);
        }
    }

    private void checkSubscription() {
        if (this.isSubscribed()) {
            throw new RedisSubscribedConnectionException("Connection already subscribed; use the connection Subscription to cancel or add new channels");
        }
    }

    private void pipeline(ListenableFuture<? extends Reply> future) {
        this.callback.addCommand(future);
    }

    private void initPipeline() {
        if (this.pipeline == null) {
            this.callback = new PipelineTracker();
            this.pipeline = this.client.pipeline();
        }
    }

    private List<Object> closePipeline(boolean getResults) {
        this.pipelineRequested = false;
        List<Object> results = Collections.emptyList();
        if (this.pipeline != null) {
            this.pipeline = null;
            if (getResults) {
                results = this.getPipelinedResults();
            }
            this.callback.close();
            this.callback = null;
        }
        return results;
    }

    private List<Object> getPipelinedResults() {
        ArrayList<Object> execute = new ArrayList<Object>(this.callback.complete());
        if (execute != null && !execute.isEmpty()) {
            DataAccessException cause = null;
            for (int i = 0; i < execute.size(); ++i) {
                Object object = execute.get(i);
                if (!(object instanceof Exception)) continue;
                DataAccessException dataAccessException = this.convertSrpAccessException((Exception)object);
                if (cause == null) {
                    cause = dataAccessException;
                }
                execute.set(i, dataAccessException);
            }
            if (cause != null) {
                throw new RedisPipelineException((Exception)cause, (List<Object>)execute);
            }
            return execute;
        }
        return Collections.emptyList();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PipelineTracker
    implements FutureCallback<Reply> {
        private final List<Object> results = Collections.synchronizedList(new ArrayList());
        private final List<ListenableFuture<? extends Reply>> futures = new ArrayList<ListenableFuture<? extends Reply>>();

        private PipelineTracker() {
        }

        public void onSuccess(Reply result) {
            this.results.add(result.data());
        }

        public void onFailure(Throwable t) {
            this.results.add(t);
        }

        public List<Object> complete() {
            try {
                Futures.successfulAsList(this.futures).get();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this.results;
        }

        public void addCommand(ListenableFuture<? extends Reply> future) {
            this.futures.add(future);
            Futures.addCallback(future, (FutureCallback)this);
        }

        public void close() {
            this.results.clear();
            this.futures.clear();
        }
    }
}

