/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.connection.SortParameters;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.data.redis.core.BoundListOperations;
import org.springframework.data.redis.core.BoundSetOperations;
import org.springframework.data.redis.core.BoundValueOperations;
import org.springframework.data.redis.core.BoundZSetOperations;
import org.springframework.data.redis.core.BulkMapper;
import org.springframework.data.redis.core.CloseSuppressingInvocationHandler;
import org.springframework.data.redis.core.DefaultBoundHashOperations;
import org.springframework.data.redis.core.DefaultBoundListOperations;
import org.springframework.data.redis.core.DefaultBoundSetOperations;
import org.springframework.data.redis.core.DefaultBoundValueOperations;
import org.springframework.data.redis.core.DefaultBoundZSetOperations;
import org.springframework.data.redis.core.DefaultHashOperations;
import org.springframework.data.redis.core.DefaultListOperations;
import org.springframework.data.redis.core.DefaultSetOperations;
import org.springframework.data.redis.core.DefaultTypedTuple;
import org.springframework.data.redis.core.DefaultValueOperations;
import org.springframework.data.redis.core.DefaultZSetOperations;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.ListOperations;
import org.springframework.data.redis.core.RedisAccessor;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.RedisConnectionUtils;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.SessionCallback;
import org.springframework.data.redis.core.SetOperations;
import org.springframework.data.redis.core.TimeoutUtils;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.data.redis.core.query.QueryUtils;
import org.springframework.data.redis.core.query.SortQuery;
import org.springframework.data.redis.core.script.DefaultScriptExecutor;
import org.springframework.data.redis.core.script.RedisScript;
import org.springframework.data.redis.core.script.ScriptExecutor;
import org.springframework.data.redis.core.types.RedisClientInfo;
import org.springframework.data.redis.serializer.JdkSerializationRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.SerializationUtils;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;

public class RedisTemplate<K, V>
extends RedisAccessor
implements RedisOperations<K, V> {
    private boolean enableTransactionSupport = false;
    private boolean exposeConnection = false;
    private boolean initialized = false;
    private boolean enableDefaultSerializer = true;
    private RedisSerializer<?> defaultSerializer = new JdkSerializationRedisSerializer();
    private RedisSerializer keySerializer = null;
    private RedisSerializer valueSerializer = null;
    private RedisSerializer hashKeySerializer = null;
    private RedisSerializer hashValueSerializer = null;
    private RedisSerializer<String> stringSerializer = new StringRedisSerializer();
    private ScriptExecutor<K> scriptExecutor;
    private ValueOperations<K, V> valueOps;
    private ListOperations<K, V> listOps;
    private SetOperations<K, V> setOps;
    private ZSetOperations<K, V> zSetOps;

    @Override
    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        boolean defaultUsed = false;
        if (this.enableDefaultSerializer) {
            if (this.keySerializer == null) {
                this.keySerializer = this.defaultSerializer;
                defaultUsed = true;
            }
            if (this.valueSerializer == null) {
                this.valueSerializer = this.defaultSerializer;
                defaultUsed = true;
            }
            if (this.hashKeySerializer == null) {
                this.hashKeySerializer = this.defaultSerializer;
                defaultUsed = true;
            }
            if (this.hashValueSerializer == null) {
                this.hashValueSerializer = this.defaultSerializer;
                defaultUsed = true;
            }
        }
        if (this.enableDefaultSerializer && defaultUsed) {
            Assert.notNull(this.defaultSerializer, (String)"default serializer null and not all serializers initialized");
        }
        if (this.scriptExecutor == null) {
            this.scriptExecutor = new DefaultScriptExecutor(this);
        }
        this.initialized = true;
    }

    @Override
    public <T> T execute(RedisCallback<T> action) {
        return this.execute(action, this.isExposeConnection());
    }

    public <T> T execute(RedisCallback<T> action, boolean exposeConnection) {
        return this.execute(action, exposeConnection, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T execute(RedisCallback<T> action, boolean exposeConnection, boolean pipeline) {
        Assert.isTrue((boolean)this.initialized, (String)"template not initialized; call afterPropertiesSet() before using it");
        Assert.notNull(action, (String)"Callback object must not be null");
        RedisConnectionFactory factory = this.getConnectionFactory();
        RedisConnection conn = null;
        try {
            conn = this.enableTransactionSupport ? RedisConnectionUtils.bindConnection(factory, this.enableTransactionSupport) : RedisConnectionUtils.getConnection(factory);
            boolean existingConnection = TransactionSynchronizationManager.hasResource((Object)factory);
            RedisConnection connToUse = this.preProcessConnection(conn, existingConnection);
            boolean pipelineStatus = connToUse.isPipelined();
            if (pipeline && !pipelineStatus) {
                connToUse.openPipeline();
            }
            RedisConnection connToExpose = exposeConnection ? connToUse : this.createRedisConnectionProxy(connToUse);
            T result = action.doInRedis(connToExpose);
            if (pipeline && !pipelineStatus) {
                connToUse.closePipeline();
            }
            T t = this.postProcessResult(result, connToUse, existingConnection);
            return t;
        }
        finally {
            if (this.enableTransactionSupport) {
                RedisConnectionUtils.unbindConnection(factory);
            } else {
                RedisConnectionUtils.releaseConnection(conn, factory);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T execute(SessionCallback<T> session) {
        Assert.isTrue((boolean)this.initialized, (String)"template not initialized; call afterPropertiesSet() before using it");
        Assert.notNull(session, (String)"Callback object must not be null");
        RedisConnectionFactory factory = this.getConnectionFactory();
        RedisConnectionUtils.bindConnection(factory, this.enableTransactionSupport);
        try {
            T t = session.execute(this);
            return t;
        }
        finally {
            RedisConnectionUtils.unbindConnection(factory);
        }
    }

    @Override
    public List<Object> executePipelined(SessionCallback<?> session) {
        return this.executePipelined(session, this.valueSerializer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Object> executePipelined(final SessionCallback<?> session, final RedisSerializer<?> resultSerializer) {
        Assert.isTrue((boolean)this.initialized, (String)"template not initialized; call afterPropertiesSet() before using it");
        Assert.notNull(session, (String)"Callback object must not be null");
        RedisConnectionFactory factory = this.getConnectionFactory();
        RedisConnectionUtils.bindConnection(factory, this.enableTransactionSupport);
        try {
            List<Object> list = this.execute(new RedisCallback<List<Object>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public List<Object> doInRedis(RedisConnection connection) throws DataAccessException {
                    connection.openPipeline();
                    boolean pipelinedClosed = false;
                    try {
                        Object result = RedisTemplate.this.executeSession(session);
                        if (result != null) {
                            throw new InvalidDataAccessApiUsageException("Callback cannot return a non-null value as it gets overwritten by the pipeline");
                        }
                        List<Object> closePipeline = connection.closePipeline();
                        pipelinedClosed = true;
                        List list = RedisTemplate.this.deserializeMixedResults(closePipeline, resultSerializer, RedisTemplate.this.hashKeySerializer, RedisTemplate.this.hashValueSerializer);
                        return list;
                    }
                    finally {
                        if (!pipelinedClosed) {
                            connection.closePipeline();
                        }
                    }
                }
            });
            return list;
        }
        finally {
            RedisConnectionUtils.unbindConnection(factory);
        }
    }

    @Override
    public List<Object> executePipelined(RedisCallback<?> action) {
        return this.executePipelined(action, this.valueSerializer);
    }

    @Override
    public List<Object> executePipelined(final RedisCallback<?> action, final RedisSerializer<?> resultSerializer) {
        return this.execute(new RedisCallback<List<Object>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<Object> doInRedis(RedisConnection connection) throws DataAccessException {
                connection.openPipeline();
                boolean pipelinedClosed = false;
                try {
                    Object result = action.doInRedis(connection);
                    if (result != null) {
                        throw new InvalidDataAccessApiUsageException("Callback cannot return a non-null value as it gets overwritten by the pipeline");
                    }
                    List<Object> closePipeline = connection.closePipeline();
                    pipelinedClosed = true;
                    List list = RedisTemplate.this.deserializeMixedResults(closePipeline, resultSerializer, resultSerializer, resultSerializer);
                    return list;
                }
                finally {
                    if (!pipelinedClosed) {
                        connection.closePipeline();
                    }
                }
            }
        });
    }

    @Override
    public <T> T execute(RedisScript<T> script, List<K> keys, Object ... args) {
        return this.scriptExecutor.execute(script, keys, args);
    }

    @Override
    public <T> T execute(RedisScript<T> script, RedisSerializer<?> argsSerializer, RedisSerializer<T> resultSerializer, List<K> keys, Object ... args) {
        return this.scriptExecutor.execute(script, argsSerializer, resultSerializer, keys, args);
    }

    private Object executeSession(SessionCallback<?> session) {
        return session.execute(this);
    }

    protected RedisConnection createRedisConnectionProxy(RedisConnection pm) {
        Class[] ifcs = ClassUtils.getAllInterfacesForClass(pm.getClass(), (ClassLoader)this.getClass().getClassLoader());
        return (RedisConnection)Proxy.newProxyInstance(pm.getClass().getClassLoader(), ifcs, (InvocationHandler)new CloseSuppressingInvocationHandler(pm));
    }

    protected RedisConnection preProcessConnection(RedisConnection connection, boolean existingConnection) {
        return connection;
    }

    protected <T> T postProcessResult(T result, RedisConnection conn, boolean existingConnection) {
        return result;
    }

    public boolean isExposeConnection() {
        return this.exposeConnection;
    }

    public void setExposeConnection(boolean exposeConnection) {
        this.exposeConnection = exposeConnection;
    }

    public boolean isEnableDefaultSerializer() {
        return this.enableDefaultSerializer;
    }

    public void setEnableDefaultSerializer(boolean enableDefaultSerializer) {
        this.enableDefaultSerializer = enableDefaultSerializer;
    }

    public RedisSerializer<?> getDefaultSerializer() {
        return this.defaultSerializer;
    }

    public void setDefaultSerializer(RedisSerializer<?> serializer) {
        this.defaultSerializer = serializer;
    }

    public void setKeySerializer(RedisSerializer<?> serializer) {
        this.keySerializer = serializer;
    }

    @Override
    public RedisSerializer<?> getKeySerializer() {
        return this.keySerializer;
    }

    public void setValueSerializer(RedisSerializer<?> serializer) {
        this.valueSerializer = serializer;
    }

    @Override
    public RedisSerializer<?> getValueSerializer() {
        return this.valueSerializer;
    }

    @Override
    public RedisSerializer<?> getHashKeySerializer() {
        return this.hashKeySerializer;
    }

    public void setHashKeySerializer(RedisSerializer<?> hashKeySerializer) {
        this.hashKeySerializer = hashKeySerializer;
    }

    @Override
    public RedisSerializer<?> getHashValueSerializer() {
        return this.hashValueSerializer;
    }

    public void setHashValueSerializer(RedisSerializer<?> hashValueSerializer) {
        this.hashValueSerializer = hashValueSerializer;
    }

    public RedisSerializer<String> getStringSerializer() {
        return this.stringSerializer;
    }

    public void setStringSerializer(RedisSerializer<String> stringSerializer) {
        this.stringSerializer = stringSerializer;
    }

    public void setScriptExecutor(ScriptExecutor<K> scriptExecutor) {
        this.scriptExecutor = scriptExecutor;
    }

    private byte[] rawKey(Object key) {
        Assert.notNull((Object)key, (String)"non null key required");
        if (this.keySerializer == null && key instanceof byte[]) {
            return (byte[])key;
        }
        return this.keySerializer.serialize(key);
    }

    private byte[] rawString(String key) {
        return this.stringSerializer.serialize(key);
    }

    private byte[] rawValue(Object value) {
        if (this.valueSerializer == null && value instanceof byte[]) {
            return (byte[])value;
        }
        return this.valueSerializer.serialize(value);
    }

    private byte[][] rawKeys(Collection<K> keys) {
        byte[][] rawKeys = new byte[keys.size()][];
        int i = 0;
        for (K key : keys) {
            rawKeys[i++] = this.rawKey(key);
        }
        return rawKeys;
    }

    private K deserializeKey(byte[] value) {
        return (K)(this.keySerializer != null ? (Object)this.keySerializer.deserialize(value) : value);
    }

    private List<Object> deserializeMixedResults(List<Object> rawValues, RedisSerializer valueSerializer, RedisSerializer hashKeySerializer, RedisSerializer hashValueSerializer) {
        if (rawValues == null) {
            return null;
        }
        ArrayList<Object> values = new ArrayList<Object>();
        for (Object rawValue : rawValues) {
            if (rawValue instanceof byte[] && valueSerializer != null) {
                values.add(valueSerializer.deserialize((byte[])rawValue));
                continue;
            }
            if (rawValue instanceof List) {
                values.add(this.deserializeMixedResults((List)rawValue, valueSerializer, hashKeySerializer, hashValueSerializer));
                continue;
            }
            if (rawValue instanceof Set && !((Set)rawValue).isEmpty()) {
                values.add(this.deserializeSet((Set)rawValue, valueSerializer));
                continue;
            }
            if (rawValue instanceof Map && !((Map)rawValue).isEmpty() && ((Map)rawValue).values().iterator().next() instanceof byte[]) {
                values.add(SerializationUtils.deserialize((Map)rawValue, hashKeySerializer, hashValueSerializer));
                continue;
            }
            values.add(rawValue);
        }
        return values;
    }

    private Set<?> deserializeSet(Set rawSet, RedisSerializer valueSerializer) {
        if (rawSet.isEmpty()) {
            return rawSet;
        }
        Object setValue = rawSet.iterator().next();
        if (setValue instanceof byte[] && valueSerializer != null) {
            return SerializationUtils.deserialize(rawSet, valueSerializer);
        }
        if (setValue instanceof RedisZSetCommands.Tuple) {
            return this.convertTupleValues(rawSet, valueSerializer);
        }
        return rawSet;
    }

    private Set<ZSetOperations.TypedTuple<V>> convertTupleValues(Set<RedisZSetCommands.Tuple> rawValues, RedisSerializer valueSerializer) {
        LinkedHashSet<ZSetOperations.TypedTuple<V>> set = new LinkedHashSet<ZSetOperations.TypedTuple<V>>(rawValues.size());
        for (RedisZSetCommands.Tuple rawValue : rawValues) {
            Object value = rawValue.getValue();
            if (valueSerializer != null) {
                value = valueSerializer.deserialize(rawValue.getValue());
            }
            set.add(new DefaultTypedTuple<byte[]>((byte[])value, rawValue.getScore()));
        }
        return set;
    }

    @Override
    public List<Object> exec() {
        List<Object> results = this.execRaw();
        if (this.getConnectionFactory().getConvertPipelineAndTxResults()) {
            return this.deserializeMixedResults(results, this.valueSerializer, this.hashKeySerializer, this.hashValueSerializer);
        }
        return results;
    }

    @Override
    public List<Object> exec(RedisSerializer<?> valueSerializer) {
        return this.deserializeMixedResults(this.execRaw(), valueSerializer, valueSerializer, valueSerializer);
    }

    protected List<Object> execRaw() {
        return this.execute(new RedisCallback<List<Object>>(){

            @Override
            public List<Object> doInRedis(RedisConnection connection) throws DataAccessException {
                return connection.exec();
            }
        });
    }

    @Override
    public void delete(K key) {
        final byte[] rawKey = this.rawKey(key);
        this.execute(new RedisCallback<Object>(){

            @Override
            public Object doInRedis(RedisConnection connection) {
                connection.del(new byte[][]{rawKey});
                return null;
            }
        }, true);
    }

    @Override
    public void delete(Collection<K> keys) {
        if (CollectionUtils.isEmpty(keys)) {
            return;
        }
        final byte[][] rawKeys = this.rawKeys(keys);
        this.execute(new RedisCallback<Object>(){

            @Override
            public Object doInRedis(RedisConnection connection) {
                connection.del(rawKeys);
                return null;
            }
        }, true);
    }

    @Override
    public Boolean hasKey(K key) {
        final byte[] rawKey = this.rawKey(key);
        return this.execute(new RedisCallback<Boolean>(){

            @Override
            public Boolean doInRedis(RedisConnection connection) {
                return connection.exists(rawKey);
            }
        }, true);
    }

    @Override
    public Boolean expire(K key, final long timeout, final TimeUnit unit) {
        final byte[] rawKey = this.rawKey(key);
        final long rawTimeout = TimeoutUtils.toMillis(timeout, unit);
        return this.execute(new RedisCallback<Boolean>(){

            @Override
            public Boolean doInRedis(RedisConnection connection) {
                try {
                    return connection.pExpire(rawKey, rawTimeout);
                }
                catch (Exception e) {
                    return connection.expire(rawKey, TimeoutUtils.toSeconds(timeout, unit));
                }
            }
        }, true);
    }

    @Override
    public Boolean expireAt(K key, final Date date) {
        final byte[] rawKey = this.rawKey(key);
        return this.execute(new RedisCallback<Boolean>(){

            @Override
            public Boolean doInRedis(RedisConnection connection) {
                try {
                    return connection.pExpireAt(rawKey, date.getTime());
                }
                catch (Exception e) {
                    return connection.expireAt(rawKey, date.getTime() / 1000L);
                }
            }
        }, true);
    }

    @Override
    public void convertAndSend(String channel, Object message) {
        Assert.hasText((String)channel, (String)"a non-empty channel is required");
        final byte[] rawChannel = this.rawString(channel);
        final byte[] rawMessage = this.rawValue(message);
        this.execute(new RedisCallback<Object>(){

            @Override
            public Object doInRedis(RedisConnection connection) {
                connection.publish(rawChannel, rawMessage);
                return null;
            }
        }, true);
    }

    @Override
    public Long getExpire(K key) {
        final byte[] rawKey = this.rawKey(key);
        return this.execute(new RedisCallback<Long>(){

            @Override
            public Long doInRedis(RedisConnection connection) {
                return connection.ttl(rawKey);
            }
        }, true);
    }

    @Override
    public Long getExpire(K key, final TimeUnit timeUnit) {
        final byte[] rawKey = this.rawKey(key);
        return this.execute(new RedisCallback<Long>(){

            @Override
            public Long doInRedis(RedisConnection connection) {
                try {
                    return timeUnit.convert(connection.pTtl(rawKey), TimeUnit.MILLISECONDS);
                }
                catch (Exception e) {
                    return timeUnit.convert(connection.ttl(rawKey), TimeUnit.SECONDS);
                }
            }
        }, true);
    }

    @Override
    public Set<K> keys(K pattern) {
        final byte[] rawKey = this.rawKey(pattern);
        Set<byte[]> rawKeys = this.execute(new RedisCallback<Set<byte[]>>(){

            @Override
            public Set<byte[]> doInRedis(RedisConnection connection) {
                return connection.keys(rawKey);
            }
        }, true);
        return this.keySerializer != null ? SerializationUtils.deserialize(rawKeys, this.keySerializer) : rawKeys;
    }

    @Override
    public Boolean persist(K key) {
        final byte[] rawKey = this.rawKey(key);
        return this.execute(new RedisCallback<Boolean>(){

            @Override
            public Boolean doInRedis(RedisConnection connection) {
                return connection.persist(rawKey);
            }
        }, true);
    }

    @Override
    public Boolean move(K key, final int dbIndex) {
        final byte[] rawKey = this.rawKey(key);
        return this.execute(new RedisCallback<Boolean>(){

            @Override
            public Boolean doInRedis(RedisConnection connection) {
                return connection.move(rawKey, dbIndex);
            }
        }, true);
    }

    @Override
    public K randomKey() {
        byte[] rawKey = this.execute(new RedisCallback<byte[]>(){

            @Override
            public byte[] doInRedis(RedisConnection connection) {
                return connection.randomKey();
            }
        }, true);
        return this.deserializeKey(rawKey);
    }

    @Override
    public void rename(K oldKey, K newKey) {
        final byte[] rawOldKey = this.rawKey(oldKey);
        final byte[] rawNewKey = this.rawKey(newKey);
        this.execute(new RedisCallback<Object>(){

            @Override
            public Object doInRedis(RedisConnection connection) {
                connection.rename(rawOldKey, rawNewKey);
                return null;
            }
        }, true);
    }

    @Override
    public Boolean renameIfAbsent(K oldKey, K newKey) {
        final byte[] rawOldKey = this.rawKey(oldKey);
        final byte[] rawNewKey = this.rawKey(newKey);
        return this.execute(new RedisCallback<Boolean>(){

            @Override
            public Boolean doInRedis(RedisConnection connection) {
                return connection.renameNX(rawOldKey, rawNewKey);
            }
        }, true);
    }

    @Override
    public DataType type(K key) {
        final byte[] rawKey = this.rawKey(key);
        return this.execute(new RedisCallback<DataType>(){

            @Override
            public DataType doInRedis(RedisConnection connection) {
                return connection.type(rawKey);
            }
        }, true);
    }

    @Override
    public byte[] dump(K key) {
        final byte[] rawKey = this.rawKey(key);
        return this.execute(new RedisCallback<byte[]>(){

            @Override
            public byte[] doInRedis(RedisConnection connection) {
                return connection.dump(rawKey);
            }
        }, true);
    }

    @Override
    public void restore(K key, final byte[] value, long timeToLive, TimeUnit unit) {
        final byte[] rawKey = this.rawKey(key);
        final long rawTimeout = TimeoutUtils.toMillis(timeToLive, unit);
        this.execute(new RedisCallback<Object>(){

            @Override
            public Boolean doInRedis(RedisConnection connection) {
                connection.restore(rawKey, rawTimeout, value);
                return null;
            }
        }, true);
    }

    @Override
    public void multi() {
        this.execute(new RedisCallback<Object>(){

            @Override
            public Object doInRedis(RedisConnection connection) throws DataAccessException {
                connection.multi();
                return null;
            }
        }, true);
    }

    @Override
    public void discard() {
        this.execute(new RedisCallback<Object>(){

            @Override
            public Object doInRedis(RedisConnection connection) throws DataAccessException {
                connection.discard();
                return null;
            }
        }, true);
    }

    @Override
    public void watch(K key) {
        final byte[] rawKey = this.rawKey(key);
        this.execute(new RedisCallback<Object>(){

            @Override
            public Object doInRedis(RedisConnection connection) {
                connection.watch(new byte[][]{rawKey});
                return null;
            }
        }, true);
    }

    @Override
    public void watch(Collection<K> keys) {
        final byte[][] rawKeys = this.rawKeys(keys);
        this.execute(new RedisCallback<Object>(){

            @Override
            public Object doInRedis(RedisConnection connection) {
                connection.watch(rawKeys);
                return null;
            }
        }, true);
    }

    @Override
    public void unwatch() {
        this.execute(new RedisCallback<Object>(){

            @Override
            public Object doInRedis(RedisConnection connection) throws DataAccessException {
                connection.unwatch();
                return null;
            }
        }, true);
    }

    @Override
    public List<V> sort(SortQuery<K> query) {
        return this.sort(query, this.valueSerializer);
    }

    @Override
    public <T> List<T> sort(SortQuery<K> query, RedisSerializer<T> resultSerializer) {
        final byte[] rawKey = this.rawKey(query.getKey());
        final SortParameters params = QueryUtils.convertQuery(query, this.stringSerializer);
        List<byte[]> vals = this.execute(new RedisCallback<List<byte[]>>(){

            @Override
            public List<byte[]> doInRedis(RedisConnection connection) throws DataAccessException {
                return connection.sort(rawKey, params);
            }
        }, true);
        return SerializationUtils.deserialize(vals, resultSerializer);
    }

    @Override
    public <T> List<T> sort(SortQuery<K> query, BulkMapper<T, V> bulkMapper) {
        return this.sort(query, bulkMapper, this.valueSerializer);
    }

    @Override
    public <T, S> List<T> sort(SortQuery<K> query, BulkMapper<T, S> bulkMapper, RedisSerializer<S> resultSerializer) {
        List<S> values = this.sort(query, resultSerializer);
        if (values == null || values.isEmpty()) {
            return Collections.emptyList();
        }
        int bulkSize = query.getGetPattern().size();
        ArrayList<T> result = new ArrayList<T>(values.size() / bulkSize + 1);
        ArrayList<S> bulk = new ArrayList<S>(bulkSize);
        for (S s : values) {
            bulk.add(s);
            if (bulk.size() != bulkSize) continue;
            result.add(bulkMapper.mapBulk(Collections.unmodifiableList(bulk)));
            bulk = new ArrayList(bulkSize);
        }
        return result;
    }

    @Override
    public Long sort(SortQuery<K> query, K storeKey) {
        final byte[] rawStoreKey = this.rawKey(storeKey);
        final byte[] rawKey = this.rawKey(query.getKey());
        final SortParameters params = QueryUtils.convertQuery(query, this.stringSerializer);
        return this.execute(new RedisCallback<Long>(){

            @Override
            public Long doInRedis(RedisConnection connection) throws DataAccessException {
                return connection.sort(rawKey, params, rawStoreKey);
            }
        }, true);
    }

    @Override
    public BoundValueOperations<K, V> boundValueOps(K key) {
        return new DefaultBoundValueOperations(key, this);
    }

    @Override
    public ValueOperations<K, V> opsForValue() {
        if (this.valueOps == null) {
            this.valueOps = new DefaultValueOperations(this);
        }
        return this.valueOps;
    }

    @Override
    public ListOperations<K, V> opsForList() {
        if (this.listOps == null) {
            this.listOps = new DefaultListOperations(this);
        }
        return this.listOps;
    }

    @Override
    public BoundListOperations<K, V> boundListOps(K key) {
        return new DefaultBoundListOperations(key, this);
    }

    @Override
    public BoundSetOperations<K, V> boundSetOps(K key) {
        return new DefaultBoundSetOperations(key, this);
    }

    @Override
    public SetOperations<K, V> opsForSet() {
        if (this.setOps == null) {
            this.setOps = new DefaultSetOperations(this);
        }
        return this.setOps;
    }

    @Override
    public BoundZSetOperations<K, V> boundZSetOps(K key) {
        return new DefaultBoundZSetOperations(key, this);
    }

    @Override
    public ZSetOperations<K, V> opsForZSet() {
        if (this.zSetOps == null) {
            this.zSetOps = new DefaultZSetOperations(this);
        }
        return this.zSetOps;
    }

    @Override
    public <HK, HV> BoundHashOperations<K, HK, HV> boundHashOps(K key) {
        return new DefaultBoundHashOperations(key, this);
    }

    @Override
    public <HK, HV> HashOperations<K, HK, HV> opsForHash() {
        return new DefaultHashOperations(this);
    }

    @Override
    public void killClient(final String host, final int port) {
        this.execute(new RedisCallback<Void>(){

            @Override
            public Void doInRedis(RedisConnection connection) throws DataAccessException {
                connection.killClient(host, port);
                return null;
            }
        });
    }

    @Override
    public List<RedisClientInfo> getClientList() {
        return this.execute(new RedisCallback<List<RedisClientInfo>>(){

            @Override
            public List<RedisClientInfo> doInRedis(RedisConnection connection) throws DataAccessException {
                return connection.getClientList();
            }
        });
    }

    @Override
    public void slaveOf(final String host, final int port) {
        this.execute(new RedisCallback<Void>(){

            @Override
            public Void doInRedis(RedisConnection connection) throws DataAccessException {
                connection.slaveOf(host, port);
                return null;
            }
        });
    }

    @Override
    public void slaveOfNoOne() {
        this.execute(new RedisCallback<Void>(){

            @Override
            public Void doInRedis(RedisConnection connection) throws DataAccessException {
                connection.slaveOfNoOne();
                return null;
            }
        });
    }

    public void setEnableTransactionSupport(boolean enableTransactionSupport) {
        this.enableTransactionSupport = enableTransactionSupport;
    }
}

