/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import com.lambdaworks.redis.api.reactive.RedisKeyReactiveCommands;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.connection.ReactiveKeyCommands;
import org.springframework.data.redis.connection.ReactiveRedisConnection;
import org.springframework.data.redis.connection.convert.Converters;
import org.springframework.data.redis.connection.lettuce.LettuceConverters;
import org.springframework.data.redis.connection.lettuce.LettuceReactiveRedisConnection;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class LettuceReactiveKeyCommands
implements ReactiveKeyCommands {
    private final LettuceReactiveRedisConnection connection;

    public LettuceReactiveKeyCommands(LettuceReactiveRedisConnection connection) {
        Assert.notNull((Object)connection, (String)"Connection must not be null!");
        this.connection = connection;
    }

    @Override
    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveRedisConnection.KeyCommand>> exists(Publisher<ReactiveRedisConnection.KeyCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).flatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            return cmd.exists((Object[])new ByteBuffer[]{command.getKey()}).map(arg_0 -> LettuceConverters.longToBooleanConverter().convert(arg_0)).map(value -> new ReactiveRedisConnection.BooleanResponse<ReactiveRedisConnection.KeyCommand>((ReactiveRedisConnection.KeyCommand)command, (Boolean)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveRedisConnection.KeyCommand, DataType>> type(Publisher<ReactiveRedisConnection.KeyCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).flatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            return cmd.type((Object)command.getKey()).map(Converters::toDataType).map(respValue -> new ReactiveRedisConnection.CommandResponse<ReactiveRedisConnection.KeyCommand, DataType>((ReactiveRedisConnection.KeyCommand)command, (DataType)((Object)((Object)((Object)respValue)))));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveRedisConnection.KeyCommand, Long>> del(Publisher<ReactiveRedisConnection.KeyCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).flatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            return cmd.del((Object[])new ByteBuffer[]{command.getKey()}).map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveRedisConnection.KeyCommand, Long>((ReactiveRedisConnection.KeyCommand)command, (Long)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<List<ByteBuffer>, Long>> mDel(Publisher<List<ByteBuffer>> keysCollection) {
        return this.connection.execute(cmd -> Flux.from((Publisher)keysCollection).flatMap(keys -> {
            Assert.notEmpty((Collection)keys, (String)"Keys must not be null!");
            return cmd.del((Object[])keys.stream().collect(Collectors.toList()).toArray(new ByteBuffer[keys.size()])).map(value -> new ReactiveRedisConnection.NumericResponse<List, Long>((List)keys, (Long)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.MultiValueResponse<ByteBuffer, ByteBuffer>> keys(Publisher<ByteBuffer> patterns) {
        return this.connection.execute(cmd -> Flux.from((Publisher)patterns).flatMap(pattern -> {
            Assert.notNull((Object)pattern, (String)"Pattern must not be null!");
            return cmd.keys(pattern).collectList().map(value -> new ReactiveRedisConnection.MultiValueResponse((ByteBuffer)pattern, value));
        }));
    }

    @Override
    public Mono<ByteBuffer> randomKey() {
        return this.connection.execute(RedisKeyReactiveCommands::randomkey).next();
    }

    @Override
    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveKeyCommands.RenameCommand>> rename(Publisher<ReactiveKeyCommands.RenameCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).flatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull((Object)command.getNewName(), (String)"New name must not be null!");
            return cmd.rename((Object)command.getKey(), (Object)command.getNewName()).map(Converters::stringToBoolean).map(value -> new ReactiveRedisConnection.BooleanResponse<ReactiveKeyCommands.RenameCommand>((ReactiveKeyCommands.RenameCommand)command, (Boolean)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveKeyCommands.RenameCommand>> renameNX(Publisher<ReactiveKeyCommands.RenameCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).flatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull((Object)command.getNewName(), (String)"New name must not be null!");
            return cmd.renamenx((Object)command.getKey(), (Object)command.getNewName()).map(value -> new ReactiveRedisConnection.BooleanResponse<ReactiveKeyCommands.RenameCommand>((ReactiveKeyCommands.RenameCommand)command, (Boolean)value));
        }));
    }
}

