/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import com.lambdaworks.redis.cluster.api.reactive.RedisClusterReactiveCommands;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.springframework.data.redis.connection.ClusterSlotHashUtil;
import org.springframework.data.redis.connection.ReactiveClusterSetCommands;
import org.springframework.data.redis.connection.ReactiveRedisConnection;
import org.springframework.data.redis.connection.ReactiveSetCommands;
import org.springframework.data.redis.connection.convert.Converters;
import org.springframework.data.redis.connection.lettuce.LettuceReactiveRedisConnection;
import org.springframework.data.redis.connection.lettuce.LettuceReactiveSetCommands;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class LettuceReactiveClusterSetCommands
extends LettuceReactiveSetCommands
implements ReactiveClusterSetCommands {
    public LettuceReactiveClusterSetCommands(LettuceReactiveRedisConnection connection) {
        super(connection);
    }

    @Override
    public Flux<ReactiveRedisConnection.MultiValueResponse<ReactiveSetCommands.SUnionCommand, ByteBuffer>> sUnion(Publisher<ReactiveSetCommands.SUnionCommand> commands) {
        return this.getConnection().execute(cmd -> Flux.from((Publisher)commands).flatMap(command -> {
            Assert.notNull(command.getKeys(), (String)"Keys must not be null!");
            if (ClusterSlotHashUtil.isSameSlotForAllKeys(command.getKeys())) {
                return super.sUnion((Publisher<ReactiveSetCommands.SUnionCommand>)Mono.just((Object)command));
            }
            Mono result = Flux.merge((Iterable)command.getKeys().stream().map(arg_0 -> ((RedisClusterReactiveCommands)cmd).smembers(arg_0)).collect(Collectors.toList())).distinct().collectList();
            return result.map(value -> new ReactiveRedisConnection.MultiValueResponse((ReactiveSetCommands.SUnionCommand)command, value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveSetCommands.SUnionStoreCommand, Long>> sUnionStore(Publisher<ReactiveSetCommands.SUnionStoreCommand> commands) {
        return this.getConnection().execute(cmd -> Flux.from((Publisher)commands).flatMap(command -> {
            Assert.notNull(command.getKeys(), (String)"Source keys must not be null!");
            Assert.notNull((Object)command.getKey(), (String)"Destination key must not be null!");
            ArrayList<ByteBuffer> keys = new ArrayList<ByteBuffer>(command.getKeys());
            keys.add(command.getKey());
            if (ClusterSlotHashUtil.isSameSlotForAllKeys(keys)) {
                return super.sUnionStore((Publisher<ReactiveSetCommands.SUnionStoreCommand>)Mono.just((Object)command));
            }
            return this.sUnion((Publisher<ReactiveSetCommands.SUnionCommand>)Mono.just((Object)ReactiveSetCommands.SUnionCommand.keys(command.getKeys()))).next().flatMap(values -> {
                Mono result = cmd.sadd((Object)command.getKey(), (Object[])((List)values.getOutput()).stream().toArray(ByteBuffer[]::new));
                return result.map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveSetCommands.SUnionStoreCommand, Long>((ReactiveSetCommands.SUnionStoreCommand)command, (Long)value));
            });
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.MultiValueResponse<ReactiveSetCommands.SInterCommand, ByteBuffer>> sInter(Publisher<ReactiveSetCommands.SInterCommand> commands) {
        return this.getConnection().execute(cmd -> Flux.from((Publisher)commands).flatMap(command -> {
            Assert.notNull(command.getKeys(), (String)"Keys must not be null!");
            if (ClusterSlotHashUtil.isSameSlotForAllKeys(command.getKeys())) {
                return super.sInter((Publisher<ReactiveSetCommands.SInterCommand>)Mono.just((Object)command));
            }
            Mono sourceSet = cmd.smembers((Object)command.getKeys().get(0)).distinct().collectList();
            ArrayList<Mono> intersectingSets = new ArrayList<Mono>();
            for (int i = 1; i < command.getKeys().size(); ++i) {
                intersectingSets.add(cmd.smembers((Object)command.getKeys().get(i)).distinct().collectList());
            }
            Flux result = Flux.zip((Publisher)sourceSet, (Publisher)Flux.merge(intersectingSets), (source, intersecting) -> {
                source.retainAll((Collection<?>)intersecting);
                return source;
            });
            return result.map(value -> new ReactiveRedisConnection.MultiValueResponse((ReactiveSetCommands.SInterCommand)command, value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveSetCommands.SInterStoreCommand, Long>> sInterStore(Publisher<ReactiveSetCommands.SInterStoreCommand> commands) {
        return this.getConnection().execute(cmd -> Flux.from((Publisher)commands).flatMap(command -> {
            Assert.notNull(command.getKeys(), (String)"Source keys must not be null!");
            Assert.notNull((Object)command.getKey(), (String)"Destination key must not be null!");
            ArrayList<ByteBuffer> keys = new ArrayList<ByteBuffer>(command.getKeys());
            keys.add(command.getKey());
            if (ClusterSlotHashUtil.isSameSlotForAllKeys(keys)) {
                return super.sInterStore((Publisher<ReactiveSetCommands.SInterStoreCommand>)Mono.just((Object)command));
            }
            return this.sInter((Publisher<ReactiveSetCommands.SInterCommand>)Mono.just((Object)ReactiveSetCommands.SInterCommand.keys(command.getKeys()))).next().flatMap(values -> {
                Mono result = cmd.sadd((Object)command.getKey(), (Object[])((List)values.getOutput()).stream().toArray(ByteBuffer[]::new));
                return result.map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveSetCommands.SInterStoreCommand, Long>((ReactiveSetCommands.SInterStoreCommand)command, (Long)value));
            });
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.MultiValueResponse<ReactiveSetCommands.SDiffCommand, ByteBuffer>> sDiff(Publisher<ReactiveSetCommands.SDiffCommand> commands) {
        return this.getConnection().execute(cmd -> Flux.from((Publisher)commands).flatMap(command -> {
            Assert.notNull(command.getKeys(), (String)"Keys must not be null!");
            if (ClusterSlotHashUtil.isSameSlotForAllKeys(command.getKeys())) {
                return super.sDiff((Publisher<ReactiveSetCommands.SDiffCommand>)Mono.just((Object)command));
            }
            Mono sourceSet = cmd.smembers((Object)command.getKeys().get(0)).distinct().collectList();
            ArrayList<Mono> intersectingSets = new ArrayList<Mono>();
            for (int i = 1; i < command.getKeys().size(); ++i) {
                intersectingSets.add(cmd.smembers((Object)command.getKeys().get(i)).distinct().collectList());
            }
            Flux result = Flux.zip((Publisher)sourceSet, (Publisher)Flux.merge(intersectingSets), (source, intersecting) -> {
                source.removeAll((Collection<?>)intersecting);
                return source;
            });
            return result.map(value -> new ReactiveRedisConnection.MultiValueResponse((ReactiveSetCommands.SDiffCommand)command, value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveSetCommands.SDiffStoreCommand, Long>> sDiffStore(Publisher<ReactiveSetCommands.SDiffStoreCommand> commands) {
        return this.getConnection().execute(cmd -> Flux.from((Publisher)commands).flatMap(command -> {
            Assert.notNull(command.getKeys(), (String)"Source keys must not be null!");
            Assert.notNull((Object)command.getKey(), (String)"Destination key must not be null!");
            ArrayList<ByteBuffer> keys = new ArrayList<ByteBuffer>(command.getKeys());
            keys.add(command.getKey());
            if (ClusterSlotHashUtil.isSameSlotForAllKeys(keys)) {
                return super.sDiffStore((Publisher<ReactiveSetCommands.SDiffStoreCommand>)Mono.just((Object)command));
            }
            return this.sDiff((Publisher<ReactiveSetCommands.SDiffCommand>)Mono.just((Object)ReactiveSetCommands.SDiffCommand.keys(command.getKeys()))).next().flatMap(values -> {
                Mono result = cmd.sadd((Object)command.getKey(), (Object[])((List)values.getOutput()).stream().toArray(ByteBuffer[]::new));
                return result.map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveSetCommands.SDiffStoreCommand, Long>((ReactiveSetCommands.SDiffStoreCommand)command, (Long)value));
            });
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveSetCommands.SMoveCommand>> sMove(Publisher<ReactiveSetCommands.SMoveCommand> commands) {
        return this.getConnection().execute(cmd -> Flux.from((Publisher)commands).flatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Source key must not be null!");
            Assert.notNull((Object)command.getDestination(), (String)"Destination key must not be null!");
            if (ClusterSlotHashUtil.isSameSlotForAllKeys(command.getKey(), command.getDestination())) {
                return super.sMove((Publisher<ReactiveSetCommands.SMoveCommand>)Mono.just((Object)command));
            }
            Flux result = cmd.exists((Object[])new ByteBuffer[]{command.getKey()}).flatMap(nrKeys -> nrKeys == 0L ? Mono.empty() : cmd.sismember((Object)command.getKey(), (Object)command.getValue())).flatMap(exists -> {
                if (!exists.booleanValue()) {
                    return Mono.just((Object)Boolean.FALSE);
                }
                return cmd.sismember((Object)command.getDestination(), (Object)command.getValue()).flatMap(existsInTarget -> {
                    Mono tmp = cmd.srem((Object)command.getKey(), (Object[])new ByteBuffer[]{command.getValue()}).map(nrRemoved -> nrRemoved > 0L);
                    if (!existsInTarget.booleanValue()) {
                        return tmp.flatMap(removed -> cmd.sadd((Object)command.getDestination(), (Object[])new ByteBuffer[]{command.getValue()}).map(Converters::toBoolean));
                    }
                    return tmp;
                });
            });
            return result.defaultIfEmpty((Object)Boolean.FALSE).map(value -> new ReactiveRedisConnection.BooleanResponse<ReactiveSetCommands.SMoveCommand>((ReactiveSetCommands.SMoveCommand)command, (Boolean)value));
        }));
    }
}

