/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import java.nio.ByteBuffer;
import java.util.Collections;
import org.reactivestreams.Publisher;
import org.springframework.data.redis.connection.ReactiveRedisConnection;
import org.springframework.data.redis.connection.ReactiveSetCommands;
import org.springframework.data.redis.connection.lettuce.LettuceReactiveRedisConnection;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class LettuceReactiveSetCommands
implements ReactiveSetCommands {
    private final LettuceReactiveRedisConnection connection;

    public LettuceReactiveSetCommands(LettuceReactiveRedisConnection connection) {
        Assert.notNull((Object)connection, (String)"Connection must not be null!");
        this.connection = connection;
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveSetCommands.SAddCommand, Long>> sAdd(Publisher<ReactiveSetCommands.SAddCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).flatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull(command.getValues(), (String)"Values must not be null!");
            return cmd.sadd((Object)command.getKey(), (Object[])command.getValues().stream().toArray(ByteBuffer[]::new)).map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveSetCommands.SAddCommand, Long>((ReactiveSetCommands.SAddCommand)command, (Long)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveSetCommands.SRemCommand, Long>> sRem(Publisher<ReactiveSetCommands.SRemCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).flatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull(command.getValues(), (String)"Values must not be null!");
            return cmd.srem((Object)command.getKey(), (Object[])command.getValues().stream().toArray(ByteBuffer[]::new)).map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveSetCommands.SRemCommand, Long>((ReactiveSetCommands.SRemCommand)command, (Long)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.ByteBufferResponse<ReactiveRedisConnection.KeyCommand>> sPop(Publisher<ReactiveRedisConnection.KeyCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).flatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            return cmd.spop((Object)command.getKey()).map(value -> new ReactiveRedisConnection.ByteBufferResponse<ReactiveRedisConnection.KeyCommand>((ReactiveRedisConnection.KeyCommand)command, (ByteBuffer)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveSetCommands.SMoveCommand>> sMove(Publisher<ReactiveSetCommands.SMoveCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).flatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull((Object)command.getDestination(), (String)"Destination key must not be null!");
            Assert.notNull((Object)command.getValue(), (String)"Value must not be null!");
            return cmd.smove((Object)command.getKey(), (Object)command.getDestination(), (Object)command.getValue()).map(value -> new ReactiveRedisConnection.BooleanResponse<ReactiveSetCommands.SMoveCommand>((ReactiveSetCommands.SMoveCommand)command, (Boolean)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveRedisConnection.KeyCommand, Long>> sCard(Publisher<ReactiveRedisConnection.KeyCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).flatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            return cmd.scard((Object)command.getKey()).map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveRedisConnection.KeyCommand, Long>((ReactiveRedisConnection.KeyCommand)command, (Long)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveSetCommands.SIsMemberCommand>> sIsMember(Publisher<ReactiveSetCommands.SIsMemberCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).flatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull((Object)command.getValue(), (String)"Value must not be null!");
            return cmd.sismember((Object)command.getKey(), (Object)command.getValue()).map(value -> new ReactiveRedisConnection.BooleanResponse<ReactiveSetCommands.SIsMemberCommand>((ReactiveSetCommands.SIsMemberCommand)command, (Boolean)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.MultiValueResponse<ReactiveSetCommands.SInterCommand, ByteBuffer>> sInter(Publisher<ReactiveSetCommands.SInterCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).flatMap(command -> {
            Assert.notNull(command.getKeys(), (String)"Keys must not be null!");
            return cmd.sinter((Object[])command.getKeys().stream().toArray(ByteBuffer[]::new)).collectList().map(value -> new ReactiveRedisConnection.MultiValueResponse((ReactiveSetCommands.SInterCommand)command, value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveSetCommands.SInterStoreCommand, Long>> sInterStore(Publisher<ReactiveSetCommands.SInterStoreCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).flatMap(command -> {
            Assert.notNull(command.getKeys(), (String)"Keys must not be null!");
            Assert.notNull((Object)command.getKey(), (String)"Destination key must not be null!");
            return cmd.sinterstore((Object)command.getKey(), (Object[])command.getKeys().stream().toArray(ByteBuffer[]::new)).map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveSetCommands.SInterStoreCommand, Long>((ReactiveSetCommands.SInterStoreCommand)command, (Long)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.MultiValueResponse<ReactiveSetCommands.SUnionCommand, ByteBuffer>> sUnion(Publisher<ReactiveSetCommands.SUnionCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).flatMap(command -> {
            Assert.notNull(command.getKeys(), (String)"Keys must not be null!");
            return cmd.sunion((Object[])command.getKeys().stream().toArray(ByteBuffer[]::new)).collectList().map(value -> new ReactiveRedisConnection.MultiValueResponse((ReactiveSetCommands.SUnionCommand)command, value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveSetCommands.SUnionStoreCommand, Long>> sUnionStore(Publisher<ReactiveSetCommands.SUnionStoreCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).flatMap(command -> {
            Assert.notNull(command.getKeys(), (String)"Keys must not be null!");
            Assert.notNull((Object)command.getKey(), (String)"Destination key must not be null!");
            return cmd.sunionstore((Object)command.getKey(), (Object[])command.getKeys().stream().toArray(ByteBuffer[]::new)).map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveSetCommands.SUnionStoreCommand, Long>((ReactiveSetCommands.SUnionStoreCommand)command, (Long)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.MultiValueResponse<ReactiveSetCommands.SDiffCommand, ByteBuffer>> sDiff(Publisher<ReactiveSetCommands.SDiffCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).flatMap(command -> {
            Assert.notNull(command.getKeys(), (String)"Keys must not be null!");
            return cmd.sdiff((Object[])command.getKeys().stream().toArray(ByteBuffer[]::new)).collectList().map(value -> new ReactiveRedisConnection.MultiValueResponse((ReactiveSetCommands.SDiffCommand)command, value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveSetCommands.SDiffStoreCommand, Long>> sDiffStore(Publisher<ReactiveSetCommands.SDiffStoreCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).flatMap(command -> {
            Assert.notNull(command.getKeys(), (String)"Keys must not be null!");
            Assert.notNull((Object)command.getKey(), (String)"Destination key must not be null!");
            return cmd.sdiffstore((Object)command.getKey(), (Object[])command.getKeys().stream().toArray(ByteBuffer[]::new)).map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveSetCommands.SDiffStoreCommand, Long>((ReactiveSetCommands.SDiffStoreCommand)command, (Long)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.MultiValueResponse<ReactiveRedisConnection.KeyCommand, ByteBuffer>> sMembers(Publisher<ReactiveRedisConnection.KeyCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).flatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            return cmd.smembers((Object)command.getKey()).collectList().map(value -> new ReactiveRedisConnection.MultiValueResponse((ReactiveRedisConnection.KeyCommand)command, value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.MultiValueResponse<ReactiveSetCommands.SRandMembersCommand, ByteBuffer>> sRandMember(Publisher<ReactiveSetCommands.SRandMembersCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).flatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            boolean singleElement = !command.getCount().isPresent() || command.getCount().get().equals(1L);
            Mono result = singleElement ? cmd.srandmember((Object)command.getKey()).map(Collections::singletonList) : cmd.srandmember((Object)command.getKey(), command.getCount().get().longValue()).collectList();
            return result.map(value -> new ReactiveRedisConnection.MultiValueResponse((ReactiveSetCommands.SRandMembersCommand)command, value));
        }));
    }

    protected LettuceReactiveRedisConnection getConnection() {
        return this.connection;
    }
}

