/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import com.lambdaworks.redis.Range;
import com.lambdaworks.redis.ScoredValue;
import com.lambdaworks.redis.ZAddArgs;
import com.lambdaworks.redis.ZStoreArgs;
import com.lambdaworks.redis.codec.StringCodec;
import com.lambdaworks.redis.protocol.LettuceCharsets;
import java.nio.ByteBuffer;
import java.util.List;
import org.reactivestreams.Publisher;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.domain.Sort;
import org.springframework.data.redis.connection.DefaultTuple;
import org.springframework.data.redis.connection.ReactiveRedisConnection;
import org.springframework.data.redis.connection.ReactiveZSetCommands;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.connection.lettuce.LettuceConverters;
import org.springframework.data.redis.connection.lettuce.LettuceReactiveRedisConnection;
import org.springframework.data.redis.util.ByteUtils;
import org.springframework.data.util.DirectFieldAccessFallbackBeanWrapper;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class LettuceReactiveZSetCommands
implements ReactiveZSetCommands {
    private final LettuceReactiveRedisConnection connection;

    public LettuceReactiveZSetCommands(LettuceReactiveRedisConnection connection) {
        Assert.notNull((Object)connection, (String)"Connection must not be null!");
        this.connection = connection;
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZAddCommand, Number>> zAdd(Publisher<ReactiveZSetCommands.ZAddCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).flatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notEmpty(command.getTuples(), (String)"Tuples must not be empty or null!");
            ZAddArgs args = null;
            if (command.isIncr() || command.isUpsert() || command.isReturnTotalChanged()) {
                if (command.isIncr()) {
                    if (command.getTuples().size() > 1) {
                        throw new IllegalArgumentException("ZADD INCR must not contain more than one tuple!");
                    }
                    RedisZSetCommands.Tuple tuple2 = command.getTuples().iterator().next();
                    return cmd.zaddincr((Object)command.getKey(), tuple2.getScore().doubleValue(), (Object)ByteBuffer.wrap(tuple2.getValue())).map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZAddCommand, Double>((ReactiveZSetCommands.ZAddCommand)command, (Double)value));
                }
                if (command.isReturnTotalChanged()) {
                    args = ZAddArgs.Builder.ch();
                }
                args = command.isUpsert() ? ZAddArgs.Builder.nx() : ZAddArgs.Builder.xx();
            }
            ScoredValue[] values = (ScoredValue[])command.getTuples().stream().map(tuple -> ScoredValue.fromNullable((double)tuple.getScore(), (Object)ByteBuffer.wrap(tuple.getValue()))).toArray(ScoredValue[]::new);
            Mono result = args == null ? cmd.zadd((Object)command.getKey(), values) : cmd.zadd((Object)command.getKey(), args, values);
            return result.map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZAddCommand, Long>((ReactiveZSetCommands.ZAddCommand)command, (Long)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZRemCommand, Long>> zRem(Publisher<ReactiveZSetCommands.ZRemCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).flatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notEmpty(command.getValues(), (String)"Values must not be null or empty!");
            return cmd.zrem((Object)command.getKey(), (Object[])command.getValues().stream().toArray(ByteBuffer[]::new)).map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZRemCommand, Long>((ReactiveZSetCommands.ZRemCommand)command, (Long)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZIncrByCommand, Double>> zIncrBy(Publisher<ReactiveZSetCommands.ZIncrByCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).flatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull((Object)command.getValue(), (String)"Member must not be null!");
            Assert.notNull((Object)command.getIncrement(), (String)"Increment value must not be null!");
            return cmd.zincrby((Object)command.getKey(), command.getIncrement().doubleValue(), (Object)command.getValue()).map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZIncrByCommand, Double>((ReactiveZSetCommands.ZIncrByCommand)command, (Double)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZRankCommand, Long>> zRank(Publisher<ReactiveZSetCommands.ZRankCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).flatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull((Object)command.getValue(), (String)"Value must not be null!");
            Mono result = ObjectUtils.nullSafeEquals((Object)command.getDirection(), (Object)Sort.Direction.ASC) ? cmd.zrank((Object)command.getKey(), (Object)command.getValue()) : cmd.zrevrank((Object)command.getKey(), (Object)command.getValue());
            return result.map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZRankCommand, Long>((ReactiveZSetCommands.ZRankCommand)command, (Long)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.MultiValueResponse<ReactiveZSetCommands.ZRangeCommand, RedisZSetCommands.Tuple>> zRange(Publisher<ReactiveZSetCommands.ZRangeCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).flatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull(command.getRange(), (String)"Range must not be null!");
            Mono result = ObjectUtils.nullSafeEquals((Object)command.getDirection(), (Object)Sort.Direction.ASC) ? (command.isWithScores() ? cmd.zrangeWithScores((Object)command.getKey(), ((Long)command.getRange().getLowerBound()).longValue(), ((Long)command.getRange().getUpperBound()).longValue()).map(sc -> new DefaultTuple(LettuceReactiveZSetCommands.getBytes((ScoredValue<ByteBuffer>)sc), sc.getScore())).collectList() : cmd.zrange((Object)command.getKey(), ((Long)command.getRange().getLowerBound()).longValue(), ((Long)command.getRange().getUpperBound()).longValue()).map(value -> new DefaultTuple(ByteUtils.getBytes(value), Double.NaN)).collectList()) : (command.isWithScores() ? cmd.zrevrangeWithScores((Object)command.getKey(), ((Long)command.getRange().getLowerBound()).longValue(), ((Long)command.getRange().getUpperBound()).longValue()).map(sc -> new DefaultTuple(LettuceReactiveZSetCommands.getBytes((ScoredValue<ByteBuffer>)sc), sc.getScore())).collectList() : cmd.zrevrange((Object)command.getKey(), ((Long)command.getRange().getLowerBound()).longValue(), ((Long)command.getRange().getUpperBound()).longValue()).map(value -> new DefaultTuple(ByteUtils.getBytes(value), Double.NaN)).collectList());
            return result.map(value -> new ReactiveRedisConnection.MultiValueResponse((ReactiveZSetCommands.ZRangeCommand)command, value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.MultiValueResponse<ReactiveZSetCommands.ZRangeByScoreCommand, RedisZSetCommands.Tuple>> zRangeByScore(Publisher<ReactiveZSetCommands.ZRangeByScoreCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).flatMap(command -> {
            Mono result;
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull(command.getRange(), (String)"Range must not be null!");
            boolean isLimited = command.getLimit().isPresent();
            if (ObjectUtils.nullSafeEquals((Object)command.getDirection(), (Object)Sort.Direction.ASC)) {
                Range range = ArgumentConverters.toRange(command.getRange());
                result = command.isWithScores() ? (!isLimited ? cmd.zrangebyscoreWithScores((Object)command.getKey(), range).map(sc -> new DefaultTuple(ByteUtils.getBytes((ByteBuffer)sc.getValue()), sc.getScore())).collectList() : cmd.zrangebyscoreWithScores((Object)command.getKey(), range, LettuceConverters.toLimit(command.getLimit().get())).map(sc -> new DefaultTuple(ByteUtils.getBytes((ByteBuffer)sc.getValue()), sc.getScore())).collectList()) : (!isLimited ? cmd.zrangebyscore((Object)command.getKey(), range).map(value -> new DefaultTuple(ByteUtils.getBytes(value), Double.NaN)).collectList() : cmd.zrangebyscore((Object)command.getKey(), range, LettuceConverters.toLimit(command.getLimit().get())).map(value -> new DefaultTuple(ByteUtils.getBytes(value), Double.NaN)).collectList());
            } else {
                Range range = ArgumentConverters.toRange(command.getRange());
                result = command.isWithScores() ? (!isLimited ? cmd.zrevrangebyscoreWithScores((Object)command.getKey(), range).map(sc -> new DefaultTuple(ByteUtils.getBytes((ByteBuffer)sc.getValue()), sc.getScore())).collectList() : cmd.zrevrangebyscoreWithScores((Object)command.getKey(), range, LettuceConverters.toLimit(command.getLimit().get())).map(sc -> new DefaultTuple(ByteUtils.getBytes((ByteBuffer)sc.getValue()), sc.getScore())).collectList()) : (!isLimited ? cmd.zrevrangebyscore((Object)command.getKey(), range).map(value -> new DefaultTuple(ByteUtils.getBytes(value), Double.NaN)).collectList() : cmd.zrevrangebyscore((Object)command.getKey(), range, LettuceConverters.toLimit(command.getLimit().get())).map(value -> new DefaultTuple(ByteUtils.getBytes(value), Double.NaN)).collectList());
            }
            return result.map(value -> new ReactiveRedisConnection.MultiValueResponse((ReactiveZSetCommands.ZRangeByScoreCommand)command, value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZCountCommand, Long>> zCount(Publisher<ReactiveZSetCommands.ZCountCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).flatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull(command.getRange(), (String)"Range must not be null!");
            Range range = ArgumentConverters.toRange(command.getRange());
            Mono result = cmd.zcount((Object)command.getKey(), range);
            return result.map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZCountCommand, Long>((ReactiveZSetCommands.ZCountCommand)command, (Long)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveRedisConnection.KeyCommand, Long>> zCard(Publisher<ReactiveRedisConnection.KeyCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).flatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            return cmd.zcard((Object)command.getKey()).map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveRedisConnection.KeyCommand, Long>((ReactiveRedisConnection.KeyCommand)command, (Long)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZScoreCommand, Double>> zScore(Publisher<ReactiveZSetCommands.ZScoreCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).flatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull((Object)command.getValue(), (String)"Value must not be null!");
            return cmd.zscore((Object)command.getKey(), (Object)command.getValue()).map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZScoreCommand, Double>((ReactiveZSetCommands.ZScoreCommand)command, (Double)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZRemRangeByRankCommand, Long>> zRemRangeByRank(Publisher<ReactiveZSetCommands.ZRemRangeByRankCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).flatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull(command.getRange(), (String)"Range must not be null!");
            return cmd.zremrangebyrank((Object)command.getKey(), ((Long)command.getRange().getLowerBound()).longValue(), ((Long)command.getRange().getUpperBound()).longValue()).map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZRemRangeByRankCommand, Long>((ReactiveZSetCommands.ZRemRangeByRankCommand)command, (Long)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZRemRangeByScoreCommand, Long>> zRemRangeByScore(Publisher<ReactiveZSetCommands.ZRemRangeByScoreCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).flatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull(command.getRange(), (String)"Range must not be null!");
            Range range = ArgumentConverters.toRange(command.getRange());
            Mono result = cmd.zremrangebyscore((Object)command.getKey(), range);
            return result.map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZRemRangeByScoreCommand, Long>((ReactiveZSetCommands.ZRemRangeByScoreCommand)command, (Long)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZUnionStoreCommand, Long>> zUnionStore(Publisher<ReactiveZSetCommands.ZUnionStoreCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).flatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Destination key must not be null!");
            Assert.notEmpty(command.getSourceKeys(), (String)"Source keys must not be null or empty!");
            ZStoreArgs args = null;
            if (command.getAggregateFunction().isPresent() || !command.getWeights().isEmpty()) {
                args = this.zStoreArgs(command.getAggregateFunction().isPresent() ? command.getAggregateFunction().get() : null, command.getWeights());
            }
            Object[] sourceKeys = (ByteBuffer[])command.getSourceKeys().stream().toArray(ByteBuffer[]::new);
            Mono result = args != null ? cmd.zunionstore((Object)command.getKey(), args, sourceKeys) : cmd.zunionstore((Object)command.getKey(), sourceKeys);
            return result.map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZUnionStoreCommand, Long>((ReactiveZSetCommands.ZUnionStoreCommand)command, (Long)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZInterStoreCommand, Long>> zInterStore(Publisher<ReactiveZSetCommands.ZInterStoreCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).flatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Destination key must not be null!");
            Assert.notEmpty(command.getSourceKeys(), (String)"Source keys must not be null or empty!");
            ZStoreArgs args = null;
            if (command.getAggregateFunction().isPresent() || !command.getWeights().isEmpty()) {
                args = this.zStoreArgs(command.getAggregateFunction().isPresent() ? command.getAggregateFunction().get() : null, command.getWeights());
            }
            Object[] sourceKeys = (ByteBuffer[])command.getSourceKeys().stream().toArray(ByteBuffer[]::new);
            Mono result = args != null ? cmd.zinterstore((Object)command.getKey(), args, sourceKeys) : cmd.zinterstore((Object)command.getKey(), sourceKeys);
            return result.map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZInterStoreCommand, Long>((ReactiveZSetCommands.ZInterStoreCommand)command, (Long)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.MultiValueResponse<ReactiveZSetCommands.ZRangeByLexCommand, ByteBuffer>> zRangeByLex(Publisher<ReactiveZSetCommands.ZRangeByLexCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).flatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Destination key must not be null!");
            Flux result = command.getLimit() != null ? (ObjectUtils.nullSafeEquals((Object)command.getDirection(), (Object)Sort.Direction.ASC) ? cmd.zrangebylex((Object)command.getKey(), ArgumentConverters.toRange(command.getRange()), LettuceConverters.toLimit(command.getLimit())) : cmd.zrevrangebylex((Object)command.getKey(), ArgumentConverters.toRange(command.getRange()), LettuceConverters.toLimit(command.getLimit()))) : (ObjectUtils.nullSafeEquals((Object)command.getDirection(), (Object)Sort.Direction.ASC) ? cmd.zrangebylex((Object)command.getKey(), ArgumentConverters.toRange(command.getRange())) : cmd.zrevrangebylex((Object)command.getKey(), ArgumentConverters.toRange(command.getRange())));
            return result.collectList().map(value -> new ReactiveRedisConnection.MultiValueResponse((ReactiveZSetCommands.ZRangeByLexCommand)command, value));
        }));
    }

    private ZStoreArgs zStoreArgs(RedisZSetCommands.Aggregate aggregate, List<Double> weights) {
        ZStoreArgs args = new ZStoreArgs();
        if (aggregate != null) {
            switch (aggregate) {
                case MIN: {
                    args.min();
                    break;
                }
                case MAX: {
                    args.max();
                    break;
                }
                default: {
                    args.sum();
                }
            }
        }
        if (weights != null) {
            double[] lg = new double[weights.size()];
            for (int i = 0; i < lg.length; ++i) {
                lg[i] = weights.get(i).longValue();
            }
            args.weights(lg);
        }
        return args;
    }

    private static byte[] getBytes(ScoredValue<ByteBuffer> scoredValue) {
        return scoredValue.optional().map(ByteUtils::getBytes).orElse(new byte[0]);
    }

    protected LettuceReactiveRedisConnection getConnection() {
        return this.connection;
    }

    private static class ArgumentConverters {
        private ArgumentConverters() {
        }

        static <T> Range<T> toRange(org.springframework.data.domain.Range<?> range) {
            return Range.from(ArgumentConverters.lowerBoundArgOf(range), ArgumentConverters.upperBoundArgOf(range));
        }

        static <T> Range.Boundary<T> lowerBoundArgOf(org.springframework.data.domain.Range<?> range) {
            return (Range.Boundary)ArgumentConverters.rangeToBoundArgumentConverter(false).convert(range);
        }

        static <T> Range.Boundary<T> upperBoundArgOf(org.springframework.data.domain.Range<?> range) {
            return (Range.Boundary)ArgumentConverters.rangeToBoundArgumentConverter(true).convert(range);
        }

        private static Converter<org.springframework.data.domain.Range<?>, Range.Boundary<?>> rangeToBoundArgumentConverter(Boolean upper) {
            return source -> {
                Comparable value;
                DirectFieldAccessFallbackBeanWrapper bw = new DirectFieldAccessFallbackBeanWrapper(source);
                Boolean inclusive = upper != false ? Boolean.valueOf(bw.getPropertyValue("upperInclusive").toString()) : Boolean.valueOf(bw.getPropertyValue("lowerInclusive").toString());
                Comparable comparable = value = upper != false ? source.getUpperBound() : source.getLowerBound();
                if (value instanceof Number) {
                    return inclusive != false ? Range.Boundary.including((Object)((Number)((Object)value))) : Range.Boundary.excluding((Object)((Number)((Object)value)));
                }
                if (value instanceof String) {
                    StringCodec stringCodec = new StringCodec(LettuceCharsets.UTF8);
                    if (!StringUtils.hasText((String)((String)((Object)value))) || ObjectUtils.nullSafeEquals((Object)value, (Object)"+") || ObjectUtils.nullSafeEquals((Object)value, (Object)"-")) {
                        return Range.Boundary.unbounded();
                    }
                    return inclusive != false ? Range.Boundary.including((Object)stringCodec.encodeValue((String)((Object)value))) : Range.Boundary.excluding((Object)stringCodec.encodeValue((String)((Object)value)));
                }
                return inclusive != false ? Range.Boundary.including((Object)((ByteBuffer)value)) : Range.Boundary.excluding((Object)((ByteBuffer)value));
            };
        }
    }
}

