/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisClusterCommands;
import org.springframework.data.redis.connection.RedisClusterConnection;
import org.springframework.data.redis.connection.RedisClusterNode;
import org.springframework.data.redis.connection.RedisServerCommands;
import org.springframework.data.redis.core.AbstractOperations;
import org.springframework.data.redis.core.ClusterOperations;
import org.springframework.data.redis.core.RedisClusterCallback;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.util.Assert;

public class DefaultClusterOperations<K, V>
extends AbstractOperations<K, V>
implements ClusterOperations<K, V> {
    private final RedisTemplate<K, V> template;

    public DefaultClusterOperations(RedisTemplate<K, V> template) {
        super(template);
        this.template = template;
    }

    @Override
    public Set<K> keys(final RedisClusterNode node, final K pattern) {
        Assert.notNull((Object)node, (String)"ClusterNode must not be null.");
        return (Set)this.execute(new RedisClusterCallback<Set<K>>(){

            @Override
            public Set<K> doInRedis(RedisClusterConnection connection) throws DataAccessException {
                return DefaultClusterOperations.this.deserializeKeys(connection.keys(node, DefaultClusterOperations.this.rawKey(pattern)));
            }
        });
    }

    @Override
    public K randomKey(final RedisClusterNode node) {
        Assert.notNull((Object)node, (String)"ClusterNode must not be null.");
        return (K)this.execute(new RedisClusterCallback<K>(){

            @Override
            public K doInRedis(RedisClusterConnection connection) throws DataAccessException {
                return DefaultClusterOperations.this.deserializeKey(connection.randomKey(node));
            }
        });
    }

    @Override
    public String ping(final RedisClusterNode node) {
        Assert.notNull((Object)node, (String)"ClusterNode must not be null.");
        return this.execute(new RedisClusterCallback<String>(){

            @Override
            public String doInRedis(RedisClusterConnection connection) throws DataAccessException {
                return connection.ping(node);
            }
        });
    }

    @Override
    public void addSlots(final RedisClusterNode node, final int ... slots) {
        Assert.notNull((Object)node, (String)"ClusterNode must not be null.");
        this.execute(new RedisClusterCallback<Void>(){

            @Override
            public Void doInRedis(RedisClusterConnection connection) throws DataAccessException {
                connection.clusterAddSlots(node, slots);
                return null;
            }
        });
    }

    @Override
    public void addSlots(RedisClusterNode node, RedisClusterNode.SlotRange range) {
        Assert.notNull((Object)node, (String)"ClusterNode must not be null.");
        Assert.notNull((Object)range, (String)"Range must not be null.");
        this.addSlots(node, range.getSlotsArray());
    }

    @Override
    public void bgReWriteAof(final RedisClusterNode node) {
        Assert.notNull((Object)node, (String)"ClusterNode must not be null.");
        this.execute(new RedisClusterCallback<Void>(){

            @Override
            public Void doInRedis(RedisClusterConnection connection) throws DataAccessException {
                connection.bgReWriteAof(node);
                return null;
            }
        });
    }

    @Override
    public void bgSave(final RedisClusterNode node) {
        Assert.notNull((Object)node, (String)"ClusterNode must not be null.");
        this.execute(new RedisClusterCallback<Void>(){

            @Override
            public Void doInRedis(RedisClusterConnection connection) throws DataAccessException {
                connection.bgSave(node);
                return null;
            }
        });
    }

    @Override
    public void meet(final RedisClusterNode node) {
        Assert.notNull((Object)node, (String)"ClusterNode must not be null.");
        this.execute(new RedisClusterCallback<Void>(){

            @Override
            public Void doInRedis(RedisClusterConnection connection) throws DataAccessException {
                connection.clusterMeet(node);
                return null;
            }
        });
    }

    @Override
    public void forget(final RedisClusterNode node) {
        Assert.notNull((Object)node, (String)"ClusterNode must not be null.");
        this.execute(new RedisClusterCallback<Void>(){

            @Override
            public Void doInRedis(RedisClusterConnection connection) throws DataAccessException {
                connection.clusterForget(node);
                return null;
            }
        });
    }

    @Override
    public void flushDb(final RedisClusterNode node) {
        Assert.notNull((Object)node, (String)"ClusterNode must not be null.");
        this.execute(new RedisClusterCallback<Void>(){

            @Override
            public Void doInRedis(RedisClusterConnection connection) throws DataAccessException {
                connection.flushDb(node);
                return null;
            }
        });
    }

    @Override
    public Collection<RedisClusterNode> getSlaves(final RedisClusterNode node) {
        Assert.notNull((Object)node, (String)"ClusterNode must not be null.");
        return this.execute(new RedisClusterCallback<Collection<RedisClusterNode>>(){

            @Override
            public Collection<RedisClusterNode> doInRedis(RedisClusterConnection connection) throws DataAccessException {
                return connection.clusterGetSlaves(node);
            }
        });
    }

    @Override
    public void save(final RedisClusterNode node) {
        Assert.notNull((Object)node, (String)"ClusterNode must not be null.");
        this.execute(new RedisClusterCallback<Void>(){

            @Override
            public Void doInRedis(RedisClusterConnection connection) throws DataAccessException {
                connection.save(node);
                return null;
            }
        });
    }

    @Override
    public void shutdown(final RedisClusterNode node) {
        Assert.notNull((Object)node, (String)"ClusterNode must not be null.");
        this.execute(new RedisClusterCallback<Void>(){

            @Override
            public Void doInRedis(RedisClusterConnection connection) throws DataAccessException {
                connection.shutdown(node);
                return null;
            }
        });
    }

    @Override
    public void reshard(final RedisClusterNode source, final int slot, final RedisClusterNode target) {
        Assert.notNull((Object)source, (String)"Source node must not be null.");
        Assert.notNull((Object)target, (String)"Target node must not be null.");
        this.execute(new RedisClusterCallback<Void>(){

            @Override
            public Void doInRedis(RedisClusterConnection connection) throws DataAccessException {
                connection.clusterSetSlot(target, slot, RedisClusterCommands.AddSlots.IMPORTING);
                connection.clusterSetSlot(source, slot, RedisClusterCommands.AddSlots.MIGRATING);
                List<byte[]> keys = connection.clusterGetKeysInSlot(slot, Integer.MAX_VALUE);
                for (byte[] key : keys) {
                    connection.migrate(key, source, 0, RedisServerCommands.MigrateOption.COPY);
                }
                connection.clusterSetSlot(target, slot, RedisClusterCommands.AddSlots.NODE);
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T execute(RedisClusterCallback<T> callback) {
        Assert.notNull(callback, (String)"ClusterCallback must not be null!");
        try (RedisClusterConnection connection = this.template.getConnectionFactory().getClusterConnection();){
            T t = callback.doInRedis(connection);
            return t;
        }
    }
}

