/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.springframework.data.domain.Range;
import org.springframework.data.redis.connection.DefaultTuple;
import org.springframework.data.redis.connection.ReactiveRedisConnection;
import org.springframework.data.redis.connection.ReactiveZSetCommands;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.core.DefaultTypedTuple;
import org.springframework.data.redis.core.ReactiveRedisTemplate;
import org.springframework.data.redis.core.ReactiveZSetOperations;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.data.redis.util.ByteUtils;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DefaultReactiveZSetOperations<K, V>
implements ReactiveZSetOperations<K, V> {
    private final ReactiveRedisTemplate<?, ?> template;
    private final RedisSerializationContext<K, V> serializationContext;

    public DefaultReactiveZSetOperations(ReactiveRedisTemplate<?, ?> template, RedisSerializationContext<K, V> serializationContext) {
        Assert.notNull(template, (String)"ReactiveRedisTemplate must not be null!");
        Assert.notNull(serializationContext, (String)"RedisSerializationContext must not be null!");
        this.template = template;
        this.serializationContext = serializationContext;
    }

    @Override
    public Mono<Boolean> add(K key, V value, double score) {
        Assert.notNull(key, (String)"Key must not be null!");
        return this.createMono(connection -> connection.zAdd(this.rawKey(key), score, this.rawValue(value)).map(l -> l != 0L));
    }

    @Override
    public Mono<Long> addAll(K key, Collection<? extends ZSetOperations.TypedTuple<V>> tuples) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.notNull(tuples, (String)"Key must not be null!");
        return this.createMono(connection -> Flux.fromIterable((Iterable)tuples).map(t -> new DefaultTuple(ByteUtils.getBytes(this.rawValue(t.getValue())), t.getScore())).collectList().flatMap(serialized -> connection.zAdd(this.rawKey(key), (Collection<? extends RedisZSetCommands.Tuple>)serialized)));
    }

    @Override
    public Mono<Long> remove(K key, Object ... values) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.notNull((Object)values, (String)"Values must not be null!");
        if (values.length == 1) {
            return this.createMono(connection -> connection.zRem(this.rawKey(key), this.rawValue(values[0])));
        }
        return this.createMono(connection -> Flux.fromArray((Object[])values).map(this::rawValue).collectList().flatMap(serialized -> connection.zRem(this.rawKey(key), (Collection<ByteBuffer>)serialized)));
    }

    @Override
    public Mono<Double> incrementScore(K key, V value, double delta) {
        Assert.notNull(key, (String)"Key must not be null!");
        return this.createMono(connection -> connection.zIncrBy(this.rawKey(key), delta, this.rawValue(value)));
    }

    @Override
    public Mono<Long> rank(K key, Object o) {
        Assert.notNull(key, (String)"Key must not be null!");
        return this.createMono(connection -> connection.zRank(this.rawKey(key), this.rawValue(o)));
    }

    @Override
    public Mono<Long> reverseRank(K key, Object o) {
        Assert.notNull(key, (String)"Key must not be null!");
        return this.createMono(connection -> connection.zRevRank(this.rawKey(key), this.rawValue(o)));
    }

    @Override
    public Mono<Set<V>> range(K key, Range<Long> range) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.notNull(range, (String)"Range must not be null!");
        return this.createMono(connection -> connection.zRange(this.rawKey(key), range).map(this::readValueSet));
    }

    @Override
    public Mono<Set<ZSetOperations.TypedTuple<V>>> rangeWithScores(K key, Range<Long> range) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.notNull(range, (String)"Range must not be null!");
        return this.createMono(connection -> connection.zRangeWithScores(this.rawKey(key), range).map(this::readTypedTupleSet));
    }

    @Override
    public Mono<Set<V>> rangeByScore(K key, Range<Double> range) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.notNull(range, (String)"Range must not be null!");
        return this.createMono(connection -> connection.zRangeByScore(this.rawKey(key), range).map(this::readValueSet));
    }

    @Override
    public Mono<Set<ZSetOperations.TypedTuple<V>>> rangeByScoreWithScores(K key, Range<Double> range) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.notNull(range, (String)"Range must not be null!");
        return this.createMono(connection -> connection.zRangeByScoreWithScores(this.rawKey(key), range).map(this::readTypedTupleSet));
    }

    @Override
    public Mono<Set<V>> rangeByScore(K key, Range<Double> range, RedisZSetCommands.Limit limit) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.notNull(range, (String)"Range must not be null!");
        return this.createMono(connection -> connection.zRangeByScore(this.rawKey(key), range, limit).map(this::readValueSet));
    }

    @Override
    public Mono<Set<ZSetOperations.TypedTuple<V>>> rangeByScoreWithScores(K key, Range<Double> range, RedisZSetCommands.Limit limit) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.notNull(range, (String)"Range must not be null!");
        Assert.notNull((Object)limit, (String)"Limit must not be null!");
        return this.createMono(connection -> connection.zRangeByScoreWithScores(this.rawKey(key), range, limit).map(this::readTypedTupleSet));
    }

    @Override
    public Mono<Set<V>> reverseRange(K key, Range<Long> range) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.notNull(range, (String)"Range must not be null!");
        return this.createMono(connection -> connection.zRevRange(this.rawKey(key), range).map(this::readValueSet));
    }

    @Override
    public Mono<Set<ZSetOperations.TypedTuple<V>>> reverseRangeWithScores(K key, Range<Long> range) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.notNull(range, (String)"Range must not be null!");
        return this.createMono(connection -> connection.zRevRangeWithScores(this.rawKey(key), range).map(this::readTypedTupleSet));
    }

    @Override
    public Mono<Set<V>> reverseRangeByScore(K key, Range<Double> range) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.notNull(range, (String)"Range must not be null!");
        return this.createMono(connection -> connection.zRevRangeByScore(this.rawKey(key), range).map(this::readValueSet));
    }

    @Override
    public Mono<Set<ZSetOperations.TypedTuple<V>>> reverseRangeByScoreWithScores(K key, Range<Double> range) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.notNull(range, (String)"Range must not be null!");
        return this.createMono(connection -> connection.zRevRangeByScoreWithScores(this.rawKey(key), range).map(this::readTypedTupleSet));
    }

    @Override
    public Mono<Set<V>> reverseRangeByScore(K key, Range<Double> range, RedisZSetCommands.Limit limit) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.notNull(range, (String)"Range must not be null!");
        return this.createMono(connection -> connection.zRevRangeByScore(this.rawKey(key), range, limit).map(this::readValueSet));
    }

    @Override
    public Mono<Set<ZSetOperations.TypedTuple<V>>> reverseRangeByScoreWithScores(K key, Range<Double> range, RedisZSetCommands.Limit limit) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.notNull(range, (String)"Range must not be null!");
        Assert.notNull((Object)limit, (String)"Limit must not be null!");
        return this.createMono(connection -> connection.zRevRangeByScoreWithScores(this.rawKey(key), range, limit).map(this::readTypedTupleSet));
    }

    @Override
    public Mono<Long> count(K key, Range<Double> range) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.notNull(range, (String)"Range must not be null!");
        return this.createMono(connection -> connection.zCount(this.rawKey(key), range));
    }

    @Override
    public Mono<Long> size(K key) {
        Assert.notNull(key, (String)"Key must not be null!");
        return this.createMono(connection -> connection.zCard(this.rawKey(key)));
    }

    @Override
    public Mono<Double> score(K key, Object o) {
        Assert.notNull(key, (String)"Key must not be null!");
        return this.createMono(connection -> connection.zScore(this.rawKey(key), this.rawValue(o)));
    }

    @Override
    public Mono<Long> removeRange(K key, Range<Long> range) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.notNull(range, (String)"Range must not be null!");
        return this.createMono(connection -> connection.zRemRangeByRank(this.rawKey(key), range));
    }

    @Override
    public Mono<Long> removeRangeByScore(K key, Range<Double> range) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.notNull(range, (String)"Range must not be null!");
        return this.createMono(connection -> connection.zRemRangeByScore(this.rawKey(key), range));
    }

    @Override
    public Mono<Long> unionAndStore(K key, K otherKey, K destKey) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.notNull(otherKey, (String)"Other key must not be null!");
        Assert.notNull(destKey, (String)"Destination key must not be null!");
        return this.unionAndStore(key, (Collection<K>)Collections.singleton(otherKey), destKey);
    }

    @Override
    public Mono<Long> unionAndStore(K key, Collection<K> otherKeys, K destKey) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.notNull(otherKeys, (String)"Other keys must not be null!");
        Assert.notNull(destKey, (String)"Destination key must not be null!");
        return this.createMono(connection -> Flux.fromIterable(this.getKeys(key, otherKeys)).map(this::rawKey).collectList().flatMap(serialized -> connection.zUnionStore(this.rawKey(destKey), (List<ByteBuffer>)serialized)));
    }

    @Override
    public Mono<Long> intersectAndStore(K key, K otherKey, K destKey) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.notNull(otherKey, (String)"Other key must not be null!");
        Assert.notNull(destKey, (String)"Destination key must not be null!");
        return this.intersectAndStore(key, (Collection<K>)Collections.singleton(otherKey), destKey);
    }

    @Override
    public Mono<Long> intersectAndStore(K key, Collection<K> otherKeys, K destKey) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.notNull(otherKeys, (String)"Other keys must not be null!");
        Assert.notNull(destKey, (String)"Destination key must not be null!");
        return this.createMono(connection -> Flux.fromIterable(this.getKeys(key, otherKeys)).map(this::rawKey).collectList().flatMap(serialized -> connection.zInterStore(this.rawKey(destKey), (List<ByteBuffer>)serialized)));
    }

    @Override
    public Mono<Set<V>> rangeByLex(K key, Range<String> range) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.notNull(range, (String)"Range must not be null!");
        return this.createMono(connection -> connection.zRangeByLex(this.rawKey(key), range).map(this::readValueSet));
    }

    @Override
    public Mono<Set<V>> rangeByLex(K key, Range<String> range, RedisZSetCommands.Limit limit) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.notNull(range, (String)"Range must not be null!");
        Assert.notNull((Object)limit, (String)"Limit must not be null!");
        return this.createMono(connection -> connection.zRangeByLex(this.rawKey(key), range, limit).map(this::readValueSet));
    }

    @Override
    public Mono<Set<V>> reverseRangeByLex(K key, Range<String> range) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.notNull(range, (String)"Range must not be null!");
        return this.createMono(connection -> connection.zRevRangeByLex(this.rawKey(key), range).map(this::readValueSet));
    }

    @Override
    public Mono<Set<V>> reverseRangeByLex(K key, Range<String> range, RedisZSetCommands.Limit limit) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.notNull(range, (String)"Range must not be null!");
        Assert.notNull((Object)limit, (String)"Limit must not be null!");
        return this.createMono(connection -> connection.zRevRangeByLex(this.rawKey(key), range, limit).map(this::readValueSet));
    }

    @Override
    public Mono<Boolean> delete(K key) {
        Assert.notNull(key, (String)"Key must not be null!");
        return this.template.createMono((ReactiveRedisConnection connection) -> connection.keyCommands().del(this.rawKey(key))).map(l -> l != 0L);
    }

    private <T> Mono<T> createMono(Function<ReactiveZSetCommands, Publisher<T>> function) {
        Assert.notNull(function, (String)"Function must not be null!");
        return this.template.createMono((ReactiveRedisConnection connection) -> (Publisher)function.apply(connection.zSetCommands()));
    }

    private ByteBuffer rawKey(K key) {
        return this.serializationContext.getKeySerializationPair().write(key);
    }

    private List<K> getKeys(K key, Collection<K> otherKeys) {
        ArrayList<K> keys = new ArrayList<K>(1 + otherKeys.size());
        keys.add(key);
        keys.addAll(otherKeys);
        return keys;
    }

    private ByteBuffer rawValue(V value) {
        return this.serializationContext.getValueSerializationPair().write(value);
    }

    private V readValue(ByteBuffer buffer) {
        return this.serializationContext.getValueSerializationPair().read(buffer);
    }

    private Set<V> readValueSet(Collection<ByteBuffer> raw) {
        LinkedHashSet<V> result = new LinkedHashSet<V>(raw.size());
        for (ByteBuffer buffer : raw) {
            result.add(this.readValue(buffer));
        }
        return result;
    }

    private Set<ZSetOperations.TypedTuple<V>> readTypedTupleSet(Collection<RedisZSetCommands.Tuple> raw) {
        LinkedHashSet<ZSetOperations.TypedTuple<V>> result = new LinkedHashSet<ZSetOperations.TypedTuple<V>>(raw.size());
        for (RedisZSetCommands.Tuple tuple : raw) {
            result.add(new DefaultTypedTuple<V>(this.readValue(ByteBuffer.wrap(tuple.getValue())), tuple.getScore()));
        }
        return result;
    }
}

