/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core.types;

import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class Expiration {
    private long expirationTime;
    private TimeUnit timeUnit;

    protected Expiration(long expirationTime, TimeUnit timeUnit) {
        this.expirationTime = expirationTime;
        this.timeUnit = timeUnit != null ? timeUnit : TimeUnit.SECONDS;
    }

    public long getExpirationTimeInMilliseconds() {
        return this.getConverted(TimeUnit.MILLISECONDS);
    }

    public long getExpirationTimeInSeconds() {
        return this.getConverted(TimeUnit.SECONDS);
    }

    public long getExpirationTime() {
        return this.expirationTime;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public long getConverted(TimeUnit targetTimeUnit) {
        Assert.notNull((Object)((Object)targetTimeUnit), (String)"TargetTimeUnit must not be null!");
        return targetTimeUnit.convert(this.expirationTime, this.timeUnit);
    }

    public static Expiration seconds(long expirationTime) {
        return new Expiration(expirationTime, TimeUnit.SECONDS);
    }

    public static Expiration milliseconds(long expirationTime) {
        return new Expiration(expirationTime, TimeUnit.MILLISECONDS);
    }

    public static Expiration from(long expirationTime, TimeUnit timeUnit) {
        if (ObjectUtils.nullSafeEquals((Object)((Object)timeUnit), (Object)((Object)TimeUnit.MICROSECONDS)) || ObjectUtils.nullSafeEquals((Object)((Object)timeUnit), (Object)((Object)TimeUnit.NANOSECONDS)) || ObjectUtils.nullSafeEquals((Object)((Object)timeUnit), (Object)((Object)TimeUnit.MILLISECONDS))) {
            return new Expiration(timeUnit.toMillis(expirationTime), TimeUnit.MILLISECONDS);
        }
        if (timeUnit != null) {
            return new Expiration(timeUnit.toSeconds(expirationTime), TimeUnit.SECONDS);
        }
        return new Expiration(expirationTime, TimeUnit.SECONDS);
    }

    public static Expiration from(Duration duration) {
        Assert.notNull((Object)duration, (String)"Duration must not be null!");
        if (duration.toMillis() % 1000L == 0L) {
            return new Expiration(duration.getSeconds(), TimeUnit.SECONDS);
        }
        return new Expiration(duration.toMillis(), TimeUnit.MILLISECONDS);
    }

    public static Expiration persistent() {
        return new Expiration(-1L, TimeUnit.SECONDS);
    }

    public boolean isPersistent() {
        return this.expirationTime == -1L;
    }
}

