/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.serializer;

import java.beans.ConstructorProperties;
import java.nio.ByteBuffer;
import org.springframework.data.redis.serializer.RedisElementWriter;
import org.springframework.data.redis.serializer.RedisSerializer;

class DefaultRedisElementWriter<T>
implements RedisElementWriter<T> {
    private final RedisSerializer<T> serializer;

    @Override
    public ByteBuffer write(T value) {
        if (this.serializer == null) {
            if (value instanceof byte[]) {
                return ByteBuffer.wrap((byte[])value);
            }
            if (value instanceof ByteBuffer) {
                return (ByteBuffer)value;
            }
            throw new IllegalStateException("Cannot serialize value without a serializer");
        }
        return ByteBuffer.wrap(this.serializer.serialize(value));
    }

    @ConstructorProperties(value={"serializer"})
    public DefaultRedisElementWriter(RedisSerializer<T> serializer) {
        this.serializer = serializer;
    }
}

