/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.util;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import org.springframework.util.Assert;

public final class ByteUtils {
    private ByteUtils() {
    }

    public static byte[] concat(byte[] arg1, byte[] arg2) {
        byte[] result = Arrays.copyOf(arg1, arg1.length + arg2.length);
        System.arraycopy(arg2, 0, result, arg1.length, arg2.length);
        return result;
    }

    public static byte[] concatAll(byte[] ... args) {
        if (args.length == 0) {
            return new byte[0];
        }
        if (args.length == 1) {
            return args[0];
        }
        byte[] cur = ByteUtils.concat(args[0], args[1]);
        for (int i = 2; i < args.length; ++i) {
            cur = ByteUtils.concat(cur, args[i]);
        }
        return cur;
    }

    public static byte[][] split(byte[] source, int c) {
        if (source == null || source.length == 0) {
            return new byte[0][];
        }
        ArrayList<byte[]> bytes = new ArrayList<byte[]>();
        int offset = 0;
        for (int i = 0; i <= source.length; ++i) {
            if (i == source.length) {
                bytes.add(Arrays.copyOfRange(source, offset, i));
                break;
            }
            if (source[i] != c) continue;
            bytes.add(Arrays.copyOfRange(source, offset, i));
            offset = i + 1;
        }
        return (byte[][])bytes.toArray((T[])new byte[bytes.size()][]);
    }

    public static byte[][] mergeArrays(byte[] firstArray, byte[] ... additionalArrays) {
        Assert.notNull((Object)firstArray, (String)"first array must not be null");
        Assert.notNull((Object)additionalArrays, (String)"additional arrays must not be null");
        byte[][] result = new byte[additionalArrays.length + 1][];
        result[0] = firstArray;
        System.arraycopy(additionalArrays, 0, result, 1, additionalArrays.length);
        return result;
    }

    public static byte[] getBytes(ByteBuffer byteBuffer) {
        Assert.notNull((Object)byteBuffer, (String)"ByteBuffer must not be null!");
        ByteBuffer duplicate = byteBuffer.duplicate();
        byte[] bytes = new byte[duplicate.remaining()];
        duplicate.get(bytes);
        return bytes;
    }
}

