/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import io.lettuce.core.ReadFrom;
import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisURI;
import io.lettuce.core.api.StatefulConnection;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.masterslave.MasterSlave;
import io.lettuce.core.masterslave.StatefulRedisMasterSlaveConnection;
import java.util.Collection;
import java.util.Optional;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionProvider;
import org.springframework.lang.Nullable;

class StaticMasterSlaveConnectionProvider
implements LettuceConnectionProvider {
    private final RedisClient client;
    private final RedisCodec<?, ?> codec;
    private final Optional<ReadFrom> readFrom;
    private final Collection<RedisURI> nodes;

    StaticMasterSlaveConnectionProvider(RedisClient client, RedisCodec<?, ?> codec, Collection<RedisURI> nodes, @Nullable ReadFrom readFrom) {
        this.client = client;
        this.codec = codec;
        this.readFrom = Optional.ofNullable(readFrom);
        this.nodes = nodes;
    }

    @Override
    public <T extends StatefulConnection<?, ?>> T getConnection(Class<T> connectionType) {
        if (StatefulConnection.class.isAssignableFrom(connectionType)) {
            StatefulRedisMasterSlaveConnection connection = MasterSlave.connect((RedisClient)this.client, this.codec, this.nodes);
            this.readFrom.ifPresent(arg_0 -> ((StatefulRedisMasterSlaveConnection)connection).setReadFrom(arg_0));
            return (T)((StatefulConnection)connectionType.cast(connection));
        }
        throw new UnsupportedOperationException(String.format("Connection type %s not supported!", connectionType));
    }
}

