/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.reactive.AwaitKt;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Publisher;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.core.ReactiveRedisOperations;
import reactor.core.publisher.Mono;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000J\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001aM\u0010\u0000\u001a\u00020\u0001\"\n\b\u0000\u0010\u0002\u0018\u0001*\u00020\u0003\"\n\b\u0001\u0010\u0004\u0018\u0001*\u00020\u0003*\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00040\u00052\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00020\u0007\"\u0002H\u0002H\u0086H\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\b\u001aI\u0010\t\u001a\u00020\n\"\n\b\u0000\u0010\u0002\u0018\u0001*\u00020\u0003\"\n\b\u0001\u0010\u0004\u0018\u0001*\u00020\u0003*\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00040\u00052\u0006\u0010\u0006\u001a\u0002H\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0086H\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\r\u001aI\u0010\u000e\u001a\u00020\n\"\n\b\u0000\u0010\u0002\u0018\u0001*\u00020\u0003\"\n\b\u0001\u0010\u0004\u0018\u0001*\u00020\u0003*\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00040\u00052\u0006\u0010\u0006\u001a\u0002H\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0086H\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0011\u001aC\u0010\u0012\u001a\u0004\u0018\u00010\f\"\n\b\u0000\u0010\u0002\u0018\u0001*\u00020\u0003\"\n\b\u0001\u0010\u0004\u0018\u0001*\u00020\u0003*\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00040\u00052\u0006\u0010\u0006\u001a\u0002H\u0002H\u0086H\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0013\u001aA\u0010\u0014\u001a\u00020\n\"\n\b\u0000\u0010\u0002\u0018\u0001*\u00020\u0003\"\n\b\u0001\u0010\u0004\u0018\u0001*\u00020\u0003*\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00040\u00052\u0006\u0010\u0006\u001a\u0002H\u0002H\u0086H\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0013\u001aI\u0010\u0015\u001a\u00020\n\"\n\b\u0000\u0010\u0002\u0018\u0001*\u00020\u0003\"\n\b\u0001\u0010\u0004\u0018\u0001*\u00020\u0003*\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00040\u00052\u0006\u0010\u0006\u001a\u0002H\u00022\u0006\u0010\u0016\u001a\u00020\u0017H\u0086H\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0018\u001aA\u0010\u0019\u001a\u00020\n\"\n\b\u0000\u0010\u0002\u0018\u0001*\u00020\u0003\"\n\b\u0001\u0010\u0004\u0018\u0001*\u00020\u0003*\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00040\u00052\u0006\u0010\u0006\u001a\u0002H\u0002H\u0086H\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0013\u001a;\u0010\u001a\u001a\u0004\u0018\u0001H\u0002\"\n\b\u0000\u0010\u0002\u0018\u0001*\u00020\u0003\"\n\b\u0001\u0010\u0004\u0018\u0001*\u00020\u0003*\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00040\u0005H\u0086H\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001b\u001aI\u0010\u001c\u001a\u00020\n\"\n\b\u0000\u0010\u0002\u0018\u0001*\u00020\u0003\"\n\b\u0001\u0010\u0004\u0018\u0001*\u00020\u0003*\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00040\u00052\u0006\u0010\u001d\u001a\u0002H\u00022\u0006\u0010\u001e\u001a\u0002H\u0002H\u0086H\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001f\u001aI\u0010 \u001a\u00020\n\"\n\b\u0000\u0010\u0002\u0018\u0001*\u00020\u0003\"\n\b\u0001\u0010\u0004\u0018\u0001*\u00020\u0003*\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00040\u00052\u0006\u0010\u001d\u001a\u0002H\u00022\u0006\u0010\u001e\u001a\u0002H\u0002H\u0086H\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001f\u001aI\u0010!\u001a\u00020\u0001\"\n\b\u0000\u0010\u0002\u0018\u0001*\u00020\u0003\"\n\b\u0001\u0010\u0004\u0018\u0001*\u00020\u0003*\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00040\u00052\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u0002H\u0004H\u0086H\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010%\u001aA\u0010&\u001a\u00020'\"\n\b\u0000\u0010\u0002\u0018\u0001*\u00020\u0003\"\n\b\u0001\u0010\u0004\u0018\u0001*\u00020\u0003*\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00040\u00052\u0006\u0010\u0006\u001a\u0002H\u0002H\u0086H\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0013\u001aM\u0010(\u001a\u00020\u0001\"\n\b\u0000\u0010\u0002\u0018\u0001*\u00020\u0003\"\n\b\u0001\u0010\u0004\u0018\u0001*\u00020\u0003*\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00040\u00052\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00020\u0007\"\u0002H\u0002H\u0086H\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\b\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006)"}, d2={"deleteAndAwait", "", "K", "", "V", "Lorg/springframework/data/redis/core/ReactiveRedisOperations;", "key", "", "(Lorg/springframework/data/redis/core/ReactiveRedisOperations;[Ljava/lang/Object;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "expireAndAwait", "", "timeout", "Ljava/time/Duration;", "(Lorg/springframework/data/redis/core/ReactiveRedisOperations;Ljava/lang/Object;Ljava/time/Duration;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "expireAtAndAwait", "expireAt", "Ljava/time/Instant;", "(Lorg/springframework/data/redis/core/ReactiveRedisOperations;Ljava/lang/Object;Ljava/time/Instant;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getExpireAndAwait", "(Lorg/springframework/data/redis/core/ReactiveRedisOperations;Ljava/lang/Object;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "hasKeyAndAwait", "moveAndAwait", "dbIndex", "", "(Lorg/springframework/data/redis/core/ReactiveRedisOperations;Ljava/lang/Object;ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "persistAndAwait", "randomKeyAndAwait", "(Lorg/springframework/data/redis/core/ReactiveRedisOperations;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "renameAndAwait", "oldKey", "newKey", "(Lorg/springframework/data/redis/core/ReactiveRedisOperations;Ljava/lang/Object;Ljava/lang/Object;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "renameIfAbsentAndAwait", "sendAndAwait", "destination", "", "message", "(Lorg/springframework/data/redis/core/ReactiveRedisOperations;Ljava/lang/String;Ljava/lang/Object;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "typeAndAwait", "Lorg/springframework/data/redis/connection/DataType;", "unlinkAndAwait", "spring-data-redis"})
public final class ReactiveRedisOperationsExtensionsKt {
    private static final <K, V> Object sendAndAwait(@NotNull ReactiveRedisOperations<K, V> $this$sendAndAwait, String destination, V message, Continuation<? super Long> continuation) {
        int $i$f$sendAndAwait = 0;
        Mono<Long> mono = $this$sendAndAwait.convertAndSend(destination, message);
        Intrinsics.checkExpressionValueIsNotNull(mono, (String)"convertAndSend(destination, message)");
        Publisher publisher = (Publisher)mono;
        InlineMarker.mark((int)0);
        Object object = AwaitKt.awaitSingle((Publisher)publisher, continuation);
        InlineMarker.mark((int)1);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"convertAndSend(destination, message).awaitSingle()");
        return object;
    }

    private static final <K, V> Object hasKeyAndAwait(@NotNull ReactiveRedisOperations<K, V> $this$hasKeyAndAwait, K key, Continuation<? super Boolean> continuation) {
        int $i$f$hasKeyAndAwait = 0;
        Mono<Boolean> mono = $this$hasKeyAndAwait.hasKey(key);
        Intrinsics.checkExpressionValueIsNotNull(mono, (String)"hasKey(key)");
        Publisher publisher = (Publisher)mono;
        InlineMarker.mark((int)0);
        Object object = AwaitKt.awaitSingle((Publisher)publisher, continuation);
        InlineMarker.mark((int)1);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"hasKey(key).awaitSingle()");
        return object;
    }

    private static final <K, V> Object typeAndAwait(@NotNull ReactiveRedisOperations<K, V> $this$typeAndAwait, K key, Continuation<? super DataType> continuation) {
        int $i$f$typeAndAwait = 0;
        Mono<DataType> mono = $this$typeAndAwait.type(key);
        Intrinsics.checkExpressionValueIsNotNull(mono, (String)"type(key)");
        Publisher publisher = (Publisher)mono;
        InlineMarker.mark((int)0);
        Object object = AwaitKt.awaitSingle((Publisher)publisher, continuation);
        InlineMarker.mark((int)1);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"type(key).awaitSingle()");
        return object;
    }

    private static final <K, V> Object randomKeyAndAwait(@NotNull ReactiveRedisOperations<K, V> $this$randomKeyAndAwait, Continuation<? super K> continuation) {
        int $i$f$randomKeyAndAwait = 0;
        Mono<K> mono = $this$randomKeyAndAwait.randomKey();
        Intrinsics.checkExpressionValueIsNotNull(mono, (String)"randomKey()");
        Publisher publisher = (Publisher)mono;
        InlineMarker.mark((int)0);
        Object object = AwaitKt.awaitFirstOrNull((Publisher)publisher, continuation);
        InlineMarker.mark((int)1);
        return object;
    }

    private static final <K, V> Object renameAndAwait(@NotNull ReactiveRedisOperations<K, V> $this$renameAndAwait, K oldKey, K newKey, Continuation<? super Boolean> continuation) {
        int $i$f$renameAndAwait = 0;
        Mono<Boolean> mono = $this$renameAndAwait.rename(oldKey, newKey);
        Intrinsics.checkExpressionValueIsNotNull(mono, (String)"rename(oldKey, newKey)");
        Publisher publisher = (Publisher)mono;
        InlineMarker.mark((int)0);
        Object object = AwaitKt.awaitSingle((Publisher)publisher, continuation);
        InlineMarker.mark((int)1);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"rename(oldKey, newKey).awaitSingle()");
        return object;
    }

    private static final <K, V> Object renameIfAbsentAndAwait(@NotNull ReactiveRedisOperations<K, V> $this$renameIfAbsentAndAwait, K oldKey, K newKey, Continuation<? super Boolean> continuation) {
        int $i$f$renameIfAbsentAndAwait = 0;
        Mono<Boolean> mono = $this$renameIfAbsentAndAwait.renameIfAbsent(oldKey, newKey);
        Intrinsics.checkExpressionValueIsNotNull(mono, (String)"renameIfAbsent(oldKey, newKey)");
        Publisher publisher = (Publisher)mono;
        InlineMarker.mark((int)0);
        Object object = AwaitKt.awaitSingle((Publisher)publisher, continuation);
        InlineMarker.mark((int)1);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"renameIfAbsent(oldKey, newKey).awaitSingle()");
        return object;
    }

    private static final <K, V> Object deleteAndAwait(@NotNull ReactiveRedisOperations<K, V> $this$deleteAndAwait, K[] key, Continuation<? super Long> continuation) {
        int $i$f$deleteAndAwait = 0;
        Mono<Long> mono = $this$deleteAndAwait.delete(Arrays.copyOf(key, key.length));
        Intrinsics.checkExpressionValueIsNotNull(mono, (String)"delete(*key)");
        Publisher publisher = (Publisher)mono;
        InlineMarker.mark((int)0);
        Object object = AwaitKt.awaitSingle((Publisher)publisher, continuation);
        InlineMarker.mark((int)1);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"delete(*key).awaitSingle()");
        return object;
    }

    private static final <K, V> Object unlinkAndAwait(@NotNull ReactiveRedisOperations<K, V> $this$unlinkAndAwait, K[] key, Continuation<? super Long> continuation) {
        int $i$f$unlinkAndAwait = 0;
        Mono<Long> mono = $this$unlinkAndAwait.unlink(Arrays.copyOf(key, key.length));
        Intrinsics.checkExpressionValueIsNotNull(mono, (String)"unlink(*key)");
        Publisher publisher = (Publisher)mono;
        InlineMarker.mark((int)0);
        Object object = AwaitKt.awaitSingle((Publisher)publisher, continuation);
        InlineMarker.mark((int)1);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"unlink(*key).awaitSingle()");
        return object;
    }

    private static final <K, V> Object expireAndAwait(@NotNull ReactiveRedisOperations<K, V> $this$expireAndAwait, K key, Duration timeout, Continuation<? super Boolean> continuation) {
        int $i$f$expireAndAwait = 0;
        Mono<Boolean> mono = $this$expireAndAwait.expire(key, timeout);
        Intrinsics.checkExpressionValueIsNotNull(mono, (String)"expire(key, timeout)");
        Publisher publisher = (Publisher)mono;
        InlineMarker.mark((int)0);
        Object object = AwaitKt.awaitSingle((Publisher)publisher, continuation);
        InlineMarker.mark((int)1);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"expire(key, timeout).awaitSingle()");
        return object;
    }

    private static final <K, V> Object expireAtAndAwait(@NotNull ReactiveRedisOperations<K, V> $this$expireAtAndAwait, K key, Instant expireAt, Continuation<? super Boolean> continuation) {
        int $i$f$expireAtAndAwait = 0;
        Mono<Boolean> mono = $this$expireAtAndAwait.expireAt(key, expireAt);
        Intrinsics.checkExpressionValueIsNotNull(mono, (String)"expireAt(key, expireAt)");
        Publisher publisher = (Publisher)mono;
        InlineMarker.mark((int)0);
        Object object = AwaitKt.awaitSingle((Publisher)publisher, continuation);
        InlineMarker.mark((int)1);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"expireAt(key, expireAt).awaitSingle()");
        return object;
    }

    private static final <K, V> Object persistAndAwait(@NotNull ReactiveRedisOperations<K, V> $this$persistAndAwait, K key, Continuation<? super Boolean> continuation) {
        int $i$f$persistAndAwait = 0;
        Mono<Boolean> mono = $this$persistAndAwait.persist(key);
        Intrinsics.checkExpressionValueIsNotNull(mono, (String)"persist(key)");
        Publisher publisher = (Publisher)mono;
        InlineMarker.mark((int)0);
        Object object = AwaitKt.awaitSingle((Publisher)publisher, continuation);
        InlineMarker.mark((int)1);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"persist(key).awaitSingle()");
        return object;
    }

    private static final <K, V> Object moveAndAwait(@NotNull ReactiveRedisOperations<K, V> $this$moveAndAwait, K key, int dbIndex, Continuation<? super Boolean> continuation) {
        int $i$f$moveAndAwait = 0;
        Mono<Boolean> mono = $this$moveAndAwait.move(key, dbIndex);
        Intrinsics.checkExpressionValueIsNotNull(mono, (String)"move(key, dbIndex)");
        Publisher publisher = (Publisher)mono;
        InlineMarker.mark((int)0);
        Object object = AwaitKt.awaitSingle((Publisher)publisher, continuation);
        InlineMarker.mark((int)1);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"move(key, dbIndex).awaitSingle()");
        return object;
    }

    private static final <K, V> Object getExpireAndAwait(@NotNull ReactiveRedisOperations<K, V> $this$getExpireAndAwait, K key, Continuation<? super Duration> continuation) {
        int $i$f$getExpireAndAwait = 0;
        Mono<Duration> mono = $this$getExpireAndAwait.getExpire(key);
        Intrinsics.checkExpressionValueIsNotNull(mono, (String)"getExpire(key)");
        Publisher publisher = (Publisher)mono;
        InlineMarker.mark((int)0);
        Object object = AwaitKt.awaitFirstOrNull((Publisher)publisher, continuation);
        InlineMarker.mark((int)1);
        return object;
    }
}

