/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.stream;

import java.time.Duration;
import java.util.OptionalInt;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import org.springframework.context.SmartLifecycle;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.stream.Consumer;
import org.springframework.data.redis.connection.stream.MapRecord;
import org.springframework.data.redis.connection.stream.ObjectRecord;
import org.springframework.data.redis.connection.stream.Record;
import org.springframework.data.redis.connection.stream.StreamOffset;
import org.springframework.data.redis.hash.HashMapper;
import org.springframework.data.redis.hash.ObjectHashMapper;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.data.redis.stream.DefaultStreamMessageListenerContainer;
import org.springframework.data.redis.stream.RawRedisSerializer;
import org.springframework.data.redis.stream.StreamListener;
import org.springframework.data.redis.stream.Subscription;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ErrorHandler;

public interface StreamMessageListenerContainer<K, V extends Record<K, ?>>
extends SmartLifecycle {
    public static StreamMessageListenerContainer<String, MapRecord<String, String, String>> create(RedisConnectionFactory connectionFactory) {
        Assert.notNull((Object)connectionFactory, (String)"RedisConnectionFactory must not be null!");
        return StreamMessageListenerContainer.create(connectionFactory, StreamMessageListenerContainerOptions.builder().serializer(StringRedisSerializer.UTF_8).build());
    }

    public static <K, V extends Record<K, ?>> StreamMessageListenerContainer<K, V> create(RedisConnectionFactory connectionFactory, StreamMessageListenerContainerOptions<K, V> options) {
        Assert.notNull((Object)connectionFactory, (String)"RedisConnectionFactory must not be null!");
        Assert.notNull(options, (String)"StreamMessageListenerContainerOptions must not be null!");
        return new DefaultStreamMessageListenerContainer<K, V>(connectionFactory, options);
    }

    default public Subscription receive(StreamOffset<K> streamOffset, StreamListener<K, V> listener) {
        return this.register(StreamReadRequest.builder(streamOffset).build(), listener);
    }

    default public Subscription receive(Consumer consumer, StreamOffset<K> streamOffset, StreamListener<K, V> listener) {
        return this.register(StreamReadRequest.builder(streamOffset).consumer(consumer).build(), listener);
    }

    default public Subscription receiveAutoAck(Consumer consumer, StreamOffset<K> streamOffset, StreamListener<K, V> listener) {
        return this.register(StreamReadRequest.builder(streamOffset).consumer(consumer).autoAck(true).build(), listener);
    }

    public Subscription register(StreamReadRequest<K> var1, StreamListener<K, V> var2);

    public void remove(Subscription var1);

    public static class StreamMessageListenerContainerOptionsBuilder<K, V extends Record<K, ?>> {
        private Duration pollTimeout = Duration.ofSeconds(2L);
        @Nullable
        private Integer batchSize;
        private RedisSerializer<K> keySerializer;
        private RedisSerializer<Object> hashKeySerializer;
        private RedisSerializer<Object> hashValueSerializer;
        @Nullable
        private HashMapper<V, ?, ?> hashMapper;
        @Nullable
        private Class<?> targetType;
        private ErrorHandler errorHandler = DefaultStreamMessageListenerContainer.LoggingErrorHandler.INSTANCE;
        private Executor executor = new SimpleAsyncTaskExecutor();

        private StreamMessageListenerContainerOptionsBuilder() {
        }

        public StreamMessageListenerContainerOptionsBuilder<K, V> pollTimeout(Duration pollTimeout) {
            Assert.notNull((Object)pollTimeout, (String)"Poll timeout must not be null!");
            Assert.isTrue((!pollTimeout.isNegative() ? 1 : 0) != 0, (String)"Poll timeout must not be negative!");
            this.pollTimeout = pollTimeout;
            return this;
        }

        public StreamMessageListenerContainerOptionsBuilder<K, V> batchSize(int messagesPerPoll) {
            Assert.isTrue((messagesPerPoll > 0 ? 1 : 0) != 0, (String)"Batch size must be greater zero!");
            this.batchSize = messagesPerPoll;
            return this;
        }

        public StreamMessageListenerContainerOptionsBuilder<K, V> executor(Executor executor) {
            Assert.notNull((Object)executor, (String)"Executor must not be null!");
            this.executor = executor;
            return this;
        }

        public StreamMessageListenerContainerOptionsBuilder<K, V> errorHandler(ErrorHandler errorHandler) {
            Assert.notNull((Object)errorHandler, (String)"ErrorHandler must not be null!");
            this.errorHandler = errorHandler;
            return this;
        }

        public <T> StreamMessageListenerContainerOptionsBuilder<T, MapRecord<T, T, T>> serializer(RedisSerializer<T> serializer) {
            Assert.notNull(serializer, (String)"RedisSerializer must not be null");
            this.keySerializer = serializer;
            this.hashKeySerializer = serializer;
            this.hashValueSerializer = serializer;
            return this;
        }

        public <NK, NV extends Record<NK, ?>> StreamMessageListenerContainerOptionsBuilder<NK, NV> keySerializer(RedisSerializer<NK> serializer) {
            Assert.notNull(serializer, (String)"RedisSerializer must not be null");
            this.keySerializer = serializer;
            return this;
        }

        public <HK, HV> StreamMessageListenerContainerOptionsBuilder<K, MapRecord<K, HK, HV>> hashKeySerializer(RedisSerializer<HK> serializer) {
            Assert.notNull(serializer, (String)"RedisSerializer must not be null");
            this.hashKeySerializer = serializer;
            return this;
        }

        public <HK, HV> StreamMessageListenerContainerOptionsBuilder<K, MapRecord<K, HK, HV>> hashValueSerializer(RedisSerializer<HK> serializer) {
            Assert.notNull(serializer, (String)"RedisSerializer must not be null");
            this.hashValueSerializer = serializer;
            return this;
        }

        public <NV> StreamMessageListenerContainerOptionsBuilder<K, ObjectRecord<K, NV>> targetType(Class<NV> targetType) {
            Assert.notNull(targetType, (String)"Target type must not be null");
            this.targetType = targetType;
            if (this.hashMapper == null) {
                this.hashKeySerializer(RawRedisSerializer.INSTANCE);
                this.hashValueSerializer(RawRedisSerializer.INSTANCE);
                return this.objectMapper(new ObjectHashMapper());
            }
            return this;
        }

        public <NV> StreamMessageListenerContainerOptionsBuilder<K, ObjectRecord<K, NV>> objectMapper(HashMapper<NV, ?, ?> hashMapper) {
            Assert.notNull(hashMapper, (String)"HashMapper must not be null");
            this.hashMapper = hashMapper;
            return this;
        }

        public StreamMessageListenerContainerOptions<K, V> build() {
            return new StreamMessageListenerContainerOptions(this.pollTimeout, this.batchSize, this.keySerializer, this.hashKeySerializer, this.hashValueSerializer, this.targetType, this.hashMapper, this.errorHandler, this.executor);
        }
    }

    public static class StreamMessageListenerContainerOptions<K, V extends Record<K, ?>> {
        private final Duration pollTimeout;
        @Nullable
        private final Integer batchSize;
        private final RedisSerializer<K> keySerializer;
        private final RedisSerializer<Object> hashKeySerializer;
        private final RedisSerializer<Object> hashValueSerializer;
        @Nullable
        private final Class<Object> targetType;
        @Nullable
        private final HashMapper<Object, Object, Object> hashMapper;
        private final ErrorHandler errorHandler;
        private final Executor executor;

        private StreamMessageListenerContainerOptions(Duration pollTimeout, @Nullable Integer batchSize, RedisSerializer<K> keySerializer, RedisSerializer<Object> hashKeySerializer, RedisSerializer<Object> hashValueSerializer, @Nullable Class<?> targetType, @Nullable HashMapper<V, ?, ?> hashMapper, ErrorHandler errorHandler, Executor executor) {
            this.pollTimeout = pollTimeout;
            this.batchSize = batchSize;
            this.keySerializer = keySerializer;
            this.hashKeySerializer = hashKeySerializer;
            this.hashValueSerializer = hashValueSerializer;
            this.targetType = targetType;
            this.hashMapper = hashMapper;
            this.errorHandler = errorHandler;
            this.executor = executor;
        }

        static StreamMessageListenerContainerOptionsBuilder<String, MapRecord<String, String, String>> builder() {
            return new StreamMessageListenerContainerOptionsBuilder().serializer(StringRedisSerializer.UTF_8);
        }

        public Duration getPollTimeout() {
            return this.pollTimeout;
        }

        public OptionalInt getBatchSize() {
            return this.batchSize != null ? OptionalInt.of(this.batchSize) : OptionalInt.empty();
        }

        public RedisSerializer<K> getKeySerializer() {
            return this.keySerializer;
        }

        public RedisSerializer<Object> getHashKeySerializer() {
            return this.hashKeySerializer;
        }

        public RedisSerializer<Object> getHashValueSerializer() {
            return this.hashValueSerializer;
        }

        @Nullable
        public HashMapper<Object, Object, Object> getHashMapper() {
            return this.hashMapper;
        }

        public Class<Object> getTargetType() {
            if (this.targetType != null) {
                return this.targetType;
            }
            return Object.class;
        }

        public ErrorHandler getErrorHandler() {
            return this.errorHandler;
        }

        public Executor getExecutor() {
            return this.executor;
        }
    }

    public static class ConsumerStreamReadRequestBuilder<K>
    extends StreamReadRequestBuilder<K> {
        private Consumer consumer;
        private boolean autoAck = true;

        ConsumerStreamReadRequestBuilder(StreamReadRequestBuilder<K> other) {
            super(other);
        }

        @Override
        public ConsumerStreamReadRequestBuilder<K> errorHandler(ErrorHandler errorHandler) {
            super.errorHandler(errorHandler);
            return this;
        }

        @Override
        public ConsumerStreamReadRequestBuilder<K> cancelOnError(Predicate<Throwable> cancelSubscriptionOnError) {
            super.cancelOnError(cancelSubscriptionOnError);
            return this;
        }

        @Override
        public ConsumerStreamReadRequestBuilder<K> consumer(Consumer consumer) {
            this.consumer = consumer;
            return this;
        }

        public ConsumerStreamReadRequestBuilder<K> autoAck(boolean autoAck) {
            this.autoAck = autoAck;
            return this;
        }

        @Override
        public ConsumerStreamReadRequest<K> build() {
            return new ConsumerStreamReadRequest(this.streamOffset, this.errorHandler, this.cancelSubscriptionOnError, this.consumer, this.autoAck);
        }
    }

    public static class StreamReadRequestBuilder<K> {
        final StreamOffset<K> streamOffset;
        @Nullable
        ErrorHandler errorHandler;
        Predicate<Throwable> cancelSubscriptionOnError = t -> true;

        StreamReadRequestBuilder(StreamOffset<K> streamOffset) {
            this.streamOffset = streamOffset;
        }

        StreamReadRequestBuilder(StreamReadRequestBuilder<K> other) {
            this.streamOffset = other.streamOffset;
            this.errorHandler = other.errorHandler;
            this.cancelSubscriptionOnError = other.cancelSubscriptionOnError;
        }

        public StreamReadRequestBuilder<K> errorHandler(ErrorHandler errorHandler) {
            this.errorHandler = errorHandler;
            return this;
        }

        public StreamReadRequestBuilder<K> cancelOnError(Predicate<Throwable> cancelSubscriptionOnError) {
            this.cancelSubscriptionOnError = cancelSubscriptionOnError;
            return this;
        }

        public ConsumerStreamReadRequestBuilder<K> consumer(Consumer consumer) {
            return new ConsumerStreamReadRequestBuilder(this).consumer(consumer);
        }

        public StreamReadRequest<K> build() {
            return new StreamReadRequest(this.streamOffset, this.errorHandler, this.cancelSubscriptionOnError);
        }
    }

    public static class ConsumerStreamReadRequest<K>
    extends StreamReadRequest<K> {
        private final Consumer consumer;
        private final boolean autoAck;

        private ConsumerStreamReadRequest(StreamOffset<K> streamOffset, @Nullable ErrorHandler errorHandler, Predicate<Throwable> cancelSubscriptionOnError, Consumer consumer, boolean autoAck) {
            super(streamOffset, errorHandler, cancelSubscriptionOnError);
            this.consumer = consumer;
            this.autoAck = autoAck;
        }

        public Consumer getConsumer() {
            return this.consumer;
        }

        public boolean isAutoAck() {
            return this.autoAck;
        }
    }

    public static class StreamReadRequest<K> {
        private final StreamOffset<K> streamOffset;
        @Nullable
        private final ErrorHandler errorHandler;
        private final Predicate<Throwable> cancelSubscriptionOnError;

        private StreamReadRequest(StreamOffset<K> streamOffset, @Nullable ErrorHandler errorHandler, Predicate<Throwable> cancelSubscriptionOnError) {
            this.streamOffset = streamOffset;
            this.errorHandler = errorHandler;
            this.cancelSubscriptionOnError = cancelSubscriptionOnError;
        }

        static <K> StreamReadRequestBuilder<K> builder(StreamOffset<K> offset) {
            return new StreamReadRequestBuilder<K>(offset);
        }

        public StreamOffset<K> getStreamOffset() {
            return this.streamOffset;
        }

        @Nullable
        public ErrorHandler getErrorHandler() {
            return this.errorHandler;
        }

        public Predicate<Throwable> getCancelSubscriptionOnError() {
            return this.cancelSubscriptionOnError;
        }
    }
}

