/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.io.Closeable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisKeyCommands;
import org.springframework.data.redis.connection.RedisServerCommands;
import org.springframework.data.redis.connection.RedisTxCommands;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.connection.SortParameters;
import org.springframework.data.redis.core.BoundGeoOperations;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.data.redis.core.BoundListOperations;
import org.springframework.data.redis.core.BoundSetOperations;
import org.springframework.data.redis.core.BoundStreamOperations;
import org.springframework.data.redis.core.BoundValueOperations;
import org.springframework.data.redis.core.BoundZSetOperations;
import org.springframework.data.redis.core.BulkMapper;
import org.springframework.data.redis.core.CloseSuppressingInvocationHandler;
import org.springframework.data.redis.core.ClusterOperations;
import org.springframework.data.redis.core.DefaultBoundGeoOperations;
import org.springframework.data.redis.core.DefaultBoundHashOperations;
import org.springframework.data.redis.core.DefaultBoundListOperations;
import org.springframework.data.redis.core.DefaultBoundSetOperations;
import org.springframework.data.redis.core.DefaultBoundStreamOperations;
import org.springframework.data.redis.core.DefaultBoundValueOperations;
import org.springframework.data.redis.core.DefaultBoundZSetOperations;
import org.springframework.data.redis.core.DefaultClusterOperations;
import org.springframework.data.redis.core.DefaultGeoOperations;
import org.springframework.data.redis.core.DefaultHashOperations;
import org.springframework.data.redis.core.DefaultHyperLogLogOperations;
import org.springframework.data.redis.core.DefaultListOperations;
import org.springframework.data.redis.core.DefaultSetOperations;
import org.springframework.data.redis.core.DefaultStreamOperations;
import org.springframework.data.redis.core.DefaultTypedTuple;
import org.springframework.data.redis.core.DefaultValueOperations;
import org.springframework.data.redis.core.DefaultZSetOperations;
import org.springframework.data.redis.core.GeoOperations;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.HyperLogLogOperations;
import org.springframework.data.redis.core.ListOperations;
import org.springframework.data.redis.core.RedisAccessor;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.RedisConnectionUtils;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.SessionCallback;
import org.springframework.data.redis.core.SetOperations;
import org.springframework.data.redis.core.StreamOperations;
import org.springframework.data.redis.core.TimeoutUtils;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.data.redis.core.query.QueryUtils;
import org.springframework.data.redis.core.query.SortQuery;
import org.springframework.data.redis.core.script.DefaultScriptExecutor;
import org.springframework.data.redis.core.script.RedisScript;
import org.springframework.data.redis.core.script.ScriptExecutor;
import org.springframework.data.redis.core.types.RedisClientInfo;
import org.springframework.data.redis.hash.HashMapper;
import org.springframework.data.redis.hash.ObjectHashMapper;
import org.springframework.data.redis.serializer.JdkSerializationRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.SerializationUtils;
import org.springframework.lang.Nullable;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;

public class RedisTemplate<K, V>
extends RedisAccessor
implements RedisOperations<K, V>,
BeanClassLoaderAware {
    private boolean enableTransactionSupport = false;
    private boolean exposeConnection = false;
    private boolean initialized = false;
    private boolean enableDefaultSerializer = true;
    @Nullable
    private RedisSerializer<?> defaultSerializer;
    @Nullable
    private ClassLoader classLoader;
    @Nullable
    private RedisSerializer keySerializer = null;
    @Nullable
    private RedisSerializer valueSerializer = null;
    @Nullable
    private RedisSerializer hashKeySerializer = null;
    @Nullable
    private RedisSerializer hashValueSerializer = null;
    private RedisSerializer<String> stringSerializer = RedisSerializer.string();
    @Nullable
    private ScriptExecutor<K> scriptExecutor;
    @Nullable
    private ValueOperations<K, V> valueOps;
    @Nullable
    private ListOperations<K, V> listOps;
    @Nullable
    private SetOperations<K, V> setOps;
    @Nullable
    private StreamOperations<K, ?, ?> streamOps;
    @Nullable
    private ZSetOperations<K, V> zSetOps;
    @Nullable
    private GeoOperations<K, V> geoOps;
    @Nullable
    private HyperLogLogOperations<K, V> hllOps;

    @Override
    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        boolean defaultUsed = false;
        if (this.defaultSerializer == null) {
            this.defaultSerializer = new JdkSerializationRedisSerializer(this.classLoader != null ? this.classLoader : this.getClass().getClassLoader());
        }
        if (this.enableDefaultSerializer) {
            if (this.keySerializer == null) {
                this.keySerializer = this.defaultSerializer;
                defaultUsed = true;
            }
            if (this.valueSerializer == null) {
                this.valueSerializer = this.defaultSerializer;
                defaultUsed = true;
            }
            if (this.hashKeySerializer == null) {
                this.hashKeySerializer = this.defaultSerializer;
                defaultUsed = true;
            }
            if (this.hashValueSerializer == null) {
                this.hashValueSerializer = this.defaultSerializer;
                defaultUsed = true;
            }
        }
        if (this.enableDefaultSerializer && defaultUsed) {
            Assert.notNull(this.defaultSerializer, (String)"default serializer null and not all serializers initialized");
        }
        if (this.scriptExecutor == null) {
            this.scriptExecutor = new DefaultScriptExecutor(this);
        }
        this.initialized = true;
    }

    @Override
    @Nullable
    public <T> T execute(RedisCallback<T> action) {
        return this.execute(action, this.isExposeConnection());
    }

    @Nullable
    public <T> T execute(RedisCallback<T> action, boolean exposeConnection) {
        return this.execute(action, exposeConnection, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <T> T execute(RedisCallback<T> action, boolean exposeConnection, boolean pipeline) {
        Assert.isTrue((boolean)this.initialized, (String)"template not initialized; call afterPropertiesSet() before using it");
        Assert.notNull(action, (String)"Callback object must not be null");
        RedisConnectionFactory factory = this.getRequiredConnectionFactory();
        RedisConnection conn = null;
        try {
            conn = this.enableTransactionSupport ? RedisConnectionUtils.bindConnection(factory, this.enableTransactionSupport) : RedisConnectionUtils.getConnection(factory);
            boolean existingConnection = TransactionSynchronizationManager.hasResource((Object)factory);
            RedisConnection connToUse = this.preProcessConnection(conn, existingConnection);
            boolean pipelineStatus = connToUse.isPipelined();
            if (pipeline && !pipelineStatus) {
                connToUse.openPipeline();
            }
            RedisConnection connToExpose = exposeConnection ? connToUse : this.createRedisConnectionProxy(connToUse);
            T result = action.doInRedis(connToExpose);
            if (pipeline && !pipelineStatus) {
                connToUse.closePipeline();
            }
            T t = this.postProcessResult(result, connToUse, existingConnection);
            return t;
        }
        finally {
            RedisConnectionUtils.releaseConnection(conn, factory, this.enableTransactionSupport);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T execute(SessionCallback<T> session) {
        Assert.isTrue((boolean)this.initialized, (String)"template not initialized; call afterPropertiesSet() before using it");
        Assert.notNull(session, (String)"Callback object must not be null");
        RedisConnectionFactory factory = this.getRequiredConnectionFactory();
        RedisConnectionUtils.bindConnection(factory, this.enableTransactionSupport);
        try {
            T t = session.execute(this);
            return t;
        }
        finally {
            RedisConnectionUtils.unbindConnection(factory);
        }
    }

    @Override
    public List<Object> executePipelined(SessionCallback<?> session) {
        return this.executePipelined(session, this.valueSerializer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Object> executePipelined(SessionCallback<?> session, @Nullable RedisSerializer<?> resultSerializer) {
        Assert.isTrue((boolean)this.initialized, (String)"template not initialized; call afterPropertiesSet() before using it");
        Assert.notNull(session, (String)"Callback object must not be null");
        RedisConnectionFactory factory = this.getRequiredConnectionFactory();
        RedisConnectionUtils.bindConnection(factory, this.enableTransactionSupport);
        try {
            List list = this.execute((RedisConnection connection) -> {
                connection.openPipeline();
                boolean pipelinedClosed = false;
                try {
                    Object result = this.executeSession(session);
                    if (result != null) {
                        throw new InvalidDataAccessApiUsageException("Callback cannot return a non-null value as it gets overwritten by the pipeline");
                    }
                    List<Object> closePipeline = connection.closePipeline();
                    pipelinedClosed = true;
                    List<Object> list = this.deserializeMixedResults(closePipeline, resultSerializer, this.hashKeySerializer, this.hashValueSerializer);
                    return list;
                }
                finally {
                    if (!pipelinedClosed) {
                        connection.closePipeline();
                    }
                }
            });
            return list;
        }
        finally {
            RedisConnectionUtils.unbindConnection(factory);
        }
    }

    @Override
    public List<Object> executePipelined(RedisCallback<?> action) {
        return this.executePipelined(action, this.valueSerializer);
    }

    @Override
    public List<Object> executePipelined(RedisCallback<?> action, @Nullable RedisSerializer<?> resultSerializer) {
        return this.execute((RedisConnection connection) -> {
            connection.openPipeline();
            boolean pipelinedClosed = false;
            try {
                Object result = action.doInRedis(connection);
                if (result != null) {
                    throw new InvalidDataAccessApiUsageException("Callback cannot return a non-null value as it gets overwritten by the pipeline");
                }
                List<Object> closePipeline = connection.closePipeline();
                pipelinedClosed = true;
                List<Object> list = this.deserializeMixedResults(closePipeline, resultSerializer, this.hashKeySerializer, this.hashValueSerializer);
                return list;
            }
            finally {
                if (!pipelinedClosed) {
                    connection.closePipeline();
                }
            }
        });
    }

    @Override
    public <T> T execute(RedisScript<T> script, List<K> keys, Object ... args) {
        return this.scriptExecutor.execute(script, keys, args);
    }

    @Override
    public <T> T execute(RedisScript<T> script, RedisSerializer<?> argsSerializer, RedisSerializer<T> resultSerializer, List<K> keys, Object ... args) {
        return this.scriptExecutor.execute(script, argsSerializer, resultSerializer, keys, args);
    }

    @Override
    public <T extends Closeable> T executeWithStickyConnection(RedisCallback<T> callback) {
        Assert.isTrue((boolean)this.initialized, (String)"template not initialized; call afterPropertiesSet() before using it");
        Assert.notNull(callback, (String)"Callback object must not be null");
        RedisConnectionFactory factory = this.getRequiredConnectionFactory();
        RedisConnection connection = this.preProcessConnection(RedisConnectionUtils.doGetConnection(factory, true, false, false), false);
        return (T)((Closeable)callback.doInRedis(connection));
    }

    private Object executeSession(SessionCallback<?> session) {
        return session.execute(this);
    }

    protected RedisConnection createRedisConnectionProxy(RedisConnection pm) {
        Class[] ifcs = ClassUtils.getAllInterfacesForClass(pm.getClass(), (ClassLoader)this.getClass().getClassLoader());
        return (RedisConnection)Proxy.newProxyInstance(pm.getClass().getClassLoader(), ifcs, (InvocationHandler)new CloseSuppressingInvocationHandler(pm));
    }

    protected RedisConnection preProcessConnection(RedisConnection connection, boolean existingConnection) {
        return connection;
    }

    @Nullable
    protected <T> T postProcessResult(@Nullable T result, RedisConnection conn, boolean existingConnection) {
        return result;
    }

    public boolean isExposeConnection() {
        return this.exposeConnection;
    }

    public void setExposeConnection(boolean exposeConnection) {
        this.exposeConnection = exposeConnection;
    }

    public boolean isEnableDefaultSerializer() {
        return this.enableDefaultSerializer;
    }

    public void setEnableDefaultSerializer(boolean enableDefaultSerializer) {
        this.enableDefaultSerializer = enableDefaultSerializer;
    }

    @Nullable
    public RedisSerializer<?> getDefaultSerializer() {
        return this.defaultSerializer;
    }

    public void setDefaultSerializer(RedisSerializer<?> serializer) {
        this.defaultSerializer = serializer;
    }

    public void setKeySerializer(RedisSerializer<?> serializer) {
        this.keySerializer = serializer;
    }

    @Override
    public RedisSerializer<?> getKeySerializer() {
        return this.keySerializer;
    }

    public void setValueSerializer(RedisSerializer<?> serializer) {
        this.valueSerializer = serializer;
    }

    @Override
    public RedisSerializer<?> getValueSerializer() {
        return this.valueSerializer;
    }

    @Override
    public RedisSerializer<?> getHashKeySerializer() {
        return this.hashKeySerializer;
    }

    public void setHashKeySerializer(RedisSerializer<?> hashKeySerializer) {
        this.hashKeySerializer = hashKeySerializer;
    }

    @Override
    public RedisSerializer<?> getHashValueSerializer() {
        return this.hashValueSerializer;
    }

    public void setHashValueSerializer(RedisSerializer<?> hashValueSerializer) {
        this.hashValueSerializer = hashValueSerializer;
    }

    public RedisSerializer<String> getStringSerializer() {
        return this.stringSerializer;
    }

    public void setStringSerializer(RedisSerializer<String> stringSerializer) {
        this.stringSerializer = stringSerializer;
    }

    public void setScriptExecutor(ScriptExecutor<K> scriptExecutor) {
        this.scriptExecutor = scriptExecutor;
    }

    private byte[] rawKey(Object key) {
        Assert.notNull((Object)key, (String)"non null key required");
        if (this.keySerializer == null && key instanceof byte[]) {
            return (byte[])key;
        }
        return this.keySerializer.serialize(key);
    }

    private byte[] rawString(String key) {
        return this.stringSerializer.serialize(key);
    }

    private byte[] rawValue(Object value) {
        if (this.valueSerializer == null && value instanceof byte[]) {
            return (byte[])value;
        }
        return this.valueSerializer.serialize(value);
    }

    private byte[][] rawKeys(Collection<K> keys) {
        byte[][] rawKeys = new byte[keys.size()][];
        int i = 0;
        for (K key : keys) {
            rawKeys[i++] = this.rawKey(key);
        }
        return rawKeys;
    }

    private K deserializeKey(byte[] value) {
        return (K)(this.keySerializer != null ? (Object)this.keySerializer.deserialize(value) : value);
    }

    @Nullable
    private List<Object> deserializeMixedResults(@Nullable List<Object> rawValues, @Nullable RedisSerializer valueSerializer, @Nullable RedisSerializer hashKeySerializer, @Nullable RedisSerializer hashValueSerializer) {
        if (rawValues == null) {
            return null;
        }
        ArrayList<Object> values = new ArrayList<Object>();
        for (Object rawValue : rawValues) {
            if (rawValue instanceof byte[] && valueSerializer != null) {
                values.add(valueSerializer.deserialize((byte[])rawValue));
                continue;
            }
            if (rawValue instanceof List) {
                values.add(this.deserializeMixedResults((List)rawValue, valueSerializer, hashKeySerializer, hashValueSerializer));
                continue;
            }
            if (rawValue instanceof Set && !((Set)rawValue).isEmpty()) {
                values.add(this.deserializeSet((Set)rawValue, valueSerializer));
                continue;
            }
            if (rawValue instanceof Map && !((Map)rawValue).isEmpty() && ((Map)rawValue).values().iterator().next() instanceof byte[]) {
                values.add(SerializationUtils.deserialize((Map)rawValue, hashKeySerializer, hashValueSerializer));
                continue;
            }
            values.add(rawValue);
        }
        return values;
    }

    private Set<?> deserializeSet(Set rawSet, @Nullable RedisSerializer valueSerializer) {
        if (rawSet.isEmpty()) {
            return rawSet;
        }
        Object setValue = rawSet.iterator().next();
        if (setValue instanceof byte[] && valueSerializer != null) {
            return SerializationUtils.deserialize(rawSet, valueSerializer);
        }
        if (setValue instanceof RedisZSetCommands.Tuple) {
            return this.convertTupleValues(rawSet, valueSerializer);
        }
        return rawSet;
    }

    private Set<ZSetOperations.TypedTuple<V>> convertTupleValues(Set<RedisZSetCommands.Tuple> rawValues, @Nullable RedisSerializer valueSerializer) {
        LinkedHashSet<ZSetOperations.TypedTuple<V>> set = new LinkedHashSet<ZSetOperations.TypedTuple<V>>(rawValues.size());
        for (RedisZSetCommands.Tuple rawValue : rawValues) {
            Object value = rawValue.getValue();
            if (valueSerializer != null) {
                value = valueSerializer.deserialize(rawValue.getValue());
            }
            set.add(new DefaultTypedTuple<byte[]>((byte[])value, rawValue.getScore()));
        }
        return set;
    }

    @Override
    public List<Object> exec() {
        List<Object> results = this.execRaw();
        if (this.getRequiredConnectionFactory().getConvertPipelineAndTxResults()) {
            return this.deserializeMixedResults(results, this.valueSerializer, this.hashKeySerializer, this.hashValueSerializer);
        }
        return results;
    }

    @Override
    public List<Object> exec(RedisSerializer<?> valueSerializer) {
        return this.deserializeMixedResults(this.execRaw(), valueSerializer, valueSerializer, valueSerializer);
    }

    protected List<Object> execRaw() {
        List raw = this.execute(RedisTxCommands::exec);
        return raw == null ? Collections.emptyList() : raw;
    }

    @Override
    public Boolean delete(K key) {
        byte[] rawKey = this.rawKey(key);
        Long result = this.execute(connection -> connection.del(new byte[][]{rawKey}), true);
        return result != null && result.intValue() == 1;
    }

    @Override
    public Long delete(Collection<K> keys) {
        if (CollectionUtils.isEmpty(keys)) {
            return 0L;
        }
        byte[][] rawKeys = this.rawKeys(keys);
        return this.execute(connection -> connection.del(rawKeys), true);
    }

    @Override
    public Boolean unlink(K key) {
        byte[] rawKey = this.rawKey(key);
        Long result = this.execute(connection -> connection.unlink(new byte[][]{rawKey}), true);
        return result != null && result.intValue() == 1;
    }

    @Override
    public Long unlink(Collection<K> keys) {
        if (CollectionUtils.isEmpty(keys)) {
            return 0L;
        }
        byte[][] rawKeys = this.rawKeys(keys);
        return this.execute(connection -> connection.unlink(rawKeys), true);
    }

    @Override
    public Boolean hasKey(K key) {
        byte[] rawKey = this.rawKey(key);
        return this.execute(connection -> connection.exists(rawKey), true);
    }

    @Override
    public Long countExistingKeys(Collection<K> keys) {
        Assert.notNull(keys, (String)"Keys must not be null!");
        byte[][] rawKeys = this.rawKeys(keys);
        return this.execute(connection -> connection.exists(rawKeys), true);
    }

    @Override
    public Boolean expire(K key, long timeout, TimeUnit unit) {
        byte[] rawKey = this.rawKey(key);
        long rawTimeout = TimeoutUtils.toMillis(timeout, unit);
        return this.execute(connection -> {
            try {
                return connection.pExpire(rawKey, rawTimeout);
            }
            catch (Exception e) {
                return connection.expire(rawKey, TimeoutUtils.toSeconds(timeout, unit));
            }
        }, true);
    }

    @Override
    public Boolean expireAt(K key, Date date) {
        byte[] rawKey = this.rawKey(key);
        return this.execute(connection -> {
            try {
                return connection.pExpireAt(rawKey, date.getTime());
            }
            catch (Exception e) {
                return connection.expireAt(rawKey, date.getTime() / 1000L);
            }
        }, true);
    }

    @Override
    public void convertAndSend(String channel, Object message) {
        Assert.hasText((String)channel, (String)"a non-empty channel is required");
        byte[] rawChannel = this.rawString(channel);
        byte[] rawMessage = this.rawValue(message);
        this.execute(connection -> {
            connection.publish(rawChannel, rawMessage);
            return null;
        }, true);
    }

    @Override
    public Long getExpire(K key) {
        byte[] rawKey = this.rawKey(key);
        return this.execute(connection -> connection.ttl(rawKey), true);
    }

    @Override
    public Long getExpire(K key, TimeUnit timeUnit) {
        byte[] rawKey = this.rawKey(key);
        return this.execute(connection -> {
            try {
                return connection.pTtl(rawKey, timeUnit);
            }
            catch (Exception e) {
                return connection.ttl(rawKey, timeUnit);
            }
        }, true);
    }

    @Override
    public Set<K> keys(K pattern) {
        byte[] rawKey = this.rawKey(pattern);
        Set rawKeys = this.execute(connection -> connection.keys(rawKey), true);
        return this.keySerializer != null ? SerializationUtils.deserialize(rawKeys, this.keySerializer) : rawKeys;
    }

    @Override
    public Boolean persist(K key) {
        byte[] rawKey = this.rawKey(key);
        return this.execute(connection -> connection.persist(rawKey), true);
    }

    @Override
    public Boolean move(K key, int dbIndex) {
        byte[] rawKey = this.rawKey(key);
        return this.execute(connection -> connection.move(rawKey, dbIndex), true);
    }

    @Override
    public K randomKey() {
        byte[] rawKey = this.execute(RedisKeyCommands::randomKey, true);
        return this.deserializeKey(rawKey);
    }

    @Override
    public void rename(K oldKey, K newKey) {
        byte[] rawOldKey = this.rawKey(oldKey);
        byte[] rawNewKey = this.rawKey(newKey);
        this.execute(connection -> {
            connection.rename(rawOldKey, rawNewKey);
            return null;
        }, true);
    }

    @Override
    public Boolean renameIfAbsent(K oldKey, K newKey) {
        byte[] rawOldKey = this.rawKey(oldKey);
        byte[] rawNewKey = this.rawKey(newKey);
        return this.execute(connection -> connection.renameNX(rawOldKey, rawNewKey), true);
    }

    @Override
    public DataType type(K key) {
        byte[] rawKey = this.rawKey(key);
        return this.execute(connection -> connection.type(rawKey), true);
    }

    @Override
    public byte[] dump(K key) {
        byte[] rawKey = this.rawKey(key);
        return this.execute(connection -> connection.dump(rawKey), true);
    }

    @Override
    public void restore(K key, byte[] value, long timeToLive, TimeUnit unit, boolean replace) {
        byte[] rawKey = this.rawKey(key);
        long rawTimeout = TimeoutUtils.toMillis(timeToLive, unit);
        this.execute(connection -> {
            connection.restore(rawKey, rawTimeout, value, replace);
            return null;
        }, true);
    }

    @Override
    public void multi() {
        this.execute(connection -> {
            connection.multi();
            return null;
        }, true);
    }

    @Override
    public void discard() {
        this.execute(connection -> {
            connection.discard();
            return null;
        }, true);
    }

    @Override
    public void watch(K key) {
        byte[] rawKey = this.rawKey(key);
        this.execute(connection -> {
            connection.watch(new byte[][]{rawKey});
            return null;
        }, true);
    }

    @Override
    public void watch(Collection<K> keys) {
        byte[][] rawKeys = this.rawKeys(keys);
        this.execute(connection -> {
            connection.watch(rawKeys);
            return null;
        }, true);
    }

    @Override
    public void unwatch() {
        this.execute(connection -> {
            connection.unwatch();
            return null;
        }, true);
    }

    @Override
    public List<V> sort(SortQuery<K> query) {
        return this.sort(query, this.valueSerializer);
    }

    @Override
    public <T> List<T> sort(SortQuery<K> query, @Nullable RedisSerializer<T> resultSerializer) {
        byte[] rawKey = this.rawKey(query.getKey());
        SortParameters params = QueryUtils.convertQuery(query, this.stringSerializer);
        List vals = this.execute(connection -> connection.sort(rawKey, params), true);
        return SerializationUtils.deserialize(vals, resultSerializer);
    }

    @Override
    public <T> List<T> sort(SortQuery<K> query, BulkMapper<T, V> bulkMapper) {
        return this.sort(query, bulkMapper, this.valueSerializer);
    }

    @Override
    public <T, S> List<T> sort(SortQuery<K> query, BulkMapper<T, S> bulkMapper, @Nullable RedisSerializer<S> resultSerializer) {
        List<S> values = this.sort(query, resultSerializer);
        if (values == null || values.isEmpty()) {
            return Collections.emptyList();
        }
        int bulkSize = query.getGetPattern().size();
        ArrayList<T> result = new ArrayList<T>(values.size() / bulkSize + 1);
        ArrayList<S> bulk = new ArrayList<S>(bulkSize);
        for (S s : values) {
            bulk.add(s);
            if (bulk.size() != bulkSize) continue;
            result.add(bulkMapper.mapBulk(Collections.unmodifiableList(bulk)));
            bulk = new ArrayList(bulkSize);
        }
        return result;
    }

    @Override
    public Long sort(SortQuery<K> query, K storeKey) {
        byte[] rawStoreKey = this.rawKey(storeKey);
        byte[] rawKey = this.rawKey(query.getKey());
        SortParameters params = QueryUtils.convertQuery(query, this.stringSerializer);
        return this.execute(connection -> connection.sort(rawKey, params, rawStoreKey), true);
    }

    @Override
    public void killClient(String host, int port) {
        this.execute((RedisConnection connection) -> {
            connection.killClient(host, port);
            return null;
        });
    }

    @Override
    public List<RedisClientInfo> getClientList() {
        return this.execute(RedisServerCommands::getClientList);
    }

    @Override
    public void slaveOf(String host, int port) {
        this.execute((RedisConnection connection) -> {
            connection.slaveOf(host, port);
            return null;
        });
    }

    @Override
    public void slaveOfNoOne() {
        this.execute((RedisConnection connection) -> {
            connection.slaveOfNoOne();
            return null;
        });
    }

    @Override
    public ClusterOperations<K, V> opsForCluster() {
        return new DefaultClusterOperations(this);
    }

    @Override
    public GeoOperations<K, V> opsForGeo() {
        if (this.geoOps == null) {
            this.geoOps = new DefaultGeoOperations<K, V>(this);
        }
        return this.geoOps;
    }

    @Override
    public BoundGeoOperations<K, V> boundGeoOps(K key) {
        return new DefaultBoundGeoOperations(key, this);
    }

    @Override
    public <HK, HV> BoundHashOperations<K, HK, HV> boundHashOps(K key) {
        return new DefaultBoundHashOperations(key, this);
    }

    @Override
    public <HK, HV> HashOperations<K, HK, HV> opsForHash() {
        return new DefaultHashOperations(this);
    }

    @Override
    public HyperLogLogOperations<K, V> opsForHyperLogLog() {
        if (this.hllOps == null) {
            this.hllOps = new DefaultHyperLogLogOperations(this);
        }
        return this.hllOps;
    }

    @Override
    public ListOperations<K, V> opsForList() {
        if (this.listOps == null) {
            this.listOps = new DefaultListOperations(this);
        }
        return this.listOps;
    }

    @Override
    public BoundListOperations<K, V> boundListOps(K key) {
        return new DefaultBoundListOperations(key, this);
    }

    @Override
    public BoundSetOperations<K, V> boundSetOps(K key) {
        return new DefaultBoundSetOperations(key, this);
    }

    @Override
    public SetOperations<K, V> opsForSet() {
        if (this.setOps == null) {
            this.setOps = new DefaultSetOperations(this);
        }
        return this.setOps;
    }

    @Override
    public <HK, HV> StreamOperations<K, HK, HV> opsForStream() {
        if (this.streamOps == null) {
            this.streamOps = new DefaultStreamOperations<Object, byte[], byte[]>(this, new ObjectHashMapper());
        }
        return this.streamOps;
    }

    @Override
    public <HK, HV> StreamOperations<K, HK, HV> opsForStream(HashMapper<? super K, ? super HK, ? super HV> hashMapper) {
        return new DefaultStreamOperations<K, HK, HV>(this, hashMapper);
    }

    @Override
    public <HK, HV> BoundStreamOperations<K, HK, HV> boundStreamOps(K key) {
        return new DefaultBoundStreamOperations(key, this);
    }

    @Override
    public BoundValueOperations<K, V> boundValueOps(K key) {
        return new DefaultBoundValueOperations(key, this);
    }

    @Override
    public ValueOperations<K, V> opsForValue() {
        if (this.valueOps == null) {
            this.valueOps = new DefaultValueOperations(this);
        }
        return this.valueOps;
    }

    @Override
    public BoundZSetOperations<K, V> boundZSetOps(K key) {
        return new DefaultBoundZSetOperations(key, this);
    }

    @Override
    public ZSetOperations<K, V> opsForZSet() {
        if (this.zSetOps == null) {
            this.zSetOps = new DefaultZSetOperations(this);
        }
        return this.zSetOps;
    }

    public void setEnableTransactionSupport(boolean enableTransactionSupport) {
        this.enableTransactionSupport = enableTransactionSupport;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }
}

