/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.repository;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.Metamodel;
import org.springframework.aop.support.AopUtils;
import org.springframework.aop.target.SingletonTargetSource;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.rest.repository.JpaEntityMetadata;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class JpaRepositoryMetadata
implements InitializingBean,
ApplicationContextAware {
    private ApplicationContext applicationContext;
    private Map<Class<?>, RepositoryCacheEntry> repositories = new HashMap();
    private EntityManager entityManager;
    private Metamodel metamodel;

    @PersistenceContext
    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
        this.metamodel = entityManager.getMetamodel();
    }

    public EntityManager entityManager() {
        return this.entityManager;
    }

    public <T> CrudRepository<T, ? extends Serializable> repositoryFor(String name) {
        if (null != name) {
            for (Map.Entry<Class<?>, RepositoryCacheEntry> entry : this.repositories.entrySet()) {
                if (!name.equals(this.repositoryNameFor(entry.getValue().repository))) continue;
                return entry.getValue().repository;
            }
        }
        return null;
    }

    public <T> CrudRepository<T, ? extends Serializable> repositoryFor(Class<T> domainClass) {
        RepositoryCacheEntry entry = this.repositories.get(domainClass);
        if (null != entry) {
            return entry.repository;
        }
        return null;
    }

    public <T> EntityInformation<T, ? extends Serializable> entityInfoFor(Class<T> domainClass) {
        RepositoryCacheEntry entry = this.repositories.get(domainClass);
        if (null != entry) {
            return entry.entityInfo;
        }
        return null;
    }

    public <T> EntityType<T> entityTypeFor(Class<T> domainClass) {
        return this.metamodel.entity(domainClass);
    }

    public <T> EntityInformation<T, ? extends Serializable> entityInfoFor(CrudRepository<T, ? extends Serializable> repository) {
        for (Map.Entry<Class<?>, RepositoryCacheEntry> entry : this.repositories.entrySet()) {
            if (entry.getValue().repository != repository) continue;
            return entry.getValue().entityInfo;
        }
        return null;
    }

    public <T> JpaEntityMetadata entityMetadataFor(Class<T> domainClass) {
        RepositoryCacheEntry entry = this.repositories.get(domainClass);
        if (null == entry.entityMetadata) {
            entry.entityMetadata = new JpaEntityMetadata(this.metamodel.entity(domainClass), this);
        }
        return entry.entityMetadata;
    }

    public String repositoryNameFor(Class<?> domainClass) {
        RepositoryCacheEntry entry = this.repositories.get(domainClass);
        if (null != entry) {
            return entry.name;
        }
        return null;
    }

    public String repositoryNameFor(CrudRepository repository) {
        for (Map.Entry<Class<?>, RepositoryCacheEntry> entry : this.repositories.entrySet()) {
            if (entry.getValue().repository != repository) continue;
            return entry.getValue().name;
        }
        return null;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public List<String> repositoryNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (Map.Entry<Class<?>, RepositoryCacheEntry> entry : this.repositories.entrySet()) {
            names.add(entry.getValue().name);
        }
        return names;
    }

    public void setRepositories(Collection<? extends CrudRepository> repositories) {
        for (CrudRepository crudRepository : repositories) {
            Class repoClass = AopUtils.getTargetClass((Object)crudRepository);
            Field infoField = ReflectionUtils.findField((Class)repoClass, (String)"entityInformation");
            ReflectionUtils.makeAccessible((Field)infoField);
            Method m = ReflectionUtils.findMethod(crudRepository.getClass(), (String)"getTargetSource");
            ReflectionUtils.makeAccessible((Method)m);
            try {
                SingletonTargetSource targetRepo = (SingletonTargetSource)m.invoke((Object)crudRepository, new Object[0]);
                EntityInformation entityInfo = (EntityInformation)infoField.get(targetRepo.getTarget());
                Class<?>[] intfs = crudRepository.getClass().getInterfaces();
                String name = StringUtils.uncapitalize((String)intfs[0].getSimpleName().replaceAll("Repository", ""));
                this.repositories.put(entityInfo.getJavaType(), new RepositoryCacheEntry(name, crudRepository, entityInfo, null));
            }
            catch (Throwable t) {
                throw new IllegalStateException(t);
            }
        }
    }

    public void afterPropertiesSet() throws Exception {
        if (this.repositories.isEmpty()) {
            for (ApplicationContext appCtx = this.applicationContext; null != appCtx; appCtx = appCtx.getParent()) {
                Map beans = appCtx.getBeansOfType(CrudRepository.class);
                this.setRepositories(beans.values());
            }
        }
    }

    private class RepositoryCacheEntry {
        String name;
        CrudRepository repository;
        EntityInformation entityInfo;
        JpaEntityMetadata entityMetadata;

        private RepositoryCacheEntry(String name, CrudRepository repository, EntityInformation entityInfo, JpaEntityMetadata entityMetadata) {
            this.name = name;
            this.repository = repository;
            this.entityInfo = entityInfo;
            this.entityMetadata = entityMetadata;
        }
    }
}

