/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.persistence.EntityManagerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportResource;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.data.rest.repository.JpaRepositoryMetadata;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJacksonHttpMessageConverter;
import org.springframework.orm.jpa.support.PersistenceAnnotationBeanPostProcessor;

@Configuration
@ImportResource(value={"classpath*:META-INF/spring-data-rest/**/*-export.xml"})
public class RepositoryRestConfiguration {
    @Autowired
    EntityManagerFactory entityManagerFactory;
    @Autowired(required=false)
    JpaRepositoryMetadata jpaRepositoryMetadata;
    @Autowired(required=false)
    ConversionService customConversionService;
    ConversionService defaultConversionService = new DefaultConversionService();
    @Autowired(required=false)
    List<HttpMessageConverter<?>> httpMessageConverters = new ArrayList();

    @Bean
    ConversionService conversionService() {
        if (null != this.customConversionService) {
            return this.customConversionService;
        }
        return this.defaultConversionService;
    }

    @Bean
    List<HttpMessageConverter<?>> httpMessageConverters() {
        if (this.httpMessageConverters.isEmpty()) {
            MappingJacksonHttpMessageConverter json = new MappingJacksonHttpMessageConverter();
            json.setSupportedMediaTypes(Arrays.asList(MediaType.APPLICATION_JSON, MediaType.valueOf((String)"application/x-spring-data+json")));
            this.httpMessageConverters.add((HttpMessageConverter<?>)json);
        }
        return this.httpMessageConverters;
    }

    @Bean
    JpaRepositoryMetadata jpaRepositoryMetadata() throws Exception {
        if (null == this.jpaRepositoryMetadata) {
            this.jpaRepositoryMetadata = new JpaRepositoryMetadata();
        }
        return this.jpaRepositoryMetadata;
    }

    @Bean
    PersistenceAnnotationBeanPostProcessor persistenceAnnotationBeanPostProcessor() {
        return new PersistenceAnnotationBeanPostProcessor();
    }
}

