/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.rest.webmvc.JsonView;
import org.springframework.data.rest.webmvc.RepositoryRestConfiguration;
import org.springframework.data.rest.webmvc.RepositoryRestController;
import org.springframework.data.rest.webmvc.ServerHttpRequestMethodArgumentResolver;
import org.springframework.data.rest.webmvc.UriListView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.mvc.annotation.ResponseStatusExceptionResolver;
import org.springframework.web.servlet.mvc.method.annotation.ExceptionHandlerExceptionResolver;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;
import org.springframework.web.servlet.mvc.support.DefaultHandlerExceptionResolver;
import org.springframework.web.servlet.view.ContentNegotiatingViewResolver;

@Configuration
public class RepositoryRestMvcConfiguration {
    @Autowired
    RepositoryRestConfiguration parentConfig;
    RepositoryRestController repositoryRestController;

    @Bean
    ContentNegotiatingViewResolver contentNegotiatingViewResolver() {
        ContentNegotiatingViewResolver viewResolver = new ContentNegotiatingViewResolver();
        HashMap<String, String> jsonTypes = new HashMap<String, String>(){
            {
                this.put("json", "application/json");
                this.put("sdjson", "application/x-spring-data+json");
                this.put("urilist", "text/uri-list");
            }
        };
        viewResolver.setMediaTypes((Map)jsonTypes);
        viewResolver.setDefaultViews(Arrays.asList(new View[]{new JsonView("application/json"), new JsonView("application/x-spring-data+json"), new UriListView()}));
        return viewResolver;
    }

    @Bean
    RepositoryRestController repositoryRestController() throws Exception {
        if (null == this.repositoryRestController) {
            this.repositoryRestController = new RepositoryRestController().repositoryMetadata(this.parentConfig.jpaRepositoryMetadata()).conversionService(this.parentConfig.conversionService()).httpMessageConverters(this.parentConfig.httpMessageConverters()).jsonMediaType("application/json");
        }
        return this.repositoryRestController;
    }

    @Bean
    RequestMappingHandlerMapping handlerMapping() {
        return new RequestMappingHandlerMapping();
    }

    @Bean
    RequestMappingHandlerAdapter handlerAdapter() {
        RequestMappingHandlerAdapter handlerAdapter = new RequestMappingHandlerAdapter();
        handlerAdapter.setCustomArgumentResolvers(Arrays.asList(new ServerHttpRequestMethodArgumentResolver()));
        return handlerAdapter;
    }

    @Bean
    ExceptionHandlerExceptionResolver exceptionHandlerExceptionResolver() {
        return new ExceptionHandlerExceptionResolver();
    }

    @Bean
    DefaultHandlerExceptionResolver handlerExceptionResolver() {
        return new DefaultHandlerExceptionResolver();
    }

    @Bean
    ResponseStatusExceptionResolver responseStatusExceptionResolver() {
        return new ResponseStatusExceptionResolver();
    }
}

