/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc;

import java.util.Arrays;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportResource;
import org.springframework.data.rest.repository.UriToDomainObjectUriResolver;
import org.springframework.data.rest.repository.context.ValidatingRepositoryEventListener;
import org.springframework.data.rest.repository.jpa.JpaRepositoryExporter;
import org.springframework.data.rest.webmvc.BaseUriMethodArgumentResolver;
import org.springframework.data.rest.webmvc.PagingAndSortingMethodArgumentResolver;
import org.springframework.data.rest.webmvc.RepositoryAwareMappingHttpMessageConverter;
import org.springframework.data.rest.webmvc.RepositoryRestConfiguration;
import org.springframework.data.rest.webmvc.RepositoryRestController;
import org.springframework.data.rest.webmvc.RepositoryRestHandlerAdapter;
import org.springframework.data.rest.webmvc.RepositoryRestHandlerMapping;
import org.springframework.data.rest.webmvc.ServerHttpRequestMethodArgumentResolver;
import org.springframework.data.rest.webmvc.json.JsonSchemaController;
import org.springframework.data.rest.webmvc.json.RepositoryAwareJacksonModule;
import org.springframework.orm.jpa.support.PersistenceAnnotationBeanPostProcessor;
import org.springframework.web.servlet.mvc.method.annotation.ExceptionHandlerExceptionResolver;

@Configuration
@ImportResource(value={"classpath*:META-INF/spring-data-rest/**/*-export.xml"})
public class RepositoryRestMvcConfiguration {
    @Autowired(required=false)
    protected JpaRepositoryExporter customJpaRepositoryExporter;
    @Autowired(required=false)
    protected ValidatingRepositoryEventListener validatingRepositoryEventListener;
    @Autowired(required=false)
    protected RepositoryRestConfiguration repositoryRestConfig = RepositoryRestConfiguration.DEFAULT;

    @Bean
    public PersistenceAnnotationBeanPostProcessor persistenceAnnotationBeanPostProcessor() {
        return new PersistenceAnnotationBeanPostProcessor();
    }

    @Bean
    public JpaRepositoryExporter jpaRepositoryExporter() {
        if (null == this.customJpaRepositoryExporter) {
            return new JpaRepositoryExporter();
        }
        return this.customJpaRepositoryExporter;
    }

    @Bean
    public ValidatingRepositoryEventListener validatingRepositoryEventListener() {
        return null == this.validatingRepositoryEventListener ? new ValidatingRepositoryEventListener() : this.validatingRepositoryEventListener;
    }

    @Bean
    public RepositoryAwareJacksonModule jacksonModule() {
        return new RepositoryAwareJacksonModule();
    }

    @Bean
    public RepositoryAwareMappingHttpMessageConverter mappingHttpMessageConverter() {
        return new RepositoryAwareMappingHttpMessageConverter();
    }

    @Bean
    public UriToDomainObjectUriResolver domainObjectResolver() {
        return new UriToDomainObjectUriResolver();
    }

    @Bean
    public RepositoryRestController repositoryRestController() throws Exception {
        return new RepositoryRestController();
    }

    @Bean
    public JsonSchemaController jsonSchemaController() {
        return new JsonSchemaController();
    }

    @Bean
    public BaseUriMethodArgumentResolver baseUriMethodArgumentResolver() {
        return new BaseUriMethodArgumentResolver();
    }

    @Bean
    public PagingAndSortingMethodArgumentResolver pagingAndSortingMethodArgumentResolver() {
        return new PagingAndSortingMethodArgumentResolver();
    }

    @Bean
    public ServerHttpRequestMethodArgumentResolver serverHttpRequestMethodArgumentResolver() {
        return new ServerHttpRequestMethodArgumentResolver();
    }

    @Bean
    public RepositoryRestHandlerAdapter repositoryExporterHandlerAdapter() {
        return new RepositoryRestHandlerAdapter();
    }

    @Bean
    public RepositoryRestHandlerMapping repositoryExporterHandlerMapping() {
        return new RepositoryRestHandlerMapping();
    }

    @Bean
    public ExceptionHandlerExceptionResolver exceptionHandlerExceptionResolver() {
        ExceptionHandlerExceptionResolver er = new ExceptionHandlerExceptionResolver();
        er.setCustomArgumentResolvers(Arrays.asList(new ServerHttpRequestMethodArgumentResolver()));
        return er;
    }
}

