/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.json;

import java.io.IOException;
import java.util.Arrays;
import org.codehaus.jackson.JsonEncoding;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.data.rest.webmvc.MediaTypes;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.http.converter.json.MappingJacksonHttpMessageConverter;

public abstract class JacksonUtil {
    private JacksonUtil() {
    }

    public static MappingJacksonHttpMessageConverter createJacksonHttpMessageConverter(final ObjectMapper objectMapper) {
        MappingJacksonHttpMessageConverter jsonConverter = new MappingJacksonHttpMessageConverter(){
            {
                this.setSupportedMediaTypes(Arrays.asList(MediaType.APPLICATION_JSON, MediaTypes.COMPACT_JSON, MediaTypes.VERBOSE_JSON));
            }

            public boolean canRead(Class<?> clazz, MediaType mediaType) {
                return this.canRead(mediaType);
            }

            public boolean canWrite(Class<?> clazz, MediaType mediaType) {
                return this.canWrite(mediaType);
            }

            protected void writeInternal(Object object, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
                JsonEncoding encoding = this.getJsonEncoding(outputMessage.getHeaders().getContentType());
                JsonGenerator jsonGenerator = objectMapper.getJsonFactory().createJsonGenerator(outputMessage.getBody(), encoding).useDefaultPrettyPrinter();
                try {
                    objectMapper.writeValue(jsonGenerator, object);
                }
                catch (IOException ex) {
                    throw new HttpMessageNotWritableException("Could not write JSON: " + ex.getMessage(), (Throwable)ex);
                }
            }
        };
        jsonConverter.setObjectMapper(objectMapper);
        return jsonConverter;
    }
}

