/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc;

import com.google.common.base.Function;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.springframework.context.ApplicationEvent;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.model.BeanWrapper;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.support.DomainClassConverter;
import org.springframework.data.repository.support.Repositories;
import org.springframework.data.rest.config.RepositoryRestConfiguration;
import org.springframework.data.rest.config.ResourceMapping;
import org.springframework.data.rest.core.util.UriUtils;
import org.springframework.data.rest.repository.PersistentEntityResource;
import org.springframework.data.rest.repository.context.AfterLinkDeleteEvent;
import org.springframework.data.rest.repository.context.AfterLinkSaveEvent;
import org.springframework.data.rest.repository.context.BeforeLinkDeleteEvent;
import org.springframework.data.rest.repository.context.BeforeLinkSaveEvent;
import org.springframework.data.rest.repository.invoke.RepositoryMethodInvoker;
import org.springframework.data.rest.repository.support.ResourceMappingUtils;
import org.springframework.data.rest.webmvc.AbstractRepositoryRestController;
import org.springframework.data.rest.webmvc.RepositoryRestRequest;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.hateoas.EntityLinks;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Resource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/{repository}/{id}/{property}"})
public class RepositoryPropertyReferenceController
extends AbstractRepositoryRestController {
    public RepositoryPropertyReferenceController(Repositories repositories, RepositoryRestConfiguration config, DomainClassConverter domainClassConverter, ConversionService conversionService, EntityLinks entityLinks) {
        super(repositories, config, domainClassConverter, conversionService, entityLinks);
    }

    @RequestMapping(method={RequestMethod.GET}, produces={"application/json", "application/x-spring-data-verbose+json"})
    @ResponseBody
    public ResponseEntity<Resource<?>> followPropertyReference(final RepositoryRestRequest repoRequest, @PathVariable String id, @PathVariable String property) throws ResourceNotFoundException, NoSuchMethodException {
        final HttpHeaders headers = new HttpHeaders();
        Function handler = new Function<ReferencedProperty, Resource<?>>(){

            public Resource<?> apply(ReferencedProperty prop) {
                if (prop.property.isCollectionLike()) {
                    ArrayList<PersistentEntityResource> resources = new ArrayList<PersistentEntityResource>();
                    PersistentEntity entity = RepositoryPropertyReferenceController.this.repositories.getPersistentEntity(prop.propertyType);
                    for (Object obj : (Iterable)prop.propertyValue) {
                        BeanWrapper wrapper = BeanWrapper.create(obj, (ConversionService)RepositoryPropertyReferenceController.this.conversionService);
                        PersistentEntityResource per = PersistentEntityResource.wrap((PersistentEntity)entity, obj, (URI)repoRequest.getBaseUri());
                        Link selfLink = RepositoryPropertyReferenceController.this.entityLinks.linkForSingleResource(entity.getType(), wrapper.getProperty(entity.getIdProperty())).withSelfRel();
                        per.add(selfLink);
                        resources.add(per);
                    }
                    return new Resource(resources, new Link[0]);
                }
                if (prop.property.isMap()) {
                    HashMap resources = new HashMap();
                    PersistentEntity entity = RepositoryPropertyReferenceController.this.repositories.getPersistentEntity(prop.propertyType);
                    for (Map.Entry entry : ((Map)prop.propertyValue).entrySet()) {
                        PersistentEntityResource per = PersistentEntityResource.wrap((PersistentEntity)entity, entry.getValue(), (URI)repoRequest.getBaseUri());
                        BeanWrapper wrapper = BeanWrapper.create(entry.getValue(), (ConversionService)RepositoryPropertyReferenceController.this.conversionService);
                        Link selfLink = RepositoryPropertyReferenceController.this.entityLinks.linkForSingleResource(entity.getType(), wrapper.getProperty(entity.getIdProperty())).withSelfRel();
                        per.add(selfLink);
                        resources.put(entry.getKey(), per);
                    }
                    return new Resource(resources, new Link[0]);
                }
                PersistentEntityResource per = PersistentEntityResource.wrap((PersistentEntity)RepositoryPropertyReferenceController.this.repositories.getPersistentEntity(prop.propertyType), (Object)prop.propertyValue, (URI)repoRequest.getBaseUri());
                BeanWrapper wrapper = BeanWrapper.create((Object)prop.propertyValue, (ConversionService)RepositoryPropertyReferenceController.this.conversionService);
                Link selfLink = RepositoryPropertyReferenceController.this.entityLinks.linkForSingleResource(prop.propertyType, wrapper.getProperty(prop.entity.getIdProperty())).withSelfRel();
                per.add(selfLink);
                headers.set("Content-Location", selfLink.getHref());
                return new Resource((Object)per, new Link[0]);
            }
        };
        Resource<?> responseResource = this.doWithReferencedProperty(repoRequest, id, property, handler);
        return this.resourceResponse(headers, responseResource, HttpStatus.OK);
    }

    @RequestMapping(value={"/{propertyId}"}, method={RequestMethod.GET}, produces={"application/json", "application/x-spring-data-verbose+json", "application/x-spring-data-compact+json", "text/uri-list"})
    @ResponseBody
    public ResponseEntity<Resource<?>> followPropertyReference(final RepositoryRestRequest repoRequest, @PathVariable String id, @PathVariable String property, final @PathVariable String propertyId) throws ResourceNotFoundException, NoSuchMethodException {
        final HttpHeaders headers = new HttpHeaders();
        Function handler = new Function<ReferencedProperty, Resource<?>>(){

            public Resource<?> apply(ReferencedProperty prop) {
                if (prop.property.isCollectionLike()) {
                    PersistentEntity entity = RepositoryPropertyReferenceController.this.repositories.getPersistentEntity(prop.propertyType);
                    for (Object obj : (Iterable)prop.propertyValue) {
                        BeanWrapper propValWrapper = BeanWrapper.create(obj, (ConversionService)RepositoryPropertyReferenceController.this.conversionService);
                        String sId = propValWrapper.getProperty(prop.entity.getIdProperty()).toString();
                        if (!propertyId.equals(sId)) continue;
                        PersistentEntityResource per = PersistentEntityResource.wrap((PersistentEntity)entity, obj, (URI)repoRequest.getBaseUri());
                        Link selfLink = RepositoryPropertyReferenceController.this.entityLinks.linkForSingleResource(entity.getType(), (Object)sId).withSelfRel();
                        per.add(selfLink);
                        headers.set("Content-Location", selfLink.getHref());
                        return per;
                    }
                } else if (prop.property.isMap()) {
                    PersistentEntity entity = RepositoryPropertyReferenceController.this.repositories.getPersistentEntity(prop.propertyType);
                    for (Map.Entry entry : ((Map)prop.propertyValue).entrySet()) {
                        BeanWrapper propValWrapper = BeanWrapper.create(entry.getValue(), (ConversionService)RepositoryPropertyReferenceController.this.conversionService);
                        String sId = propValWrapper.getProperty(prop.entity.getIdProperty()).toString();
                        if (!propertyId.equals(sId)) continue;
                        PersistentEntityResource per = PersistentEntityResource.wrap((PersistentEntity)entity, entry.getValue(), (URI)repoRequest.getBaseUri());
                        Link selfLink = RepositoryPropertyReferenceController.this.entityLinks.linkForSingleResource(entity.getType(), (Object)sId).withSelfRel();
                        per.add(selfLink);
                        headers.set("Content-Location", selfLink.getHref());
                        return per;
                    }
                } else {
                    return new Resource(prop.propertyValue, new Link[0]);
                }
                throw new IllegalArgumentException(new ResourceNotFoundException());
            }
        };
        Resource<?> responseResource = this.doWithReferencedProperty(repoRequest, id, property, handler);
        return this.resourceResponse(headers, responseResource, HttpStatus.OK);
    }

    @RequestMapping(method={RequestMethod.GET}, produces={"application/x-spring-data-compact+json", "text/uri-list"})
    @ResponseBody
    public ResponseEntity<Resource<?>> followPropertyReferenceCompact(RepositoryRestRequest repoRequest, @PathVariable String id, @PathVariable String property) throws ResourceNotFoundException, NoSuchMethodException {
        ResponseEntity<Resource<?>> response = this.followPropertyReference(repoRequest, id, property);
        if (response.getStatusCode() != HttpStatus.OK) {
            return response;
        }
        ResourceMapping repoMapping = repoRequest.getRepositoryResourceMapping();
        ResourceMapping entityMapping = repoRequest.getPersistentEntityResourceMapping();
        String propName = entityMapping.getNameForPath(property);
        ResourceMapping propMapping = entityMapping.getResourceMappingFor(entityMapping.getNameForPath(property));
        PersistentProperty persistentProp = repoRequest.getPersistentEntity().getPersistentProperty(propName);
        Class propType = persistentProp.isCollectionLike() || persistentProp.isMap() ? persistentProp.getComponentType() : persistentProp.getType();
        ResourceMapping propRepoMapping = ResourceMappingUtils.getResourceMapping((RepositoryRestConfiguration)this.config, (RepositoryInformation)this.repositories.getRepositoryInformationFor(propType));
        String propRel = String.format("%s.%s.%s.%s", repoMapping.getRel(), entityMapping.getRel(), null != propMapping ? propMapping.getRel() : property, propRepoMapping.getRel());
        Resource resource = (Resource)response.getBody();
        ArrayList<Link> links = new ArrayList<Link>();
        URI entityBaseUri = UriUtils.buildUri((URI)repoRequest.getBaseUri(), (String[])new String[]{repoMapping.getPath(), id, property});
        if (resource.getContent() instanceof Iterable) {
            for (Resource res : (Iterable)resource.getContent()) {
                Link propLink = this.propertyReferenceLink(res, entityBaseUri, propRel);
                links.add(propLink);
            }
        } else if (resource.getContent() instanceof Map) {
            for (Map.Entry entry : ((Map)resource.getContent()).entrySet()) {
                Link l = new Link(((Resource)entry.getValue()).getLink("self").getHref(), (String)this.conversionService.convert(entry.getKey(), String.class));
                links.add(l);
            }
        } else {
            links.add(new Link(entityBaseUri.toString(), propRel));
        }
        return this.resourceResponse(null, new Resource((Object)EMPTY_RESOURCE_LIST, links), HttpStatus.OK);
    }

    @RequestMapping(method={RequestMethod.POST, RequestMethod.PUT}, consumes={"application/json", "application/x-spring-data-compact+json", "text/uri-list"})
    @ResponseBody
    public ResponseEntity<Resource<?>> createPropertyReference(final RepositoryRestRequest repoRequest, final @RequestBody Resource<Object> incoming, @PathVariable String id, @PathVariable String property) throws ResourceNotFoundException, NoSuchMethodException {
        final RepositoryMethodInvoker repoMethodInvoker = repoRequest.getRepositoryMethodInvoker();
        if (!repoMethodInvoker.hasSaveOne()) {
            throw new NoSuchMethodException();
        }
        Function handler = new Function<ReferencedProperty, Resource<?>>(){

            public Resource<?> apply(ReferencedProperty prop) {
                if (prop.property.isCollectionLike()) {
                    ArrayList<Object> coll = new ArrayList<Object>();
                    if ("POST".equals(repoRequest.getRequest().getMethod())) {
                        coll.addAll((Collection)prop.propertyValue);
                    }
                    for (Link l : incoming.getLinks()) {
                        Object propVal = RepositoryPropertyReferenceController.this.loadPropertyValue(prop.propertyType, l.getHref());
                        coll.add(propVal);
                    }
                    prop.wrapper.setProperty(prop.property, coll);
                } else if (prop.property.isMap()) {
                    HashMap<String, Object> m = new HashMap<String, Object>();
                    if ("POST".equals(repoRequest.getRequest().getMethod())) {
                        m.putAll((Map)prop.propertyValue);
                    }
                    for (Link l : incoming.getLinks()) {
                        Object propVal = RepositoryPropertyReferenceController.this.loadPropertyValue(prop.propertyType, l.getHref());
                        m.put(l.getRel(), propVal);
                    }
                    prop.wrapper.setProperty(prop.property, m);
                } else {
                    if ("POST".equals(repoRequest.getRequest().getMethod())) {
                        throw new IllegalStateException("Cannot POST a reference to this singular property since the property type is not a List or a Map.");
                    }
                    if (incoming.getLinks().size() != 1) {
                        throw new IllegalArgumentException("Must send only 1 link to update a property reference that isn't a List or a Map.");
                    }
                    Object propVal = RepositoryPropertyReferenceController.this.loadPropertyValue(prop.propertyType, ((Link)incoming.getLinks().get(0)).getHref());
                    prop.wrapper.setProperty(prop.property, propVal);
                }
                RepositoryPropertyReferenceController.this.applicationContext.publishEvent((ApplicationEvent)new BeforeLinkSaveEvent(prop.wrapper.getBean(), prop.propertyValue));
                Object result = repoMethodInvoker.save(prop.wrapper.getBean());
                RepositoryPropertyReferenceController.this.applicationContext.publishEvent((ApplicationEvent)new AfterLinkSaveEvent(result, prop.propertyValue));
                return null;
            }
        };
        this.doWithReferencedProperty(repoRequest, id, property, handler);
        return this.resourceResponse(null, EMPTY_RESOURCE, HttpStatus.CREATED);
    }

    @RequestMapping(value={"/{propertyId}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseEntity<Resource<?>> deletePropertyReference(RepositoryRestRequest repoRequest, @PathVariable String id, @PathVariable String property, final @PathVariable String propertyId) throws ResourceNotFoundException, NoSuchMethodException {
        final RepositoryMethodInvoker repoMethodInvoker = repoRequest.getRepositoryMethodInvoker();
        if (!repoMethodInvoker.hasDeleteOne()) {
            throw new NoSuchMethodException();
        }
        Function handler = new Function<ReferencedProperty, Resource<?>>(){

            public Resource<?> apply(ReferencedProperty prop) {
                if (null == prop.propertyValue) {
                    return null;
                }
                if (prop.property.isCollectionLike()) {
                    ArrayList coll = new ArrayList();
                    for (Object obj : (Collection)prop.propertyValue) {
                        BeanWrapper propValWrapper = BeanWrapper.create(obj, (ConversionService)RepositoryPropertyReferenceController.this.conversionService);
                        String s = (String)propValWrapper.getProperty(prop.entity.getIdProperty(), String.class, false);
                        if (propertyId.equals(s)) continue;
                        coll.add(obj);
                    }
                    prop.wrapper.setProperty(prop.property, coll);
                } else if (prop.property.isMap()) {
                    HashMap m = new HashMap();
                    for (Map.Entry entry : ((Map)prop.propertyValue).entrySet()) {
                        BeanWrapper propValWrapper = BeanWrapper.create(entry.getValue(), (ConversionService)RepositoryPropertyReferenceController.this.conversionService);
                        String s = (String)propValWrapper.getProperty(prop.entity.getIdProperty(), String.class, false);
                        if (propertyId.equals(s)) continue;
                        m.put(entry.getKey(), entry.getValue());
                    }
                    prop.wrapper.setProperty(prop.property, m);
                } else {
                    prop.wrapper.setProperty(prop.property, null);
                }
                RepositoryPropertyReferenceController.this.applicationContext.publishEvent((ApplicationEvent)new BeforeLinkDeleteEvent(prop.wrapper.getBean(), prop.propertyValue));
                Object result = repoMethodInvoker.save(prop.wrapper.getBean());
                RepositoryPropertyReferenceController.this.applicationContext.publishEvent((ApplicationEvent)new AfterLinkDeleteEvent(result, prop.propertyValue));
                return null;
            }
        };
        this.doWithReferencedProperty(repoRequest, id, property, handler);
        return this.resourceResponse(null, EMPTY_RESOURCE, HttpStatus.NO_CONTENT);
    }

    private Link propertyReferenceLink(Resource<?> resource, URI baseUri, String rel) {
        Link selfLink = resource.getLink("self");
        String objId = selfLink.getHref().substring(selfLink.getHref().lastIndexOf(47) + 1);
        return new Link(UriUtils.buildUri((URI)baseUri, (String[])new String[]{objId}).toString(), rel);
    }

    private Object loadPropertyValue(Class<?> type, String href) {
        String id = href.substring(href.lastIndexOf(47) + 1);
        return this.domainClassConverter.convert((Object)id, STRING_TYPE, TypeDescriptor.valueOf(type));
    }

    private Resource<?> doWithReferencedProperty(RepositoryRestRequest repoRequest, String id, String propertyPath, Function<ReferencedProperty, Resource<?>> handler) throws ResourceNotFoundException, NoSuchMethodException {
        RepositoryMethodInvoker repoMethodInvoker = repoRequest.getRepositoryMethodInvoker();
        if (!repoMethodInvoker.hasFindOne()) {
            throw new NoSuchMethodException();
        }
        Object domainObj = this.domainClassConverter.convert((Object)id, STRING_TYPE, TypeDescriptor.valueOf((Class)repoRequest.getPersistentEntity().getType()));
        if (null == domainObj) {
            throw new ResourceNotFoundException();
        }
        String propertyName = repoRequest.getPersistentEntityResourceMapping().getNameForPath(propertyPath);
        PersistentProperty prop = repoRequest.getPersistentEntity().getPersistentProperty(propertyName);
        if (null == prop) {
            throw new ResourceNotFoundException();
        }
        BeanWrapper wrapper = BeanWrapper.create((Object)domainObj, (ConversionService)this.conversionService);
        Object propVal = wrapper.getProperty(prop);
        if (null == propVal) {
            throw new ResourceNotFoundException();
        }
        return (Resource)handler.apply((Object)new ReferencedProperty(prop, propVal, wrapper));
    }

    private class ReferencedProperty {
        final PersistentEntity entity;
        final PersistentProperty property;
        final Class<?> propertyType;
        final Object propertyValue;
        final BeanWrapper wrapper;
        final RepositoryInformation propertyRepoInfo;
        final Object propertyRepo;
        final RepositoryMethodInvoker repoMethodInvoker;

        private ReferencedProperty(PersistentProperty property, Object propertyValue, BeanWrapper wrapper) {
            this.property = property;
            this.propertyValue = propertyValue;
            this.wrapper = wrapper;
            this.propertyType = property.isCollectionLike() ? property.getComponentType() : (property.isMap() ? property.getMapValueType() : property.getType());
            this.propertyRepoInfo = RepositoryPropertyReferenceController.this.repositories.getRepositoryInformationFor(this.propertyType);
            this.entity = RepositoryPropertyReferenceController.this.repositories.getPersistentEntity(this.propertyType);
            this.propertyRepo = RepositoryPropertyReferenceController.this.repositories.getRepositoryFor(this.entity.getType());
            this.repoMethodInvoker = new RepositoryMethodInvoker(this.propertyRepo, this.propertyRepoInfo, this.entity);
        }
    }
}

