/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.convert;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Resource;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;

public class UriListHttpMessageConverter
implements HttpMessageConverter<Resource<?>> {
    private static final List<MediaType> MEDIA_TYPES = new ArrayList<MediaType>();

    public boolean canRead(Class<?> clazz, MediaType mediaType) {
        if (null == mediaType) {
            return false;
        }
        return Resource.class.isAssignableFrom(clazz) && mediaType.getSubtype().contains("uri-list");
    }

    public boolean canWrite(Class<?> clazz, MediaType mediaType) {
        return this.canRead(clazz, mediaType);
    }

    public List<MediaType> getSupportedMediaTypes() {
        return MEDIA_TYPES;
    }

    public Resource<?> read(Class<? extends Resource<?>> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        String line;
        ArrayList<Link> links = new ArrayList<Link>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputMessage.getBody()));
        while (null != (line = reader.readLine())) {
            links.add(new Link(line));
        }
        return new Resource(Collections.emptyList(), links);
    }

    public void write(Resource<?> resource, MediaType contentType, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputMessage.getBody()));
        for (Link link : resource.getLinks()) {
            writer.write(link.getHref());
            writer.newLine();
        }
        writer.flush();
    }

    static {
        MEDIA_TYPES.add(MediaType.parseMediaType((String)"text/uri-list"));
    }
}

