/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Arrays;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Resource;

public class PersistentEntityResource<T>
extends Resource<T> {
    private final PersistentEntity<?, ?> entity;

    public static <T> PersistentEntityResource<T> wrap(PersistentEntity<?, ?> entity, T obj) {
        return new PersistentEntityResource<T>(entity, obj, new Link[0]);
    }

    public PersistentEntityResource(PersistentEntity<?, ?> entity, T content, Link ... links) {
        this(entity, content, Arrays.asList(links));
    }

    private PersistentEntityResource(PersistentEntity<?, ?> entity, T content, Iterable<Link> links) {
        super(content, links);
        this.entity = entity;
    }

    @JsonIgnore
    public PersistentEntity<?, ?> getPersistentEntity() {
        return this.entity;
    }
}

