/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.rest.core.invoke.RepositoryInvoker;
import org.springframework.data.rest.core.mapping.MethodResourceMapping;
import org.springframework.data.rest.core.mapping.ResourceMappings;
import org.springframework.data.rest.core.mapping.ResourceMetadata;
import org.springframework.data.rest.core.mapping.SearchResourceMappings;
import org.springframework.data.rest.webmvc.AbstractRepositoryRestController;
import org.springframework.data.rest.webmvc.ControllerUtils;
import org.springframework.data.rest.webmvc.PersistentEntityResourceAssembler;
import org.springframework.data.rest.webmvc.RepositoryRestController;
import org.springframework.data.rest.webmvc.RepositoryRestRequest;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.data.web.PagedResourcesAssembler;
import org.springframework.hateoas.EntityLinks;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.LinkBuilder;
import org.springframework.hateoas.Links;
import org.springframework.hateoas.Resource;
import org.springframework.hateoas.ResourceSupport;
import org.springframework.hateoas.Resources;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@RepositoryRestController
class RepositorySearchController
extends AbstractRepositoryRestController {
    private static final String SEARCH = "/search";
    private static final String BASE_MAPPING = "/{repository}/search";
    private static final String PARAMETER_NAME_TEMPALTE_PATTERN = "{?%s}";
    private final EntityLinks entityLinks;
    private final ResourceMappings mappings;
    private final PagedResourcesAssembler<Object> assembler;

    @Autowired
    public RepositorySearchController(PagedResourcesAssembler<Object> assembler, PersistentEntityResourceAssembler<Object> perAssembler, EntityLinks entityLinks, ResourceMappings mappings) {
        super(assembler, perAssembler);
        Assert.notNull((Object)entityLinks, (String)"EntityLinks must not be null!");
        Assert.notNull((Object)mappings, (String)"ResourceMappings must not be null!");
        this.entityLinks = entityLinks;
        this.mappings = mappings;
        this.assembler = assembler;
    }

    @ResponseBody
    @RequestMapping(value={"/{repository}/search"}, method={RequestMethod.GET})
    public ResourceSupport listSearches(RepositoryRestRequest request) {
        SearchResourceMappings resourceMappings = request.getSearchMappings();
        if (!resourceMappings.isExported()) {
            throw new ResourceNotFoundException();
        }
        Links queryMethodLinks = this.getSearchLinks(request.getDomainType());
        if (queryMethodLinks.isEmpty()) {
            throw new ResourceNotFoundException();
        }
        ResourceSupport result = new ResourceSupport();
        result.add((Iterable)queryMethodLinks);
        return result;
    }

    @ResponseBody
    @RequestMapping(value={"/{repository}/search/{search}"}, method={RequestMethod.GET})
    public ResponseEntity<Resources<?>> executeSearch(RepositoryRestRequest request, @PathVariable String search, Pageable pageable) {
        Method method = this.checkExecutability(request, search);
        Resources<?> resources = this.executeQueryMethod(request, method, pageable);
        return new ResponseEntity(resources, HttpStatus.OK);
    }

    @ResponseBody
    @RequestMapping(value={"/{repository}/search/{method}"}, method={RequestMethod.GET}, produces={"application/x-spring-data-compact+json"})
    public ResourceSupport executeSearchCompact(RepositoryRestRequest repoRequest, @PathVariable String repository, @PathVariable String search, Pageable pageable) {
        Method method = this.checkExecutability(repoRequest, search);
        Resources<?> resource = this.executeQueryMethod(repoRequest, method, pageable);
        ArrayList<Link> links = new ArrayList<Link>();
        if (resource instanceof Resources && resource.getContent() != null) {
            for (Object obj : resource.getContent()) {
                if (null == obj || !(obj instanceof Resource)) continue;
                Resource res = (Resource)obj;
                links.add(this.resourceLink(repoRequest, res));
            }
        } else if (resource instanceof Resource) {
            Resource res = (Resource)resource;
            links.add(this.resourceLink(repoRequest, res));
        }
        return new Resource(ControllerUtils.EMPTY_RESOURCE_LIST, links);
    }

    private Method checkExecutability(RepositoryRestRequest request, String searchName) {
        ResourceMetadata metadata = request.getResourceMetadata();
        SearchResourceMappings searchMapping = metadata.getSearchResourceMappings();
        if (!searchMapping.isExported()) {
            throw new ResourceNotFoundException();
        }
        Method method = searchMapping.getMappedMethod(searchName);
        if (method == null) {
            throw new ResourceNotFoundException();
        }
        return method;
    }

    private Resources<?> executeQueryMethod(RepositoryRestRequest repoRequest, Method method, Pageable pageable) {
        RepositoryInvoker repoMethodInvoker = repoRequest.getRepositoryInvoker();
        Map parameters = repoRequest.getRequest().getParameterMap();
        Object result = repoMethodInvoker.invokeQueryMethod(method, parameters, pageable, null);
        return this.resultToResources(result);
    }

    private Links getSearchLinks(Class<?> domainType) {
        ArrayList<Link> links = new ArrayList<Link>();
        SearchResourceMappings searchMappings = this.mappings.getSearchResourceMappings(domainType);
        LinkBuilder builder = this.entityLinks.linkFor(domainType).slash((Object)searchMappings.getPath());
        for (MethodResourceMapping mapping : searchMappings) {
            if (!mapping.isExported()) continue;
            String parameterTemplateVariable = RepositorySearchController.getParameterTemplateVariable(mapping.getParameterNames());
            String href = builder.slash((Object)mapping.getPath()).toString().concat(parameterTemplateVariable);
            Link link = new Link(href, mapping.getRel());
            if (mapping.isPagingResource()) {
                link = this.assembler.appendPaginationParameterTemplates(link);
            }
            links.add(link);
        }
        return new Links(links);
    }

    private static String getParameterTemplateVariable(Collection<String> parameters) {
        String parameterString = StringUtils.collectionToCommaDelimitedString(parameters);
        return parameters.isEmpty() ? "" : String.format(PARAMETER_NAME_TEMPALTE_PATTERN, parameterString);
    }
}

