/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.alps;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.rest.core.config.RepositoryRestConfiguration;
import org.springframework.data.rest.webmvc.BaseUri;
import org.springframework.data.rest.webmvc.RepositoryLinksResource;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.ResourceProcessor;
import org.springframework.util.Assert;

public class AlpsResourceProcessor
implements ResourceProcessor<RepositoryLinksResource> {
    private static final String PROFILE_REL = "profile";
    private final RepositoryRestConfiguration configuration;

    @Autowired
    public AlpsResourceProcessor(RepositoryRestConfiguration configuration) {
        Assert.notNull((Object)configuration, (String)"RepositoryRestConfiguration must not be null!");
        this.configuration = configuration;
    }

    public RepositoryLinksResource process(RepositoryLinksResource resource) {
        if (this.configuration.metadataConfiguration().alpsEnabled()) {
            BaseUri baseUri = new BaseUri(this.configuration.getBaseUri());
            String href = baseUri.getUriComponentsBuilder().path("/alps").build().toString();
            resource.add(new Link(href, PROFILE_REL));
        }
        return resource;
    }
}

