/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.config;

import org.springframework.core.MethodParameter;
import org.springframework.data.repository.support.Repositories;
import org.springframework.data.rest.core.mapping.ResourceMappings;
import org.springframework.data.rest.core.projection.ProjectionDefinitions;
import org.springframework.data.rest.core.projection.ProjectionFactory;
import org.springframework.data.rest.webmvc.PersistentEntityResourceAssembler;
import org.springframework.data.rest.webmvc.support.PersistentEntityProjector;
import org.springframework.hateoas.EntityLinks;
import org.springframework.util.Assert;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class PersistentEntityResourceAssemblerArgumentResolver
implements HandlerMethodArgumentResolver {
    private final Repositories repositories;
    private final EntityLinks entityLinks;
    private final ProjectionDefinitions projectionDefinitions;
    private final ProjectionFactory projectionFactory;
    private final ResourceMappings mappings;

    public PersistentEntityResourceAssemblerArgumentResolver(Repositories repositories, EntityLinks entityLinks, ProjectionDefinitions projectionDefinitions, ProjectionFactory projectionFactory, ResourceMappings mappings) {
        Assert.notNull((Object)repositories, (String)"Repositories must not be null!");
        Assert.notNull((Object)entityLinks, (String)"EntityLinks must not be null!");
        Assert.notNull((Object)projectionDefinitions, (String)"ProjectionDefinitions must not be null!");
        Assert.notNull((Object)projectionFactory, (String)"ProjectionFactory must not be null!");
        this.repositories = repositories;
        this.entityLinks = entityLinks;
        this.projectionDefinitions = projectionDefinitions;
        this.projectionFactory = projectionFactory;
        this.mappings = mappings;
    }

    public boolean supportsParameter(MethodParameter parameter) {
        return PersistentEntityResourceAssembler.class.equals((Object)parameter.getParameterType());
    }

    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        String projectionParameter = webRequest.getParameter(this.projectionDefinitions.getParameterName());
        PersistentEntityProjector projector = new PersistentEntityProjector(this.projectionDefinitions, this.projectionFactory, projectionParameter, this.mappings);
        return new PersistentEntityResourceAssembler(this.repositories, this.entityLinks, projector, this.mappings);
    }
}

