/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.convert;

import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.data.geo.Point;

public enum StringToPointConverter implements Converter<String, Point>
{
    INSTANCE;

    public static final GenericConverter.ConvertiblePair CONVERTIBLE;
    private static final String INVALID_FORMAT = "Expected two doubles separated by a semicolon but got '%s'!";

    public Point convert(String source) {
        String[] parts = source.split(",");
        if (parts.length != 2) {
            throw new IllegalArgumentException(String.format(INVALID_FORMAT, source));
        }
        try {
            double latitude = Double.parseDouble(parts[0]);
            double longitude = Double.parseDouble(parts[1]);
            return new Point(longitude, latitude);
        }
        catch (NumberFormatException o_O) {
            throw new IllegalArgumentException(String.format(INVALID_FORMAT, source), o_O);
        }
    }

    static {
        CONVERTIBLE = new GenericConverter.ConvertiblePair(String.class, Point.class);
    }
}

